/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.OperationAuthorProvider;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOperationAuthorProvider
implements OperationAuthorProvider {
    private static final String UNKOWN = "UNKOWN";
    private final Map<String, String> operationAuthorMap = new LinkedHashMap<String, String>();

    public DefaultOperationAuthorProvider(List<AbstractChangePackage> leftChanges, List<AbstractChangePackage> rightChanges) {
        for (AbstractChangePackage changePackage : leftChanges) {
            this.scanIntoAuthorMap(changePackage);
        }
        for (AbstractChangePackage changePackage : rightChanges) {
            this.scanIntoAuthorMap(changePackage);
        }
    }

    private void scanIntoAuthorMap(AbstractChangePackage changePackage) {
        if (changePackage.getLogMessage() == null) {
            return;
        }
        LogMessage logMessage = changePackage.getLogMessage();
        if (logMessage.getAuthor() != null) {
            String author = logMessage.getAuthor();
            ESCloseableIterable operations = changePackage.operations();
            try {
                for (AbstractOperation operation : operations.iterable()) {
                    this.operationAuthorMap.put(operation.getIdentifier(), author);
                }
            }
            finally {
                operations.close();
            }
        }
    }

    @Override
    public String getAuthor(AbstractOperation operation) {
        String author = this.operationAuthorMap.get(operation);
        if (author == null) {
            author = UNKOWN;
        }
        return author;
    }
}

