/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.emfstore.common.ESResourceSetProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESPriorityComparator;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.AdminEmfStore;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.EMFStoreInterface;
import org.eclipse.emf.emfstore.internal.server.Messages;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.connection.ConnectionHandler;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.XmlRpcAdminConnectionHandler;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.XmlRpcConnectionHandler;
import org.eclipse.emf.emfstore.internal.server.core.AdminEmfStoreImpl;
import org.eclipse.emf.emfstore.internal.server.core.EMFStoreImpl;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.core.helper.EPackageHelper;
import org.eclipse.emf.emfstore.internal.server.core.helper.ResourceHelper;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.startup.PostStartupListener;
import org.eclipse.emf.emfstore.internal.server.startup.ServerHrefMigrator;
import org.eclipse.emf.emfstore.internal.server.startup.StartupListener;
import org.eclipse.emf.emfstore.internal.server.storage.ServerXMIResourceSetProvider;
import org.eclipse.emf.emfstore.server.ESDynamicModelProvider;
import org.eclipse.emf.emfstore.server.ESServerURIUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESServerInitException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFStoreController
implements IApplication,
Runnable {
    private static final String EMFSTORE_TXT_FILE = "emfstore.txt";
    private static final String SUPERUSRE_DESCRIPTION = "default server admin (superuser)";
    private static final String SUPERUSER_LAST_NAME = "user";
    private static final String SUPERUSER_FIRST_NAME = "super";
    private static final String RESOURCE_SET_PROVIDER = "org.eclipse.emf.emfstore.server.resourceSetProvider";
    private static final String CONFIG_RESOURCE_KEY = "org.eclipse.emf.emfstore.server.configurationResource";
    private static final String EMFSTORE_COMMON_BUNDLE = "org.eclipse.emf.emfstore.common.model";
    private static final String ORG_ECLIPSE_EMF_EMFSTORE_SERVER_DYNAMIC_MODEL_PROVIDER = "org.eclipse.emf.emfstore.server.dynamicModelProvider";
    private static EMFStoreController instance;
    private EMFStore emfStore;
    private AdminEmfStore adminEmfStore;
    private AccessControl accessControl;
    private Set<ConnectionHandler<? extends EMFStoreInterface>> connectionHandlers;
    private ServerSpace serverSpace;
    private Resource resource;

    public synchronized Object start(IApplicationContext context) throws FatalESException {
        this.run(true);
        instance = null;
        ModelUtil.logInfo((String)Messages.EMFStoreController_Server_Stopped);
        return IApplication.EXIT_OK;
    }

    public synchronized void run(boolean waitForTermination) throws FatalESException {
        if (instance != null) {
            throw new FatalESException(Messages.EMFStoreController_EMFStore_Controller_Already_Running);
        }
        instance = this;
        this.serverHeader();
        this.initLogging();
        this.copyFileToWorkspace(ServerConfiguration.getConfFile(), "es.properties", Messages.EMFStoreController_Could_Not_Copy_Properties_File, Messages.EMFStoreController_Default_Properties_File_Copied);
        this.initProperties();
        this.logGeneralInformation();
        this.registerDynamicModels();
        this.serverSpace = this.initServerSpace();
        this.initializeBranchesIfRequired(this.serverSpace);
        this.handleStartupListener();
        this.accessControl = EMFStoreController.initAccessControl(this.serverSpace);
        this.emfStore = EMFStoreImpl.createInterface(this.serverSpace, this.accessControl);
        this.adminEmfStore = new AdminEmfStoreImpl(this.serverSpace, this.accessControl);
        this.copyFileToWorkspace(ServerConfiguration.getServerKeyStorePath(), "emfstoreServer.keystore", Messages.EMFStoreController_Failed_To_Copy_Keystore, Messages.EMFStoreController_Keystore_Copied);
        this.connectionHandlers = this.initConnectionHandlers();
        this.handlePostStartupListener();
        this.registerShutdownHook();
        ModelUtil.logInfo((String)Messages.EMFStoreController_Init_Complete);
        ModelUtil.logInfo((String)Messages.EMFStoreController_Server_Running);
        if (waitForTermination) {
            this.waitForTermination();
        }
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                EMFStoreController.this.stopServer();
            }
        });
    }

    private void logGeneralInformation() {
        ModelUtil.logInfo((String)(String.valueOf(Messages.EMFStoreController_Server_Home) + ServerConfiguration.getServerHome()));
        ModelUtil.logInfo((String)MessageFormat.format(Messages.EMFStoreController_JVM_Max_Memory, Runtime.getRuntime().maxMemory() / 1000000L));
    }

    private void initializeBranchesIfRequired(ServerSpace serverSpace) throws FatalESException {
        for (ProjectHistory project : serverSpace.getProjects()) {
            if (project.getBranches().size() != 0) continue;
            BranchInfo branchInfo = VersioningFactory.eINSTANCE.createBranchInfo();
            branchInfo.setName("trunk");
            branchInfo.setHead((PrimaryVersionSpec)ModelUtil.clone((EObject)project.getLastVersion().getPrimarySpec()));
            branchInfo.setSource((PrimaryVersionSpec)ModelUtil.clone((EObject)Versions.createPRIMARY((String)"trunk", (int)0)));
            project.getBranches().add((Object)branchInfo);
            new ResourceHelper(serverSpace).save((EObject)project);
        }
    }

    private void registerDynamicModels() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint(ORG_ECLIPSE_EMF_EMFSTORE_SERVER_DYNAMIC_MODEL_PROVIDER, true, (Comparator)new ESPriorityComparator("priority", true));
        ESDynamicModelProvider dynamicModelProvider = (ESDynamicModelProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESDynamicModelProvider.class);
        List<EPackage> models = dynamicModelProvider.getDynamicModels();
        for (EPackage model : models) {
            EPackage.Registry.INSTANCE.put((Object)model.getNsURI(), (Object)model);
            List<EPackage> packages = EPackageHelper.getAllSubPackages(model);
            for (EPackage subPkg : packages) {
                EPackage.Registry.INSTANCE.put((Object)subPkg.getNsURI(), (Object)subPkg);
            }
            ModelUtil.logInfo((String)MessageFormat.format(Messages.EMFStoreController_Dynamic_Model_Loaded, model.getNsURI()));
        }
    }

    private void initLogging() {
        Platform.getLog((Bundle)Platform.getBundle((String)EMFSTORE_COMMON_BUNDLE)).addLogListener(new ILogListener(){

            public void logging(IStatus status, String plugin) {
                if (status.getSeverity() == 1) {
                    System.out.println(status.getMessage());
                } else if (!status.isOK()) {
                    System.err.println(status.getMessage());
                    Throwable exception = status.getException();
                    if (exception != null) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        });
    }

    private void handleStartupListener() {
        String property = ServerConfiguration.getProperties().getProperty("emfstore.startup.loadlistener", ServerConfiguration.LOAD_STARTUP_LISTENER_DEFAULT);
        if (Boolean.TRUE.toString().equals(property)) {
            ModelUtil.logInfo((String)"Notifying startup listener");
            for (StartupListener listener : ServerConfiguration.getStartupListeners()) {
                listener.startedUp((List<ProjectHistory>)this.serverSpace.getProjects());
            }
        }
    }

    private void handlePostStartupListener() {
        String property = ServerConfiguration.getProperties().getProperty("emfstore.startup.post.loadlistener", ServerConfiguration.LOAD_STARTUP_LISTENER_DEFAULT);
        if (Boolean.TRUE.toString().equals(property)) {
            ModelUtil.logInfo((String)"Notifying post startup listener");
            for (PostStartupListener listener : ServerConfiguration.getPostStartupListeners()) {
                listener.postStartUp(this.serverSpace, this.accessControl, this.connectionHandlers);
            }
        }
    }

    private void copyFileToWorkspace(String target, String source, String failure, String success) {
        File targetFile = new File(target);
        if (!targetFile.exists()) {
            String attribute;
            ESExtensionPoint extensionPoint = new ESExtensionPoint(CONFIG_RESOURCE_KEY);
            ESExtensionElement element = extensionPoint.getFirst();
            if (element != null && (attribute = element.getAttribute(targetFile.getName())) != null) {
                try {
                    FileUtil.copyFile((InputStream)new URL("platform:/plugin/" + element.getIConfigurationElement().getNamespaceIdentifier() + "/" + attribute).openConnection().getInputStream(), (File)targetFile);
                    return;
                }
                catch (IOException e) {
                    ModelUtil.logWarning((String)MessageFormat.format(Messages.EMFStoreController_Copy_From_To, source, target), (Throwable)e);
                }
            }
            try {
                FileUtil.copyFile((InputStream)this.getClass().getResourceAsStream(source), (File)targetFile);
            }
            catch (IOException e) {
                ModelUtil.logWarning((String)MessageFormat.format("Copy of file from {0} to {1} failed.", source, target), (Throwable)e);
            }
        }
    }

    private Set<ConnectionHandler<? extends EMFStoreInterface>> initConnectionHandlers() throws FatalESException {
        LinkedHashSet<ConnectionHandler<? extends EMFStoreInterface>> connectionHandlers = new LinkedHashSet<ConnectionHandler<? extends EMFStoreInterface>>();
        try {
            XmlRpcConnectionHandler xmlRpcConnectionHander = new XmlRpcConnectionHandler();
            xmlRpcConnectionHander.init(this.emfStore, this.accessControl);
            connectionHandlers.add(xmlRpcConnectionHander);
            XmlRpcAdminConnectionHandler xmlRpcAdminConnectionHander = new XmlRpcAdminConnectionHandler();
            xmlRpcAdminConnectionHander.init(this.adminEmfStore, this.accessControl);
            connectionHandlers.add(xmlRpcAdminConnectionHander);
        }
        catch (ESServerInitException ex) {
            throw new FatalESException(Messages.EMFStoreController_ConnectionHandlersInitException, ex);
        }
        return connectionHandlers;
    }

    private ServerSpace initServerSpace() throws FatalESException {
        ESResourceSetProvider resourceSetProvider = this.getResourceSetProvider();
        ResourceSet resourceSet = resourceSetProvider.getResourceSet();
        URI serverspaceURI = ESServerURIUtil.createServerSpaceURI();
        if (!resourceSet.getURIConverter().exists(serverspaceURI, null)) {
            try {
                this.resource = resourceSet.createResource(serverspaceURI);
                ServerSpace serverspace = ModelFactory.eINSTANCE.createServerSpace();
                this.resource.getContents().add((Object)serverspace);
                ModelUtil.saveResource((Resource)this.resource, (IResourceLogger)ModelUtil.getResourceLogger());
            }
            catch (IOException e) {
                throw new FatalESException(Messages.EMFStoreController_Could_Not_Init_XMLResource, e);
            }
        } else {
            if (resourceSetProvider instanceof ServerXMIResourceSetProvider && !new ServerHrefMigrator().migrate()) {
                throw new FatalESException(Messages.EMFStoreController_Error_During_Migration);
            }
            this.resource = resourceSet.createResource(serverspaceURI);
        }
        try {
            this.resource.load(ModelUtil.getResourceLoadOptions());
        }
        catch (IOException e) {
            throw new FatalESException("Couldn't load data from database.", e);
        }
        ServerSpace result = null;
        EList contents = this.resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof ServerSpace)) continue;
            result = (ServerSpace)content;
            break;
        }
        if (result != null) {
            result.setResource(this.resource);
        } else {
            ModelUtil.logInfo((String)Messages.EMFStoreController_Creating_Initial_ServerSpace);
            result = ModelFactory.eINSTANCE.createServerSpace();
            result.setResource(this.resource);
            this.resource.getContents().add((Object)result);
            try {
                result.save();
            }
            catch (IOException e) {
                throw new FatalESException("Couldn't save data in database.", e);
            }
        }
        return result;
    }

    private ESResourceSetProvider getResourceSetProvider() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint(RESOURCE_SET_PROVIDER, true, (Comparator)new ESPriorityComparator("priority", true));
        ESResourceSetProvider resourceSetProvider = (ESResourceSetProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESResourceSetProvider.class);
        return resourceSetProvider;
    }

    public static EMFStoreController getInstance() {
        return instance;
    }

    private static synchronized AccessControl initAccessControl(ServerSpace serverSpace) throws FatalESException {
        EMFStoreController.setSuperUser(serverSpace);
        return new AccessControl(serverSpace);
    }

    private static void setSuperUser(ServerSpace serverSpace) throws FatalESException {
        String superuser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", SUPERUSER_FIRST_NAME);
        for (ACUser user : serverSpace.getUsers()) {
            if (!user.getName().equals(superuser)) continue;
            return;
        }
        ACUser superUser = AccesscontrolFactory.eINSTANCE.createACUser();
        superUser.setName(superuser);
        superUser.setFirstName(SUPERUSER_FIRST_NAME);
        superUser.setLastName(SUPERUSER_LAST_NAME);
        superUser.setDescription(SUPERUSRE_DESCRIPTION);
        superUser.getRoles().add((Object)RolesFactory.eINSTANCE.createServerAdmin());
        serverSpace.getUsers().add((Object)superUser);
        try {
            serverSpace.save();
        }
        catch (IOException e) {
            throw new FatalESException("Couldn't save data in database.", e);
        }
        ModelUtil.logInfo((String)(String.valueOf(Messages.EMFStoreController_Added_SuperUser) + superuser));
    }

    private Properties initProperties() {
        File propertyFile = new File(ServerConfiguration.getConfFile());
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(propertyFile);
                properties.load(fis);
                ServerConfiguration.setProperties(properties, false);
                ModelUtil.logInfo((String)MessageFormat.format(Messages.EMFStoreController_PropertyFile_Read, propertyFile.getAbsolutePath()));
            }
            catch (IOException e) {
                ModelUtil.logWarning((String)Messages.EMFStoreController_Property_Init_Failed, (Throwable)e);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e2) {
                    ModelUtil.logWarning((String)Messages.EMFStoreController_Closing_Of_Properties_File_Failed, (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                ModelUtil.logWarning((String)Messages.EMFStoreController_Closing_Of_Properties_File_Failed, (Throwable)e);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (instance == null) {
            return;
        }
        this.wakeForTermination();
        if (this.connectionHandlers != null) {
            Object monitor;
            Object object = monitor = MonitorProvider.getInstance().getMonitor();
            synchronized (object) {
                for (ConnectionHandler<? extends EMFStoreInterface> handler : this.connectionHandlers) {
                    handler.stop();
                }
            }
        }
        ModelUtil.logInfo((String)Messages.EMFStoreController_Server_Was_Stopped);
        instance = null;
        this.wakeForTermination();
    }

    public void shutdown(FatalESException exception) {
        ModelUtil.logWarning((String)Messages.EMFStoreController_Stopping_All_ConnectionHandlers);
        if (this.connectionHandlers != null) {
            for (ConnectionHandler<? extends EMFStoreInterface> handler : this.connectionHandlers) {
                ModelUtil.logWarning((String)MessageFormat.format(Messages.EMFStoreController_Stopping_ConnectionHandler, handler.getName()));
                handler.stop();
                ModelUtil.logWarning((String)MessageFormat.format(Messages.EMFStoreController_ConnectionHandler_Stopped, handler.getName()));
            }
        }
        ModelUtil.logException((String)Messages.EMFStoreController_Serve_Forcefully_Stopped, (Throwable)exception);
        ModelUtil.logException((String)Messages.EMFStoreController_Cause_For_Server_Shutdown, (Throwable)exception.getCause());
        this.wakeForTermination();
    }

    private synchronized void waitForTermination() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            ModelUtil.logWarning((String)Messages.EMFStoreController_Waiting_For_Termination_Interrupted, (Throwable)e);
        }
    }

    private synchronized void wakeForTermination() {
        this.notify();
    }

    private void serverHeader() {
        block12: {
            InputStream inputStream = this.getClass().getResourceAsStream(EMFSTORE_TXT_FILE);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException iOException) {
                    try {
                        reader.close();
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void run() {
        try {
            this.run(false);
        }
        catch (FatalESException e) {
            throw new RuntimeException(e);
        }
    }

    public static EMFStoreController runAsNewThread() throws FatalESException {
        EMFStoreController emfStoreController = new EMFStoreController();
        Thread thread = new Thread(emfStoreController);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            throw new FatalESException(e);
        }
        return emfStoreController;
    }

    public ServerSpace getServerSpace() {
        return this.serverSpace;
    }

    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    public void stop() {
        this.stopServer();
    }
}

