/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRemoveServerController
extends AbstractEMFStoreUIController<Void> {
    private final ServerInfo serverInfo;

    public UIRemoveServerController(Shell shell, ESServer server) {
        super(shell);
        this.serverInfo = (ServerInfo)((ESServerImpl)server).toInternalAPI();
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        boolean shouldDelete = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.UIRemoveServerController_Confirmation, (String)String.format(Messages.UIRemoveServerController_DeleteProject_Prompt, this.serverInfo.getName()));
        if (!shouldDelete) {
            return null;
        }
        ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
        EList projectSpaces = ((Workspace)workspace.toInternalAPI()).getProjectSpaces();
        ArrayList<ProjectSpace> usedSpaces = new ArrayList<ProjectSpace>();
        for (ProjectSpace projectSpace : projectSpaces) {
            if (projectSpace.getUsersession() == null || !projectSpace.getUsersession().getServerInfo().equals(this.serverInfo)) continue;
            usedSpaces.add(projectSpace);
        }
        RunInUI.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ESWorkspaceProviderImpl.getInstance().getWorkspace().getServers().remove(UIRemoveServerController.this.serverInfo);
                return null;
            }
        });
        if (usedSpaces.size() == 0) {
            new EMFStoreCommand(){

                protected void doRun() {
                    EcoreUtil.delete((EObject)UIRemoveServerController.this.serverInfo);
                }
            }.run(false);
            return null;
        }
        StringBuilder message = new StringBuilder();
        for (ProjectSpace pSpace : usedSpaces) {
            message.append(String.valueOf(Messages.UIRemoveServerController_Newline) + pSpace.getProjectName());
        }
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.UIRemoveServerController_ErrorDelete_Title, (String)String.format(String.valueOf(Messages.UIRemoveServerController_ErrorDelete_Message) + message.toString(), this.serverInfo.getName()));
        return null;
    }
}

