/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.common.MonitoredEMFStoreAction;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEMFStoreUIController<T>
extends MonitoredEMFStoreAction<T> {
    private Shell shell;

    public AbstractEMFStoreUIController(Shell shell) {
        super(false, false);
        this.setShell(shell);
    }

    public AbstractEMFStoreUIController(Shell shell, boolean cancelable) {
        super(false, cancelable);
        this.setShell(shell);
    }

    public AbstractEMFStoreUIController(Shell shell, boolean fork, boolean cancelable) {
        super(fork, cancelable);
        this.setShell(shell);
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell newShell) {
        this.shell = newShell;
    }

    public boolean confirm(final String title, final String message) {
        if (this.isForked()) {
            return RunInUI.runWithResult(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    MessageDialog dialog = new MessageDialog(AbstractEMFStoreUIController.this.shell, title, null, message, 3, new String[]{"Yes", "No"}, 0);
                    int result = dialog.open();
                    if (result == 0) {
                        return true;
                    }
                    return false;
                }
            });
        }
        MessageDialog dialog = new MessageDialog(this.shell, title, null, message, 3, new String[]{"Yes", "No"}, 0);
        int result = dialog.open();
        return result == 0;
    }

    @Override
    protected void handleException(final ESException e) {
        WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
        if (this.isForked()) {
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MessageDialog.openError((Shell)AbstractEMFStoreUIController.this.getShell(), (String)"Error", (String)e.getMessage());
                    return null;
                }
            });
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
        }
    }
}

