/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.deser;

import com.fasterxml.jackson.databind.DatabindContext;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntries;
import org.eclipse.emfcloud.jackson.handlers.URIHandler;
import org.eclipse.emfcloud.jackson.utils.EObjects;

public interface ReferenceEntry {
    public void resolve(DatabindContext var1, URIHandler var2);

    public static class ForMapEntry
    extends Base {
        private EObject proxyValue;

        public ForMapEntry(EObject owner, EReference reference, String id, String type) {
            super(owner, reference, id, type);
        }

        @Override
        public void resolve(DatabindContext context, URIHandler handler) {
            if (this.proxyValue == null) {
                super.resolve(context, handler);
                return;
            }
            Consumer<EObject> replaceProxy = target -> {
                if (target != this.proxyValue) {
                    EcoreUtil.replace((EObject)this.owner, (EStructuralFeature)this.reference, (Object)this.proxyValue, (Object)target);
                }
            };
            ReferenceEntries entries = EMFContext.getEntries(context);
            ResourceSet resourceSet = EMFContext.getResourceSet(context);
            EObject target2 = entries.get(this.id);
            if (target2 == null) {
                Resource resource = EMFContext.getResource(context, this.owner);
                target2 = resource.getEObject(this.id);
                if (target2 == null) {
                    URI baseURI = resource.getURI().trimFragment();
                    URI uri = handler.resolve(baseURI, URI.createURI((String)this.id));
                    if (this.proxyValue instanceof InternalEObject) {
                        ((InternalEObject)this.proxyValue).eSetProxyURI(uri);
                    }
                    if (!this.reference.isResolveProxies()) {
                        target2 = EcoreUtil.resolve((EObject)this.proxyValue, (ResourceSet)resourceSet);
                        replaceProxy.accept(target2);
                    }
                } else {
                    replaceProxy.accept(target2);
                }
                entries.store(this.id, target2);
            } else {
                replaceProxy.accept(target2);
            }
        }

        public FeatureMap.Entry createFeatureMapEntry(DatabindContext context) {
            ResourceSet resourceSet = EMFContext.getResourceSet(context);
            this.proxyValue = this.createProxy(resourceSet, URI.createURI((String)this.id));
            return FeatureMapUtil.createEntry((EStructuralFeature)this.reference, (Object)this.proxyValue);
        }
    }

    public static class Base
    implements ReferenceEntry {
        protected final EObject owner;
        protected final EReference reference;
        protected final String id;
        private final String type;

        public Base(EObject owner, EReference reference, String id) {
            this(owner, reference, id, null);
        }

        public Base(EObject owner, EReference reference, String id, String type) {
            this.owner = owner;
            this.reference = reference;
            this.id = id;
            this.type = type;
        }

        @Override
        public void resolve(DatabindContext context, URIHandler handler) {
            if (this.id == null) {
                return;
            }
            ReferenceEntries entries = EMFContext.getEntries(context);
            ResourceSet resourceSet = EMFContext.getResourceSet(context);
            EObject target = entries.get(this.id);
            if (target == null) {
                Resource resource = EMFContext.getResource(context, this.owner);
                target = resource.getEObject(this.id);
                if (target == null) {
                    URI baseURI = resource.getURI().trimFragment();
                    URI uri = handler.resolve(baseURI, URI.createURI((String)this.id));
                    target = this.reference.isResolveProxies() && this.type != null ? this.createProxy(resourceSet, uri) : resourceSet.getEObject(uri, true);
                }
                if (target != null) {
                    entries.store(this.id, target);
                }
            }
            if (target != null) {
                EObjects.setOrAdd(this.owner, this.reference, target);
            }
        }

        protected EObject createProxy(ResourceSet resourceSet, URI uri) {
            EClass eClass;
            try {
                eClass = (EClass)resourceSet.getEObject(URI.createURI((String)this.type), true);
            }
            catch (Exception e) {
                return null;
            }
            if (eClass == null) {
                return null;
            }
            EObject object = EcoreUtil.create((EClass)eClass);
            if (object instanceof InternalEObject) {
                ((InternalEObject)object).eSetProxyURI(uri);
            }
            return object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Base that = (Base)o;
            if (!this.owner.equals(that.owner)) {
                return false;
            }
            if (!this.reference.equals(that.reference)) {
                return false;
            }
            if (!this.id.equals(that.id)) {
                return false;
            }
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        public int hashCode() {
            int result = this.owner.hashCode();
            result = 31 * result + this.reference.hashCode();
            result = 31 * result + this.id.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

