/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.data;

import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.data.CProjectExtraDataManagerProxy;

public class CProjectAttributes {
    public static String getCmsisAttribute(ILaunchConfiguration configuration, String attributeName) {
        ICConfigurationDescription cConfigDescription = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
        String atttributeValue = null;
        if (cConfigDescription != null) {
            IConfiguration config = EclipseUtils.getConfigurationFromDescription((ICConfigurationDescription)cConfigDescription);
            CProjectExtraDataManagerProxy dataManager = CProjectExtraDataManagerProxy.getInstance();
            Map<String, String> propertiesMap = dataManager.getExtraProperties(config);
            if (propertiesMap != null) {
                atttributeValue = propertiesMap.get(attributeName);
            }
        }
        return atttributeValue;
    }

    public static String getCmsisDeviceVariantName(ILaunchConfiguration configuration) {
        String variantName = CProjectAttributes.getCmsisAttribute(configuration, "cmsis.device.variant.name");
        if (variantName != null && !variantName.isEmpty()) {
            return variantName;
        }
        return CProjectAttributes.getCmsisDeviceName(configuration);
    }

    public static String getCmsisDeviceName(ILaunchConfiguration configuration) {
        return CProjectAttributes.getCmsisAttribute(configuration, "cmsis.device.name");
    }

    public static String getCmsisBoardName(ILaunchConfiguration configuration) {
        return CProjectAttributes.getCmsisAttribute(configuration, "cmsis.board.name");
    }
}

