/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.Xml;
import org.eclipse.embedcdt.core.XpackUtils;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.data.DataManagerEvent;
import org.eclipse.embedcdt.packs.core.data.DataUtils;
import org.eclipse.embedcdt.packs.core.data.DurationMonitor;
import org.eclipse.embedcdt.packs.core.data.IDataManagerListener;
import org.eclipse.embedcdt.packs.core.data.IPacksDataManager;
import org.eclipse.embedcdt.packs.core.data.JsonJsGenericParser;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.data.Repos;
import org.eclipse.embedcdt.packs.core.data.XcdlGenericParser;
import org.eclipse.embedcdt.packs.core.data.cmsis.PdscGenericParser;
import org.eclipse.embedcdt.packs.core.data.cmsis.PdscTreeParserForBuild;
import org.eclipse.embedcdt.packs.core.data.xcdl.InstalledDevicesParser;
import org.eclipse.embedcdt.packs.core.data.xcdl.InstalledDevicesSerialiser;
import org.eclipse.embedcdt.packs.core.jstree.JsObject;
import org.eclipse.embedcdt.packs.core.tree.AbstractTreePreOrderIterator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.core.tree.PackNode;
import org.eclipse.embedcdt.packs.core.tree.Selector;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class DataManager
implements IPacksDataManager {
    private static final DataManager fgInstance = new DataManager();
    private Node fRepositoriesTree = null;
    private List<PackNode> fPacksVersionsList = null;
    private Map<String, Map<String, PackNode>> fPacksVersionsMap;
    private Map<String, PackNode> fPacksMap;
    private Map<String, Node> fParsedPdsc = null;
    private List<PackNode> fInstalledPacksLatestVersionsList = null;
    private Node fInstalledObjectsForBuild = null;
    private IConfiguration fInstalledConfig = null;
    private Node fConfigObjectsForBuild = null;
    private IConsoleStream fOut = Activator.getInstance().getConsoleOutput();
    private List<IDataManagerListener> fListeners = new ArrayList<IDataManagerListener>();
    private Map<String, Leaf> fInstalledDevicesMap;
    private Map<String, Leaf> fInstalledBoardsMap;

    public static DataManager getInstance() {
        return fgInstance;
    }

    public DataManager() {
        this.fPacksVersionsMap = new TreeMap<String, Map<String, PackNode>>();
        this.fPacksMap = new TreeMap<String, PackNode>();
        this.fInstalledDevicesMap = new TreeMap<String, Leaf>();
        this.fInstalledBoardsMap = new TreeMap<String, Leaf>();
    }

    public void addListener(IDataManagerListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(IDataManagerListener listener) {
        this.fListeners.remove(listener);
    }

    public void notifyNewInput() {
        this.clearSummaryData();
        this.clearInstalledPacksLatestVersionsList();
        this.clearCachedInstalledObjectsForBuild();
        DataManagerEvent event = new DataManagerEvent(this, "new.input");
        this.notifyListener(event);
    }

    public void notifyInstallRemove() {
        this.clearSummaryData();
        this.clearInstalledPacksLatestVersionsList();
        this.clearCachedInstalledObjectsForBuild();
        DataManagerEvent event = new DataManagerEvent(this, "update.packs");
        this.notifyListener(event);
    }

    public void notifyUpdateView(String type, List<Leaf> list) {
        DataManagerEvent event = new DataManagerEvent(this, type, list);
        this.notifyListener(event);
    }

    public void notifyListener(DataManagerEvent event) {
        for (IDataManagerListener listener : this.fListeners) {
            listener.packsChanged(event);
        }
    }

    public void clearSummaryData() {
        this.fRepositoriesTree = null;
        this.fPacksVersionsList = null;
        this.fInstalledPacksLatestVersionsList = null;
    }

    @Override
    public Node getRepositoriesTree() {
        return this.getRepositoriesTree(new DurationMonitor());
    }

    private Node getRepositoriesTree(final DurationMonitor dm) {
        if (this.fRepositoriesTree != null) {
            return this.fRepositoriesTree;
        }
        assert (dm != null);
        dm.displayTimeAndRun(new Runnable(){

            @Override
            public void run() {
                DataManager.this.loadCachedReposContent(dm);
            }
        });
        return this.fRepositoriesTree;
    }

    private List<PackNode> getPacksVersionsList(DurationMonitor dm) {
        if (this.fPacksVersionsList != null) {
            return this.fPacksVersionsList;
        }
        this.getRepositoriesTree(dm);
        return this.fPacksVersionsList;
    }

    public PackNode findCmsisPackVersion(String vendorName, String packName, String version) {
        return this.findCmsisPackVersion(vendorName, packName, version, new DurationMonitor());
    }

    private PackNode findCmsisPackVersion(String vendorName, String packName, String version, DurationMonitor dm) {
        this.getRepositoriesTree(dm);
        String key = this.makeMapKey("cmsis", vendorName, packName);
        Map<String, PackNode> versionsMap = this.fPacksVersionsMap.get(key);
        if (versionsMap == null) {
            return null;
        }
        return versionsMap.get(version);
    }

    public PackNode findPackLatest(String vendorName, String packName) {
        return this.findPackLatest(vendorName, packName, new DurationMonitor());
    }

    private PackNode findPackLatest(String vendorName, String packName, DurationMonitor dm) {
        this.getRepositoriesTree(dm);
        String key = this.makeMapKey("cmsis", vendorName, packName);
        Map<String, PackNode> versionsMap = this.fPacksVersionsMap.get(key);
        if (versionsMap == null) {
            return null;
        }
        PackNode node = null;
        for (String versionName : versionsMap.keySet()) {
            node = versionsMap.get(versionName);
        }
        return node;
    }

    public String makeMapKey(String packType, String vendorName, String packName) {
        String key = String.valueOf(packType) + "::" + vendorName + "::" + packName;
        return key;
    }

    public void loadCachedReposContent() {
        this.loadCachedReposContent(null);
    }

    private void loadCachedReposContent(DurationMonitor dm) {
        Node node = new Node("root");
        this.fPacksVersionsList = Repos.getInstance().loadCachedReposContent(node);
        this.fRepositoriesTree = node;
        this.preparePacksMaps();
        this.addSelectors();
        this.updateInstalledVersions();
    }

    private void preparePacksMaps() {
        TreeMap<String, Map<String, PackNode>> packsVersionsMap = new TreeMap<String, Map<String, PackNode>>();
        for (PackNode versionNode : this.fPacksVersionsList) {
            String packName;
            String vendorName = versionNode.getProperty("vendor.name");
            String key = this.makeMapKey("cmsis", vendorName, packName = versionNode.getProperty("pack.name"));
            TreeMap<String, PackNode> versionMap = (TreeMap<String, PackNode>)packsVersionsMap.get(key);
            if (versionMap == null) {
                versionMap = new TreeMap<String, PackNode>();
                packsVersionsMap.put(key, versionMap);
            }
            versionMap.put(versionNode.getName(), versionNode);
        }
        this.fPacksVersionsMap = packsVersionsMap;
        TreeMap<String, PackNode> packsMap = new TreeMap<String, PackNode>();
        for (PackNode versionNode : this.fPacksVersionsList) {
            String packName;
            String vendorName = versionNode.getProperty("vendor.name");
            String key = this.makeMapKey("cmsis", vendorName, packName = versionNode.getProperty("pack.name"));
            if (packsMap.containsKey(key)) continue;
            PackNode parent = (PackNode)versionNode.getParent();
            packsMap.put(key, parent);
        }
        this.fPacksMap = packsMap;
    }

    private void addSelectors() {
        for (PackNode packNode : this.fPacksMap.values()) {
            Node versionNode = (Node)packNode.getFirstChild();
            if (!versionNode.hasChildren()) continue;
            for (Leaf child : versionNode.getChildren()) {
                if (!child.isType("outline") && !child.isType("external") || !child.hasChildren()) continue;
                for (Leaf node : ((Node)child).getChildren()) {
                    Selector selector = null;
                    String type = node.getType();
                    if ("family".equals(type)) {
                        selector = new Selector("devicefamily");
                        selector.setValue(node.getName());
                        selector.setVendorId(node.getProperty("vendor.id"));
                    } else if ("board".equals(type)) {
                        selector = new Selector("board");
                        selector.setValue(node.getName());
                        selector.setVendor(node.getProperty("vendor.name"));
                    } else if ("keyword".equals(type)) {
                        selector = new Selector("keyword");
                        selector.setValue(node.getName());
                    }
                    if (selector == null) continue;
                    packNode.addSelector(selector);
                }
            }
        }
    }

    private void updateInstalledVersions() {
        this.fOut.println("Identifying installed packages...");
        int count = 0;
        for (Leaf leaf : this.fPacksVersionsList) {
            String unpackFolder = leaf.getProperty("dest.folder");
            String pdscName = leaf.getProperty("pdsc.name");
            String pdscRelativePath = String.valueOf(unpackFolder) + '/' + pdscName;
            try {
                File file = PacksStorage.getFileObject(pdscRelativePath);
                if (!file.exists()) continue;
                leaf.setBooleanProperty("installed", true);
                if (leaf.getParent().isType("package")) {
                    leaf.getParent().setBooleanProperty("installed", true);
                }
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (count == 0) {
            this.fOut.println("Found no installed packages.");
        } else {
            this.fOut.println("Found " + count + " installed packages.");
        }
    }

    private void clearInstalledPacksLatestVersionsList() {
        this.fInstalledPacksLatestVersionsList = null;
    }

    public List<PackNode> getInstalledPacksLatestVersionsList() {
        return this.getInstalledPacksLatestVersionsList(new DurationMonitor());
    }

    private List<PackNode> getInstalledPacksLatestVersionsList(DurationMonitor dm) {
        if (this.fInstalledPacksLatestVersionsList != null) {
            return this.fInstalledPacksLatestVersionsList;
        }
        HashSet<PackNode> installedPackages = new HashSet<PackNode>();
        List<PackNode> packsVersionsList = this.getPacksVersionsList(dm);
        if (packsVersionsList != null) {
            for (PackNode versionNode : packsVersionsList) {
                if (!versionNode.isBooleanProperty("installed")) continue;
                installedPackages.add((PackNode)versionNode.getParent());
            }
            LinkedList<PackNode> installedLatestVersions = new LinkedList<PackNode>();
            block1: for (PackNode packNode : installedPackages) {
                List<Leaf> children = packNode.getChildren();
                for (Leaf node : children) {
                    if (!node.isBooleanProperty("installed")) continue;
                    installedLatestVersions.add((PackNode)node);
                    continue block1;
                }
            }
            this.fInstalledPacksLatestVersionsList = installedLatestVersions;
        }
        return this.fInstalledPacksLatestVersionsList;
    }

    public Node getParsedPdscTree(String pdscName, String version) {
        return this.getParsedPdscTree(pdscName, version, new DurationMonitor());
    }

    private Node getParsedPdscTree(String pdscName, String version, final DurationMonitor dm) {
        String[] parts;
        File file;
        String fileName;
        block8: {
            fileName = PacksStorage.makeCachedPdscName(pdscName, version);
            if (this.fParsedPdsc != null) {
                Node node = this.fParsedPdsc.get(fileName);
                if (node != null) {
                    return node;
                }
            } else {
                this.fParsedPdsc = new HashMap<String, Node>();
            }
            file = null;
            try {
                parts = pdscName.split("\\.", 3);
                if ("pdsc".equals(parts[2])) break block8;
                String msg = String.valueOf(pdscName) + " not a valid PDSC file name (vendor.name.pdsc).";
                this.fOut.println("Error: " + msg);
                DataUtils.reportError(msg);
                Activator.log((String)msg);
                return null;
            }
            catch (IOException e) {
                String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName();
                this.fOut.println("Error: " + msg);
                DataUtils.reportError(msg);
                Activator.log((Throwable)e);
                return null;
            }
        }
        file = PacksStorage.getPackageFileObject(parts[0], parts[1], version, pdscName);
        if (!file.isFile()) {
            file = PacksStorage.getCachedFileObject(fileName);
        }
        final File finalFile = file;
        assert (dm != null);
        dm.displayTimeAndRun(new Runnable(){

            @Override
            public void run() {
                Node node = DataManager.this.parsePdscFile(finalFile, dm);
                if (node != null) {
                    DataManager.this.fParsedPdsc.put(fileName, node);
                }
            }
        });
        return this.fParsedPdsc.get(fileName);
    }

    private Node parsePdscFile(File file, DurationMonitor dm) {
        try {
            this.fOut.println("Parsing PDSC file \"" + file.getCanonicalPath() + "\"...");
            Document document = Xml.parseFile((File)file);
            PdscGenericParser parser = new PdscGenericParser();
            Node node = parser.parse(document);
            return node;
        }
        catch (SAXParseException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName() + ", line: " + e.getLineNumber() + ", column: " + e.getColumnNumber();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((Throwable)e);
        }
        catch (Exception e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((Throwable)e);
        }
        return null;
    }

    private Node parseXcdlFile(File file, DurationMonitor dm) {
        try {
            this.fOut.println("Parsing XCDL file \"" + file.getCanonicalPath() + "\"...");
            JSONParser parser = new JSONParser();
            FileReader reader = new FileReader(file);
            JSONObject json = (JSONObject)parser.parse((Reader)reader);
            JsonJsGenericParser jsonJsParser = new JsonJsGenericParser();
            JsObject jsNode = jsonJsParser.parse(json);
            System.out.println(jsNode);
            XcdlGenericParser jsonParser = new XcdlGenericParser();
            Node node = jsonParser.parse(json);
            return node;
        }
        catch (FileNotFoundException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((Throwable)e);
        }
        catch (IOException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((Throwable)e);
        }
        catch (ParseException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName() + ", position: " + e.getPosition();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((Throwable)e);
        }
        return null;
    }

    private void clearCachedInstalledObjectsForBuild() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("clearCachedInstalledObjectsForBuild()");
        }
        this.fInstalledObjectsForBuild = null;
        this.fConfigObjectsForBuild = null;
        try {
            File devicesFile = PacksStorage.getCachedFileObject(".installed_devices_boards_books.xml");
            if (devicesFile.isFile()) {
                devicesFile.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fInstalledDevicesMap.clear();
    }

    @Override
    public Node getInstalledObjectsForBuild(IConfiguration config) {
        return this.getInstalledObjectsForBuild(config, new DurationMonitor());
    }

    private Node getInstalledObjectsForBuild(final IConfiguration config, final DurationMonitor dm) {
        if (config != null && config != this.fInstalledConfig) {
            this.fInstalledConfig = config;
            this.fConfigObjectsForBuild = null;
            this.fInstalledDevicesMap.clear();
            this.fInstalledBoardsMap.clear();
        }
        if (this.fConfigObjectsForBuild == null) {
            if (this.fInstalledObjectsForBuild == null) {
                assert (dm != null);
                dm.displayTimeAndRun(new Runnable(){

                    @Override
                    public void run() {
                        DataManager.this.fInstalledObjectsForBuild = DataManager.this.loadInstalledObjectsForBuild(config, dm);
                    }
                });
            }
            Node rootNode = this.fInstalledObjectsForBuild;
            Node projectRootNode = this.parseProjectPackagesForBuild(config, dm);
            if (projectRootNode != null) {
                rootNode = this.mergeTrees(rootNode, projectRootNode);
            }
            this.fConfigObjectsForBuild = rootNode;
        }
        return this.fConfigObjectsForBuild;
    }

    private Node loadInstalledObjectsForBuild(IConfiguration config, DurationMonitor dm) {
        this.fOut.println("Extracting devices & boards... ");
        Node rootNode = null;
        File devicesFile = null;
        try {
            devicesFile = PacksStorage.getCachedFileObject(".installed_devices_boards_books.xml");
            if (devicesFile.isFile()) {
                rootNode = this.loadCachedInstalledObjectsForBuild(devicesFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (rootNode != null) {
            AbstractTreePreOrderIterator packNodes = new AbstractTreePreOrderIterator(){

                @Override
                public boolean isIterable(Leaf node) {
                    if (node.isType("family")) {
                        return true;
                    }
                    return node.isType("board");
                }

                @Override
                public boolean isLeaf(Leaf node) {
                    if (node.isType("family")) {
                        return true;
                    }
                    return node.isType("board");
                }
            };
            packNodes.setTreeNode(rootNode);
            for (Leaf node : packNodes) {
                String packName = node.getProperty("pack.name");
                if (!packName.isEmpty()) continue;
                rootNode = null;
                Activator.log((String)"Buggy cache detected, ignored.");
                break;
            }
        }
        if (rootNode == null && (rootNode = this.parseInstalledPackagesForBuild(dm)) != null) {
            this.fOut.println("Writing cache file \"" + devicesFile + "\".");
            InstalledDevicesSerialiser serialiser = new InstalledDevicesSerialiser();
            try {
                serialiser.serialise(rootNode, devicesFile);
            }
            catch (IOException e) {
                String msg = String.valueOf(e.getMessage()) + ", file: " + devicesFile.getName();
                this.fOut.println("Error: " + msg);
                DataUtils.reportError(msg);
                Activator.log((Throwable)e);
            }
        }
        return rootNode;
    }

    private Node mergeTrees(Node first, Node second) {
        Node rootNode = first;
        if (first == null) {
            rootNode = new Node("root");
        }
        AbstractTreePreOrderIterator secondDeviceFamilies = new AbstractTreePreOrderIterator(){

            @Override
            public boolean isIterable(Leaf node) {
                return node.isType("family");
            }

            @Override
            public boolean isLeaf(Leaf node) {
                return node.isType("family") || node.isType("boards");
            }
        };
        secondDeviceFamilies.setTreeNode(second);
        for (Leaf secondDeviceFamily : secondDeviceFamilies) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println(secondDeviceFamily);
            }
            this.addInstalledDeviceFamily((Node)secondDeviceFamily, rootNode);
        }
        AbstractTreePreOrderIterator secondBoards = new AbstractTreePreOrderIterator(){

            @Override
            public boolean isIterable(Leaf node) {
                return node.isType("board");
            }

            @Override
            public boolean isLeaf(Leaf node) {
                return node.isType("board") || node.isType("families");
            }
        };
        secondBoards.setTreeNode(second);
        for (Leaf secondBoard : secondBoards) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println(secondBoard);
            }
            this.addInstalledBoard((Node)secondBoard, rootNode);
        }
        return rootNode;
    }

    private String[] getArrayValues(Node node) {
        assert (node != null);
        LinkedList<String> list = new LinkedList<String>();
        if (node.hasChildren()) {
            for (Leaf child : node.getChildren()) {
                String value;
                if (!child.isType("$ARRAY_ELEMENT") || (value = child.getProperty("$VALUE", "")).isEmpty()) continue;
                list.add(value);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void addInstalledDeviceFamily(Node deviceFamily, Node parent) {
        Node devices;
        Node family;
        String familyName;
        Node supplier;
        Node root = deviceFamily;
        while (!root.isType("root")) {
            root = root.getParent();
        }
        Node rootDevices = (Node)parent.findChild("devices");
        if (rootDevices == null) {
            rootDevices = Node.addNewChild(parent, "devices");
            rootDevices.setName("Devices");
        }
        if ((supplier = (Node)deviceFamily.findChild("supplier")) == null) {
            String name = deviceFamily.getProperty("displayName");
            String msg = "Device family " + name + " has no 'supplier; ignored.'";
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((String)msg);
            return;
        }
        String supplierName = supplier.getProperty("displayName");
        String supplierId = supplier.getProperty("id");
        Node vendor = (Node)rootDevices.findChild("vendor", supplierName);
        if (vendor == null) {
            vendor = Node.addNewChild(rootDevices, "vendor");
            vendor.setName(supplierName);
            vendor.putProperty("vendor.id", supplierId);
        }
        if ((familyName = deviceFamily.getProperty("displayName")).isEmpty()) {
            familyName = deviceFamily.getProperty("$KEY");
        }
        if ((family = (Node)vendor.findChild("family", familyName)) == null) {
            family = Node.addNewChild(vendor, "family");
            family.setName(familyName);
            family.putProperty("pack.type", "xpack.xcdl");
            family.putProperty("$KEY", deviceFamily.getProperty("$KEY"));
            family.putProperty("vendor.name", supplierName);
            family.putProperty("vendor.id", supplierId);
            family.putProperty("pack.name", root.getProperty("pack.name"));
            family.putProperty("pack.version", root.getProperty("pack.version"));
        }
        if ((devices = (Node)deviceFamily.findChild("devices")) == null || !devices.hasChildren()) {
            return;
        }
        for (Leaf device : devices.getChildren()) {
            Node memoryRegions;
            Node compile;
            Node existingDevice;
            if (!device.isType("device")) continue;
            String deviceName = device.getProperty("displayName");
            if (deviceName.isEmpty()) {
                deviceName = device.getProperty("$KEY");
            }
            if ((existingDevice = (Node)family.findChild("device", deviceName)) != null) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Device " + deviceName + " exists; replaced.");
                }
                family.removeChild(existingDevice);
            }
            Node newDevice = Node.addNewChild(family, "device");
            newDevice.setName(deviceName);
            newDevice.putProperty("pack.type", "xpack.xcdl");
            newDevice.putProperty("vendor.name", supplierName);
            newDevice.putProperty("vendor.id", supplierId);
            newDevice.putProperty("$KEY", device.getProperty("$KEY"));
            Node features = (Node)((Node)device).findChild("features");
            if (features != null) {
                newDevice.putNonEmptyProperty("arch", features.getPropertyOrNull("arch"));
                newDevice.putNonEmptyProperty("hfosc", features.getPropertyOrNull("hfosc"));
                newDevice.putNonEmptyProperty("lfosc", features.getPropertyOrNull("lfosc"));
            }
            if ((compile = (Node)((Node)device).findChild("compiler")) != null) {
                CharSequence[] arr;
                Node defines;
                CharSequence[] arr2;
                Node headers = (Node)compile.findChild("headers");
                if (headers != null && (arr2 = this.getArrayValues(headers)).length > 0) {
                    newDevice.putNonEmptyProperty("compilerHeaders", String.join((CharSequence)",", arr2));
                }
                if ((defines = (Node)compile.findChild("defines")) != null && (arr = this.getArrayValues(defines)).length > 0) {
                    newDevice.putNonEmptyProperty("compilerDefines", String.join((CharSequence)",", arr));
                }
            }
            if ((memoryRegions = (Node)((Node)device).findChild("memoryRegions")) != null && memoryRegions.hasChildren()) {
                for (Leaf memoryRegion : memoryRegions.getChildren()) {
                    String onChip = memoryRegion.getProperty("onChip");
                    if (!"true".equals(onChip)) continue;
                    Node newMemory = Node.addNewChild(newDevice, "memory");
                    newMemory.setName(memoryRegion.getProperty("$KEY"));
                    newMemory.putProperty("start", memoryRegion.getProperty("address"));
                    newMemory.putProperty("size", memoryRegion.getProperty("size"));
                    newMemory.putProperty("access", memoryRegion.getProperty("access"));
                }
            }
            Node debug = (Node)((Node)device).findChild("debug");
            newDevice.putNonEmptyProperty("xsvd.file", debug.getPropertyOrNull("xsvd"));
        }
    }

    private void addInstalledBoard(Node board, Node parent) {
        Node installedDevice;
        Node compile;
        Node existingBoard;
        Node supplier;
        String boardName;
        Node root = board;
        while (!root.isType("root")) {
            root = root.getParent();
        }
        Node rootBoards = (Node)parent.findChild("boards");
        if (rootBoards == null) {
            rootBoards = Node.addNewChild(parent, "boards");
            rootBoards.setName("Boards");
        }
        if ((boardName = board.getProperty("displayName")).isEmpty()) {
            boardName = board.getProperty("$KEY");
        }
        if ((supplier = (Node)board.findChild("supplier")) == null) {
            String msg = "Board " + boardName + " has no 'supplier'; ignored.";
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((String)msg);
            return;
        }
        String supplierName = supplier.getProperty("displayName");
        String supplierId = supplier.getProperty("id");
        Node vendor = (Node)rootBoards.findChild("vendor", supplierName);
        if (vendor == null) {
            vendor = Node.addNewChild(rootBoards, "vendor");
            vendor.setName(supplierName);
        }
        if ((existingBoard = (Node)vendor.findChild("board", boardName)) != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("Board " + boardName + " exists; replaced.");
            }
            vendor.removeChild(existingBoard);
        }
        Node newBoard = Node.addNewChild(vendor, "board");
        newBoard.setName(boardName);
        newBoard.putProperty("pack.type", "xpack.xcdl");
        newBoard.putProperty("$KEY", board.getProperty("$KEY"));
        newBoard.putNonEmptyProperty("board.revision", board.getPropertyOrNull("revision"));
        newBoard.putProperty("vendor.name", supplierName);
        newBoard.putProperty("vendor.id", supplierId);
        newBoard.putProperty("pack.name", root.getProperty("pack.name"));
        newBoard.putProperty("pack.version", root.getProperty("pack.version"));
        Node features = (Node)board.findChild("features");
        if (features != null) {
            newBoard.putNonEmptyProperty("hfxtal", features.getPropertyOrNull("hfxtal"));
            newBoard.putNonEmptyProperty("lfxtal", features.getPropertyOrNull("lfxtal"));
        }
        if ((compile = (Node)board.findChild("compiler")) != null) {
            CharSequence[] arr;
            Node defines;
            CharSequence[] arr2;
            Node headers = (Node)compile.findChild("headers");
            if (headers != null && (arr2 = this.getArrayValues(headers)).length > 0) {
                newBoard.putNonEmptyProperty("compilerHeaders", String.join((CharSequence)",", arr2));
            }
            if ((defines = (Node)compile.findChild("defines")) != null && (arr = this.getArrayValues(defines)).length > 0) {
                newBoard.putNonEmptyProperty("compilerDefines", String.join((CharSequence)",", arr));
            }
        }
        if ((installedDevice = (Node)board.findChild("installedDevice")) == null) {
            String msg = "Board " + boardName + " has no 'installedDevice'; ignored.";
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((String)msg);
            return;
        }
        Leaf installedDeviceSupplier = installedDevice.findChild("supplier");
        if (installedDeviceSupplier == null) {
            String msg = "Board " + boardName + " has no 'installedDevice.supplier'; ignored.";
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((String)msg);
            return;
        }
        String installedDeviceSupplierName = installedDeviceSupplier.getProperty("displayName");
        if (installedDeviceSupplierName.isEmpty()) {
            String msg = "Board " + boardName + " has no 'installedDevice.supplier.name'; ignored.";
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((String)msg);
            return;
        }
        String installedDeviceSupplierId = installedDeviceSupplier.getProperty("id");
        if (installedDeviceSupplierId.isEmpty()) {
            String msg = "Board " + boardName + " has no 'installedDevice.supplier.id'; ignored.";
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((String)msg);
            return;
        }
        String installedDeviceName = installedDevice.getProperty("name");
        if (installedDeviceName.isEmpty()) {
            String msg = "Board " + boardName + " has no 'installedDevice.name'; ignored.";
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((String)msg);
            return;
        }
        Node nodeDevice = Node.addNewChild(newBoard, "device");
        String installedDeviceKey = installedDeviceName;
        Node rootDevices = (Node)parent.findChild("devices");
        if (rootDevices != null) {
            AbstractTreePreOrderIterator existingDevices = new AbstractTreePreOrderIterator(){

                @Override
                public boolean isIterable(Leaf node) {
                    return node.isType("device");
                }

                @Override
                public boolean isLeaf(Leaf node) {
                    return node.isType("device");
                }
            };
            existingDevices.setTreeNode(rootDevices);
            for (Leaf existingDevice : existingDevices) {
                if (!existingDevice.isType("device") || !installedDeviceName.equals(existingDevice.getProperty("$KEY"))) continue;
                String displayName = existingDevice.getName();
                if (displayName.isEmpty()) break;
                installedDeviceName = displayName;
                break;
            }
        }
        nodeDevice.setName(installedDeviceName);
        nodeDevice.putProperty("pack.type", "xpack.xcdl");
        nodeDevice.putProperty("vendor.name", installedDeviceSupplierName);
        nodeDevice.putProperty("vendor.id", installedDeviceSupplierId);
        nodeDevice.putProperty("$KEY", installedDeviceKey);
    }

    private Node loadCachedInstalledObjectsForBuild(File file) {
        String str;
        try {
            str = file.getCanonicalPath();
        }
        catch (IOException e) {
            str = file.getPath();
        }
        this.fOut.println("Parsing cached file \"" + str + "\".");
        Node node = null;
        try {
            Document document = Xml.parseFile((File)file);
            InstalledDevicesParser parser = new InstalledDevicesParser();
            node = parser.parse(document);
        }
        catch (SAXParseException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName() + ", line: " + e.getLineNumber() + ", column: " + e.getColumnNumber();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((Throwable)e);
        }
        catch (Exception e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
            Activator.log((Throwable)e);
        }
        return node;
    }

    private Node parseInstalledPackagesForBuild(DurationMonitor dm) {
        List<PackNode> versionsList = this.getInstalledPacksLatestVersionsList(dm);
        PdscTreeParserForBuild pdsc = new PdscTreeParserForBuild();
        Node boardsNode = new Node("boards");
        boardsNode.setName("Boards");
        Node devicesNode = new Node("devices");
        devicesNode.setName("Devices");
        int countPackages = 0;
        int totalCountDevices = 0;
        int totalCountBoards = 0;
        for (PackNode node : versionsList) {
            String pdscName = node.getProperty("pdsc.name");
            String version = node.getName();
            Node tree = this.getParsedPdscTree(pdscName, version, dm);
            int countDevices = pdsc.parseDevices(tree, devicesNode);
            totalCountDevices += countDevices;
            int countBoards = pdsc.parseBoards(tree, boardsNode);
            totalCountBoards += countBoards;
            ++countPackages;
        }
        if (countPackages == 0) {
            this.fOut.println("No installed packages.");
        } else {
            if (countPackages == 1) {
                this.fOut.print("Processed 1 package, found ");
            } else {
                this.fOut.print("Processed " + countPackages + " packages, found ");
            }
            if (totalCountDevices == 0) {
                this.fOut.print("no devices, ");
            } else if (totalCountDevices == 1) {
                this.fOut.print("1 device, ");
            } else {
                this.fOut.print(String.valueOf(totalCountDevices) + " devices, ");
            }
            if (totalCountBoards == 0) {
                this.fOut.print("no boards.");
            } else if (totalCountBoards == 1) {
                this.fOut.print("1 board.");
            } else {
                this.fOut.print(String.valueOf(totalCountBoards) + " boards.");
            }
            this.fOut.println();
        }
        if (boardsNode.hasChildren() || devicesNode.hasChildren()) {
            Node rootNode = new Node("root");
            rootNode.addChild(boardsNode);
            rootNode.addChild(devicesNode);
            return rootNode;
        }
        return null;
    }

    private Node parseProjectPackagesForBuild(IConfiguration config, final DurationMonitor dm) {
        assert (dm != null);
        if (config == null) {
            return null;
        }
        IProject project = EclipseUtils.getProjectFromConfiguration((IConfiguration)config);
        assert (project != null);
        if (!XpackUtils.hasPackageJson((IProject)project)) {
            return null;
        }
        IPath projectPath = project.getLocation();
        File xpacksFolder = projectPath.append("xpacks").toFile();
        if (!xpacksFolder.isDirectory()) {
            return null;
        }
        final Node tree = new Node("root");
        tree.setPackType(Leaf.PACK_TYPE_XPACK);
        File[] folders = xpacksFolder.listFiles();
        int i = 0;
        while (i < folders.length) {
            if (folders[i].isDirectory()) {
                String packageName = "";
                String packageVersion = "";
                Path folderPath = new Path(folders[i].getPath());
                File packageFile = folderPath.append("package.json").toFile();
                if (packageFile.exists() && !packageFile.isDirectory()) {
                    JSONParser parser = new JSONParser();
                    try {
                        FileReader reader = new FileReader(packageFile);
                        JSONObject packageJson = (JSONObject)parser.parse((Reader)reader);
                        packageName = (String)packageJson.get((Object)"name");
                        packageVersion = (String)packageJson.get((Object)"version");
                    }
                    catch (FileNotFoundException reader) {
                    }
                    catch (IOException reader) {
                    }
                    catch (ParseException reader) {
                        // empty catch block
                    }
                }
                File[] xcdlFiles = folders[i].listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("xcdl.json");
                    }
                });
                int j = 0;
                while (j < xcdlFiles.length) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println(xcdlFiles[j]);
                    }
                    final File xcdlFile = xcdlFiles[j];
                    final String name = packageName;
                    final String version = packageVersion;
                    dm.displayTimeAndRun(new Runnable(){

                        @Override
                        public void run() {
                            Node xcdlRoot = DataManager.this.parseXcdlFile(xcdlFile, dm);
                            tree.addChild(xcdlRoot);
                            xcdlRoot.putProperty("pack.name", name);
                            xcdlRoot.putProperty("pack.version", version);
                        }
                    });
                    ++j;
                }
            }
            ++i;
        }
        if (tree.hasChildren()) {
            return tree;
        }
        return null;
    }

    @Override
    public Leaf findInstalledDevice(String packType, String deviceSupplierId, String deviceId, IConfiguration config) {
        return this.findInstalledDevice(packType, deviceSupplierId, deviceId, config, new DurationMonitor());
    }

    private Leaf findInstalledDevice(String packType, String deviceSupplierId, String deviceId, IConfiguration config, DurationMonitor dm) {
        String key = this.makeMapKey(packType, deviceSupplierId, deviceId);
        if (this.fInstalledDevicesMap.containsKey(key)) {
            return this.fInstalledDevicesMap.get(key);
        }
        Node tree = this.getInstalledObjectsForBuild(config, dm);
        AbstractTreePreOrderIterator installedDevices = new AbstractTreePreOrderIterator(){

            @Override
            public boolean isIterable(Leaf node) {
                return node.isType("device") || node.isType("variant");
            }

            @Override
            public boolean isLeaf(Leaf node) {
                return node.isType("variant") || node.isType("boards");
            }
        };
        installedDevices.setTreeNode(tree);
        for (Leaf installedDevice : installedDevices) {
            String installedDeviceName;
            String installedDeviceKey;
            if ("xpack.xcdl".equals(packType) ? !deviceId.equals(installedDeviceKey = installedDevice.getProperty("$KEY")) : !deviceId.equals(installedDeviceName = installedDevice.getName())) continue;
            String installedDeviceVendorId = "";
            Leaf node = installedDevice;
            while (node != null && !node.isType("vendor")) {
                if (node.hasProperty("vendor.id")) {
                    installedDeviceVendorId = node.getProperty("vendor.id");
                    break;
                }
                node = node.getParent();
            }
            if (!deviceSupplierId.equals(installedDeviceVendorId)) continue;
            this.fInstalledDevicesMap.put(key, installedDevice);
            return installedDevice;
        }
        this.fInstalledDevicesMap.put(key, null);
        return null;
    }

    @Override
    public Leaf findInstalledBoard(String packType, String boardSupplierId, String boardSupplierName, String boardId, IConfiguration config) {
        return this.findInstalledBoard(packType, boardSupplierId, boardSupplierName, boardId, config, new DurationMonitor());
    }

    private Leaf findInstalledBoard(String packType, String boardSupplierId, String boardSupplierName, String boardId, IConfiguration config, DurationMonitor dm) {
        assert (packType != null);
        assert (boardSupplierId != null || boardSupplierName != null);
        assert (boardId != null);
        String boardSupplierKey = null;
        if ("cmsis".equals(packType)) {
            boardSupplierKey = boardSupplierName;
        } else if ("xpack.xcdl".equals(packType)) {
            boardSupplierKey = boardSupplierId;
        }
        String key = this.makeMapKey(packType, boardSupplierKey, boardId);
        if (this.fInstalledBoardsMap.containsKey(key)) {
            return this.fInstalledBoardsMap.get(key);
        }
        Node tree = this.getInstalledObjectsForBuild(config, dm);
        AbstractTreePreOrderIterator installedBoards = new AbstractTreePreOrderIterator(){

            @Override
            public boolean isIterable(Leaf node) {
                return node.isType("board");
            }

            @Override
            public boolean isLeaf(Leaf node) {
                return node.isType("board") || node.isType("devices");
            }
        };
        installedBoards.setTreeNode(tree);
        for (Leaf installedBoard : installedBoards) {
            String nodePackType = installedBoard.getProperty("pack.type", "");
            String installedBoardVendorKey = "";
            if ("xpack.xcdl".equals(packType) && "xpack.xcdl".equals(nodePackType)) {
                String installedBoardKey = installedBoard.getProperty("$KEY");
                if (!boardId.equals(installedBoardKey)) continue;
                installedBoardVendorKey = installedBoard.getProperty("vendor.id");
            } else {
                String installedBoardName = installedBoard.getName();
                if (!boardId.equals(installedBoardName)) continue;
                installedBoardVendorKey = installedBoard.getProperty("vendor.name");
            }
            if (!boardSupplierKey.equals(installedBoardVendorKey)) continue;
            this.fInstalledBoardsMap.put(key, installedBoard);
            return installedBoard;
        }
        this.fInstalledBoardsMap.put(key, null);
        return null;
    }

    public static String collectProperty(Leaf node, String name, String type) {
        while (node != null && !node.isType(type)) {
            if (node.hasProperty(name)) {
                return node.getProperty(name);
            }
            node = node.getParent();
        }
        return "";
    }

    @Override
    public String getCmsisDestinationFolder(Leaf node) {
        return this.getCmsisDestinationFolder(node, new DurationMonitor());
    }

    public String getCmsisDestinationFolder(Leaf node, DurationMonitor dm) {
        String vendorName = DataManager.collectProperty(node, "pack.vendor", "devices");
        String packName = DataManager.collectProperty(node, "pack.name", "devices");
        String version = DataManager.collectProperty(node, "pack.version", "devices");
        PackNode summaryVersionNode = this.findCmsisPackVersion(vendorName, packName, version, dm);
        String destFolder = "";
        if (summaryVersionNode != null) {
            destFolder = summaryVersionNode.getProperty("dest.folder");
        }
        return destFolder;
    }

    public String getXpackDestinationFolder(Leaf node, IConfiguration config) {
        return this.getXpackDestinationFolder(node, config, new DurationMonitor());
    }

    public String getXpackDestinationFolder(Leaf node, IConfiguration config, DurationMonitor dm) {
        IPath packPath;
        String packageName = DataManager.collectProperty(node, "pack.name", "devices");
        String version = DataManager.collectProperty(node, "pack.version", "devices");
        IProject project = EclipseUtils.getProjectFromConfiguration((IConfiguration)config);
        assert (project != null);
        if (XpackUtils.hasPackageJson((IProject)project)) {
            IPath projectPath;
            IPath packageFolderPath;
            String linearFolderName = packageName;
            String[] arr = packageName.split("[/]");
            if (arr.length > 1) {
                linearFolderName = String.valueOf(arr[0].substring(1)) + "-" + arr[1];
            }
            if (this.checkPackage(packageFolderPath = (projectPath = project.getLocation()).append("xpacks").append(linearFolderName), packageName, version)) {
                return packageFolderPath.toString();
            }
        }
        if (this.checkPackage((packPath = XpackUtils.getPackPath((String)packageName)).append(".link"), packageName, version)) {
            return packPath.append(".link").toString();
        }
        if (this.checkPackage(packPath.append(version), packageName, version)) {
            return packPath.append(version).toString();
        }
        return null;
    }

    public boolean checkPackage(IPath folderPath, String packageName, String packageVersion) {
        File packageFile = folderPath.append("package.json").toFile();
        if (packageFile.isFile()) {
            JSONParser parser = new JSONParser();
            try {
                FileReader reader = new FileReader(packageFile);
                JSONObject packageJson = (JSONObject)parser.parse((Reader)reader);
                String actualPackageName = (String)packageJson.get((Object)"name");
                String actualPackageVersion = (String)packageJson.get((Object)"version");
                if (packageName.equals(actualPackageName) && packageVersion.equals(actualPackageVersion)) {
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public IPath getSVDAbsolutePath(String packType, String deviceVendorId, String deviceId, IConfiguration config) {
        IPath path;
        Leaf installedDeviceNode = this.findInstalledDevice(packType, deviceVendorId, deviceId, config);
        if (installedDeviceNode == null) {
            return null;
        }
        String svdFile = installedDeviceNode.getPropertyWithParent("xsvd.file", null);
        if (svdFile == null && (svdFile = installedDeviceNode.getPropertyWithParent("svd.file", null)) == null) {
            return null;
        }
        if ("xpack.xcdl".equals(packType)) {
            String destFolder = this.getXpackDestinationFolder(installedDeviceNode, config);
            path = new Path(destFolder).append(svdFile);
        } else {
            String destFolder = this.getCmsisDestinationFolder(installedDeviceNode);
            try {
                path = PacksStorage.getFolderPath().append(destFolder).append(svdFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return path;
    }

    @Override
    public Node getCmsisCoreFiles(String deviceName, String compiler) {
        return null;
    }

    @Override
    public Node getRegisterDetailsForDebug(String deviceName) {
        return null;
    }
}

