/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.cmsis;

import com.github.zafarkhaja.semver.Version;
import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.core.Xml;
import ilg.gnumcueclipse.packs.cmsis.PdscParser;
import ilg.gnumcueclipse.packs.cmsis.PdscUtils;
import ilg.gnumcueclipse.packs.core.tree.Leaf;
import ilg.gnumcueclipse.packs.core.tree.Node;
import ilg.gnumcueclipse.packs.data.Activator;
import java.util.List;
import org.w3c.dom.Element;

public class PdscParserForBuild
extends PdscParser {
    private Version deviceSchemaSemVer;
    private Version boardSchemaSemVer;

    public void _parseDevices(Node tree) {
        Element packageElement = this.fDocument.getDocumentElement();
        String firstElementName = packageElement.getNodeName();
        if (!"package".equals(firstElementName)) {
            Activator.log((String)("Missing <package>, <" + firstElementName + "> encountered"));
            return;
        }
        String schemaVersion = packageElement.getAttribute("schemaVersion").trim();
        this.deviceSchemaSemVer = Version.valueOf((String)schemaVersion);
        if (!PdscUtils.isSchemaValid(this.deviceSchemaSemVer)) {
            Activator.log((String)("Unrecognised schema version " + schemaVersion));
            return;
        }
        List childElements = Xml.getChildrenElementsList((Element)packageElement);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if (!"devices".equals(elementName)) continue;
            List childElements2 = Xml.getChildrenElementsList((Element)childElement);
            for (Element childElement2 : childElements2) {
                String elementName2 = childElement2.getNodeName();
                if (!"family".equals(elementName2)) continue;
                this.processFamilyElement(childElement2, tree);
            }
        }
    }

    private Node addUniqueVendor(Node parent, String vendorName, String vendorId) {
        if (parent.hasChildren()) {
            for (Leaf child : parent.getChildren()) {
                if (!vendorId.equals(child.getProperty("vendorid"))) continue;
                return (Node)child;
            }
        }
        Node vendor = Node.addNewChild((Node)parent, (String)"vendor");
        vendor.setName(vendorName);
        vendor.putProperty("vendorid", vendorId);
        return vendor;
    }

    private void processFamilyElement(Element el, Node parent) {
        String familyName = el.getAttribute("Dfamily").trim();
        String familyVendor = el.getAttribute("Dvendor").trim();
        String[] va = familyVendor.split("[:]");
        Node vendorNode = this.addUniqueVendor(parent, va[0], va[1]);
        Node familyNode = Node.addUniqueChild((Node)vendorNode, (String)"family", (String)familyName);
        familyNode.putProperty("vendor", va[0]);
        familyNode.putProperty("vendorid", va[1]);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("subFamily".equals(elementName)) {
                this.processSubFamilyElement(childElement, familyNode);
                continue;
            }
            if ("device".equals(elementName)) {
                this.processDeviceElement(childElement, familyNode);
                continue;
            }
            this.processDevicePropertiesGroup(childElement, familyNode);
        }
        familyNode.setDescription(this.processDeviceSummary(familyNode));
    }

    private void processProcessorElement(Element el, Node parent) {
        String Dcore = el.getAttribute("Dcore").trim();
        String DcoreVersion = el.getAttribute("DcoreVersion").trim();
        String Dfpu = el.getAttribute("Dfpu").trim();
        String Dmpu = el.getAttribute("Dmpu").trim();
        String Dendian = el.getAttribute("Dendian").trim();
        String Dclock = el.getAttribute("Dclock").trim();
        parent.putNonEmptyProperty("core", Dcore);
        parent.putNonEmptyProperty("version", DcoreVersion);
        parent.putNonEmptyProperty("fpu", Dfpu);
        parent.putNonEmptyProperty("mpu", Dmpu);
        parent.putNonEmptyProperty("endian", Dendian);
        parent.putNonEmptyProperty("clock", Dclock);
    }

    private void processSubFamilyElement(Element el, Node parent) {
        String subFamilyName = el.getAttribute("DsubFamily").trim();
        Node subFamilyNode = Node.addUniqueChild((Node)parent, (String)"subfamily", (String)subFamilyName);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("device".equals(elementName)) {
                this.processDeviceElement(childElement, subFamilyNode);
                continue;
            }
            this.processDevicePropertiesGroup(childElement, subFamilyNode);
        }
        subFamilyNode.setDescription(this.processDeviceSummary(subFamilyNode));
    }

    private void processDeviceElement(Element el, Node parent) {
        String deviceName = el.getAttribute("Dname").trim();
        Node deviceNode = Node.addUniqueChild((Node)parent, (String)"device", (String)deviceName);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("variant".equals(elementName)) {
                this.processVariantElement(childElement, deviceNode);
                continue;
            }
            this.processDevicePropertiesGroup(childElement, deviceNode);
        }
        deviceNode.setDescription(this.processDeviceSummary(deviceNode));
    }

    private void processVariantElement(Element el, Node parent) {
        String variantName = el.getAttribute("Dvariant").trim();
        Node variantNode = Node.addUniqueChild((Node)parent, (String)"variant", (String)variantName);
        List childElements2 = Xml.getChildrenElementsList((Element)el);
        for (Element childElement2 : childElements2) {
            this.processDevicePropertiesGroup(childElement2, variantNode);
        }
        variantNode.setDescription(this.processDeviceSummary(variantNode));
    }

    private void processDevicePropertiesGroup(Element el, Node parent) {
        String elementName = el.getNodeName();
        if ("processor".equals(elementName)) {
            this.processProcessorElement(el, parent);
        } else if ("memory".equals(elementName)) {
            this.processMemoryElement(el, parent);
        }
    }

    private void processMemoryElement(Element el, Node parent) {
        String id = el.getAttribute("id").trim();
        String start = el.getAttribute("start").trim();
        String size = el.getAttribute("size").trim();
        String Pname = el.getAttribute("Pname").trim();
        String startup = el.getAttribute("startup").trim();
        String init = el.getAttribute("init").trim();
        String defa = el.getAttribute("default").trim();
        Leaf memoryNode = Leaf.addUniqueChild((Node)parent, (String)"memory", (String)id);
        memoryNode.putProperty("start", start);
        memoryNode.putProperty("size", size);
        memoryNode.putNonEmptyProperty("pname", Pname);
        memoryNode.putNonEmptyProperty("startup", startup);
        memoryNode.putNonEmptyProperty("init", init);
        memoryNode.putNonEmptyProperty("default", defa);
    }

    public void _parseBoards(Node tree) {
        Element packageElement = this.fDocument.getDocumentElement();
        String firstElementName = packageElement.getNodeName();
        if (!"package".equals(firstElementName)) {
            Activator.log((String)("Missing <packages>, <" + firstElementName + "> encountered"));
            return;
        }
        String schemaVersion = packageElement.getAttribute("schemaVersion").trim();
        this.boardSchemaSemVer = Version.valueOf((String)schemaVersion);
        if (!PdscUtils.isSchemaValid(this.boardSchemaSemVer)) {
            Activator.log((String)("Unrecognised schema version " + schemaVersion));
            return;
        }
        List childElements = Xml.getChildrenElementsList((Element)packageElement);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if (!"boards".equals(elementName)) continue;
            List childElements2 = Xml.getChildrenElementsList((Element)childElement);
            for (Element childElement2 : childElements2) {
                String elementName2 = childElement2.getNodeName();
                if (!"board".equals(elementName2)) continue;
                this.processBoardElement(childElement2, tree);
            }
        }
    }

    private void processBoardElement(Element el, Node parent) {
        String boardVendor = el.getAttribute("vendor").trim();
        String boardName = el.getAttribute("name").trim();
        String boardRevision = el.getAttribute("revision").trim();
        Node vendorNode = Node.addUniqueChild((Node)parent, (String)"vendor", (String)boardVendor);
        String name = boardName;
        if (boardRevision.length() > 0) {
            name = String.valueOf(name) + " (" + boardRevision + ")";
        }
        Node boardNode = Node.addUniqueChild((Node)vendorNode, (String)"board", (String)name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("mountedDevice".equals(elementName)) {
                String Dvendor = childElement.getAttribute("Dvendor").trim();
                String Dname = childElement.getAttribute("Dname").trim();
                if (Dname.length() <= 0) continue;
                Node deviceNode = Node.addNewChild((Node)boardNode, (String)"device");
                deviceNode.setName(Dname);
                String[] va = Dvendor.split(":");
                deviceNode.putProperty("vendor", va[0]);
                deviceNode.putProperty("vendorid", va[1]);
                continue;
            }
            if (!"feature".equals(elementName)) continue;
            this.processFeatureElement(childElement, boardNode);
        }
        String prefix = "Board";
        String summary = "";
        String clock = boardNode.getProperty("clock");
        if (clock.length() > 0) {
            try {
                int clockMHz = Integer.parseInt(clock) / 1000000;
                if (summary.length() > 0) {
                    summary = String.valueOf(summary) + ", ";
                }
                summary = String.valueOf(summary) + String.valueOf(clockMHz) + " MHz XTAL";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        summary = summary.length() > 0 ? String.valueOf(prefix) + " (" + summary + ")" : prefix;
        boardNode.setDescription(summary);
    }

    private void processFeatureElement(Element el, Node parent) {
        String featureType = el.getAttribute("type").trim();
        String featureN = el.getAttribute("n").trim();
        if ("XTAL".equals(featureType)) {
            parent.putNonEmptyProperty("clock", featureN);
        }
    }

    protected String processDeviceSummary(Node deviceNode) {
        String clock;
        String mpu;
        String fpu;
        String prefix = "";
        if (deviceNode.isType("family")) {
            prefix = "Family";
        } else if (deviceNode.isType("subfamily")) {
            prefix = "Subfamily";
        } else if (deviceNode.isType("device")) {
            prefix = "Device";
        } else if (deviceNode.isType("variant")) {
            prefix = "Variant";
        }
        String summary = "";
        String core = deviceNode.getProperty("core");
        if (core.length() > 0) {
            if (summary.length() > 0) {
                summary = String.valueOf(summary) + ", ";
            }
            summary = String.valueOf(summary) + core;
            String version = deviceNode.getProperty("version");
            if (version.length() > 0) {
                if (summary.length() > 0) {
                    summary = String.valueOf(summary) + ", ";
                }
                summary = String.valueOf(summary) + version;
            }
        }
        if ((fpu = deviceNode.getProperty("fpu")).length() > 0 && "1".equals(fpu)) {
            if (summary.length() > 0) {
                summary = String.valueOf(summary) + ", ";
            }
            summary = String.valueOf(summary) + "FPU";
        }
        if ((mpu = deviceNode.getProperty("mpu")).length() > 0 && "1".equals(mpu)) {
            if (summary.length() > 0) {
                summary = String.valueOf(summary) + ", ";
            }
            summary = String.valueOf(summary) + "MPU";
        }
        if ((clock = deviceNode.getProperty("clock")).length() > 0) {
            try {
                int clockMHz = Integer.parseInt(clock) / 1000000;
                if (summary.length() > 0) {
                    summary = String.valueOf(summary) + ", ";
                }
                summary = String.valueOf(summary) + String.valueOf(clockMHz) + " MHz";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int ramKB = 0;
        int romKB = 0;
        if (deviceNode.hasChildren()) {
            for (Leaf childNode : deviceNode.getChildren()) {
                if (!"memory".equals(childNode.getType())) continue;
                String size = childNode.getProperty("size");
                long sizeKB = StringUtils.convertHexLong((String)size) / 1024L;
                String id = childNode.getName();
                if (id.contains("ROM")) {
                    romKB = (int)((long)romKB + sizeKB);
                    continue;
                }
                if (!id.contains("RAM")) continue;
                ramKB = (int)((long)ramKB + sizeKB);
            }
        }
        if (ramKB > 0) {
            if (summary.length() > 0) {
                summary = String.valueOf(summary) + ", ";
            }
            summary = String.valueOf(summary) + String.valueOf(ramKB) + " kB RAM";
        }
        if (romKB > 0) {
            if (summary.length() > 0) {
                summary = String.valueOf(summary) + ", ";
            }
            summary = String.valueOf(summary) + String.valueOf(romKB) + " kB ROM";
        }
        summary = summary.length() > 0 ? String.valueOf(prefix) + " (" + summary + ")" : prefix;
        return summary;
    }
}

