/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortSortingStrategy;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public final class PortListSorter
implements ILayoutProcessor<LGraph> {
    private static final Function<LPort, Iterable<LEdge>> IN_EDGES = p -> p.getIncomingEdges();
    private static final Function<LPort, Iterable<LEdge>> OUT_EDGES = p -> p.getOutgoingEdges();
    public static final Comparator<LPort> CMP_PORT_SIDE = (p1, p2) -> {
        int ordinalDifference = p1.getSide().ordinal() - p2.getSide().ordinal();
        if (ordinalDifference != 0) {
            return ordinalDifference;
        }
        return 0;
    };
    public static final Comparator<LPort> CMP_PORT_DEGREE_EAST_WEST = (p1, p2) -> {
        int ordinalDifference = p1.getSide().ordinal() - p2.getSide().ordinal();
        if (ordinalDifference != 0) {
            return 0;
        }
        switch (p1.getSide()) {
            case EAST: {
                return PortListSorter.realDegree(p2, OUT_EDGES) - PortListSorter.realDegree(p1, OUT_EDGES);
            }
            case WEST: {
                return PortListSorter.realDegree(p1, IN_EDGES) - PortListSorter.realDegree(p2, IN_EDGES);
            }
        }
        return 0;
    };
    public static final Comparator<LPort> CMP_FIXED_ORDER_AND_FIXED_POS = (p1, p2) -> {
        PortConstraints portConstraints = (PortConstraints)p1.getNode().getProperty(LayeredOptions.PORT_CONSTRAINTS);
        int ordinalDifference = p1.getSide().ordinal() - p2.getSide().ordinal();
        if (ordinalDifference != 0 || !portConstraints.isOrderFixed()) {
            return 0;
        }
        if (portConstraints == PortConstraints.FIXED_ORDER) {
            int indexDifference;
            Integer index1 = (Integer)p1.getProperty(LayeredOptions.PORT_INDEX);
            Integer index2 = (Integer)p2.getProperty(LayeredOptions.PORT_INDEX);
            if (index1 != null && index2 != null && (indexDifference = index1 - index2) != 0) {
                return indexDifference;
            }
        }
        switch (p1.getSide()) {
            case NORTH: {
                return Double.compare(p1.getPosition().x, p2.getPosition().x);
            }
            case EAST: {
                return Double.compare(p1.getPosition().y, p2.getPosition().y);
            }
            case SOUTH: {
                return Double.compare(p2.getPosition().x, p1.getPosition().x);
            }
            case WEST: {
                return Double.compare(p2.getPosition().y, p1.getPosition().y);
            }
        }
        throw new IllegalStateException("Port side is undefined");
    };
    public static final Comparator<LPort> CMP_COMBINED = CMP_PORT_SIDE.thenComparing(CMP_FIXED_ORDER_AND_FIXED_POS);

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Port order processing", 1.0f);
        PortSortingStrategy pss = (PortSortingStrategy)((Object)layeredGraph.getProperty(LayeredOptions.PORT_SORTING_STRATEGY));
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                PortConstraints portConstraints = (PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS);
                List<LPort> ports = node.getPorts();
                if (portConstraints.isOrderFixed()) {
                    Collections.sort(ports, CMP_COMBINED);
                } else if (portConstraints.isSideFixed()) {
                    Collections.sort(ports, CMP_PORT_SIDE);
                    this.reverseWestAndSouthSide(ports);
                    if (pss == PortSortingStrategy.PORT_DEGREE) {
                        Collections.sort(ports, CMP_PORT_DEGREE_EAST_WEST);
                    }
                }
                node.cachePortSides();
            }
        }
        monitor.done();
    }

    private void reverseWestAndSouthSide(List<LPort> ports) {
        if (ports.size() <= 1) {
            return;
        }
        Pair<Integer, Integer> southIndices = this.findPortSideRange(ports, PortSide.SOUTH);
        this.reverse(ports, (Integer)southIndices.getFirst(), (Integer)southIndices.getSecond());
        Pair<Integer, Integer> westIndices = this.findPortSideRange(ports, PortSide.WEST);
        this.reverse(ports, (Integer)westIndices.getFirst(), (Integer)westIndices.getSecond());
    }

    private Pair<Integer, Integer> findPortSideRange(List<LPort> ports, PortSide side) {
        if (ports.isEmpty()) {
            return Pair.of((Object)0, (Object)0);
        }
        PortSide currentSide = ports.get(0).getSide();
        int lowIdx = 0;
        int lb = side.ordinal();
        int hb = side.ordinal() + 1;
        while (lowIdx < ports.size() - 1 && currentSide.ordinal() < lb) {
            currentSide = ports.get(++lowIdx).getSide();
        }
        int highIdx = lowIdx;
        while (highIdx < ports.size() - 1 && currentSide.ordinal() < hb) {
            ++highIdx;
            currentSide = ports.get(lowIdx).getSide();
        }
        return Pair.of((Object)lowIdx, (Object)highIdx);
    }

    private void reverse(List<LPort> ports, int lowIdx, int highIdx) {
        if (highIdx <= lowIdx + 2) {
            return;
        }
        int n = (highIdx - lowIdx) / 2;
        int i = 0;
        while (i < n) {
            LPort tmp = ports.get(lowIdx + i);
            ports.set(lowIdx + i, ports.get(highIdx - i - 1));
            ports.set(highIdx - i - 1, tmp);
            ++i;
        }
    }

    private static int realDegree(LPort p, Function<LPort, Iterable<LEdge>> edgesFun) {
        int realDegree = 0;
        for (LEdge e : edgesFun.apply(p)) {
            if (((Boolean)e.getProperty(InternalProperties.REVERSED)).booleanValue()) continue;
            ++realDegree;
        }
        return realDegree;
    }
}

