/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.routing;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.OrthogonalSelfLoopRouter;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.splines.NubSpline;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;

public class SplineSelfLoopRouter
extends OrthogonalSelfLoopRouter {
    private static final int DIM = 3;
    private static final double HALF = 0.5;

    @Override
    protected KVectorChain modifyBendPoints(SelfLoopEdge slEdge, OrthogonalSelfLoopRouter.EdgeRoutingDirection routingDirection, KVectorChain bendPoints) {
        double edgeLabelDistance = LGraphUtil.getIndividualOrInherited(slEdge.getSLHyperLoop().getSLHolder().getLNode(), LayeredOptions.SPACING_EDGE_LABEL);
        KVectorChain splineBendPoints = new KVectorChain(new KVector[]{this.relativePortAnchor(slEdge.getSLSource())});
        this.addSplineControlPoints(slEdge, routingDirection, bendPoints, splineBendPoints, edgeLabelDistance);
        splineBendPoints.add((Object)this.relativePortAnchor(slEdge.getSLTarget()));
        return new NubSpline(true, 3, (List<KVector>)splineBendPoints).getBezierCP();
    }

    private KVector relativePortAnchor(SelfLoopPort slPort) {
        LPort lPort = slPort.getLPort();
        return new KVector(lPort.getPosition()).add(lPort.getAnchor());
    }

    private void addSplineControlPoints(SelfLoopEdge slEdge, OrthogonalSelfLoopRouter.EdgeRoutingDirection routingDirection, KVectorChain orthoBendPoints, KVectorChain newBendPoints, double edgeLabelDistance) {
        assert (orthoBendPoints.size() >= 2);
        PortSide currPortSide = slEdge.getSLSource().getLPort().getSide();
        KVector firstBP = (KVector)orthoBendPoints.get(0);
        int secondBPIndex = 1;
        while (secondBPIndex < orthoBendPoints.size()) {
            KVector secondBP = (KVector)orthoBendPoints.get(secondBPIndex);
            newBendPoints.add((Object)firstBP);
            KVector midBP = new KVector(firstBP).add(secondBP).scale(0.5);
            KVector offset = new KVector(SplinesMath.portSideToDirection(currPortSide)).scale(edgeLabelDistance);
            midBP.add(offset);
            newBendPoints.add((Object)midBP);
            firstBP = secondBP;
            currPortSide = routingDirection == OrthogonalSelfLoopRouter.EdgeRoutingDirection.CLOCKWISE ? currPortSide.right() : currPortSide.left();
            ++secondBPIndex;
        }
        newBendPoints.add((Object)((KVector)orthoBendPoints.getLast()));
    }
}

