/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.spore;

import com.google.common.math.DoubleMath;
import org.eclipse.elk.alg.common.Tree;
import org.eclipse.elk.alg.common.spore.Node;
import org.eclipse.elk.alg.common.utils.SVGImage;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;

public final class DepthFirstCompaction {
    private static Tree<Node> root;
    private static boolean orthogonalCompaction;
    private static SVGImage svg;

    static {
        orthogonalCompaction = false;
    }

    private DepthFirstCompaction() {
    }

    public static void compact(Tree<Node> tree, boolean orthogonal, String debugOutputFile) {
        svg = new SVGImage(debugOutputFile);
        orthogonalCompaction = orthogonal;
        root = tree;
        DepthFirstCompaction.debugOut(tree, null);
        DepthFirstCompaction.compactTree(root);
    }

    public static void compact(Tree<Node> tree, boolean orthogonal) {
        DepthFirstCompaction.compact(tree, orthogonal, null);
    }

    private static void compactTree(Tree<Node> tree) {
        tree.children.forEach(DepthFirstCompaction::compactTree);
        for (Tree<Node> tree2 : tree.children) {
            KVector compactionVector = ((Node)tree.node).vertex.clone().sub(((Node)tree2.node).vertex);
            if (orthogonalCompaction) {
                ElkRectangle rt = ((Node)tree.node).rect;
                ElkRectangle rc = ((Node)tree2.node).rect;
                if (Math.abs(compactionVector.x) >= Math.abs(compactionVector.y)) {
                    compactionVector.y = 0.0;
                    if (rc.y + rc.height > rt.y && rc.y < rt.y + rt.height) {
                        compactionVector.scaleToLength(Math.max(rt.x - (rc.x + rc.width), rc.x - (rt.x + rt.width)));
                    }
                } else {
                    compactionVector.x = 0.0;
                    if (rc.x + rc.width > rt.x && rc.x < rt.x + rt.width) {
                        compactionVector.scaleToLength(Math.max(rt.y - (rc.y + rc.height), rc.y - (rt.y + rt.height)));
                    }
                }
            } else {
                compactionVector.scaleToLength(((Node)tree.node).underlap((Node)tree2.node));
            }
            double minUnderlap = compactionVector.length();
            minUnderlap = DepthFirstCompaction.getMinUnderlap(root, tree2, minUnderlap, compactionVector);
            compactionVector.scaleToLength(minUnderlap);
            DepthFirstCompaction.translateSubtree(tree2, compactionVector);
            DepthFirstCompaction.debugOut(tree, tree2);
        }
    }

    private static double getMinUnderlap(Tree<Node> tree, Tree<Node> child, double currentMinUnderlap, KVector compactionVector) {
        double minUnderlap = Math.min(currentMinUnderlap, DepthFirstCompaction.minUnderlapWithSubtree((Node)tree.node, child, currentMinUnderlap, compactionVector));
        for (Tree<Node> tree2 : tree.children) {
            if (tree2 == child) continue;
            minUnderlap = Math.min(minUnderlap, DepthFirstCompaction.getMinUnderlap(tree2, child, minUnderlap, compactionVector));
        }
        return minUnderlap;
    }

    private static double minUnderlapWithSubtree(Node r, Tree<Node> tree, double currentMinUnderlap, KVector compactionVector) {
        double minUnderlap = currentMinUnderlap;
        for (Tree<Node> tree2 : tree.children) {
            Node c = (Node)tree2.node;
            if (r.touches(c)) {
                if (DoubleMath.fuzzyCompare((double)c.rect.x, (double)(r.rect.x + r.rect.width), (double)1.0E-4) == 0 && compactionVector.x < 0.0 || DoubleMath.fuzzyCompare((double)(c.rect.x + c.rect.width), (double)r.rect.x, (double)1.0E-4) == 0 && compactionVector.x > 0.0 || DoubleMath.fuzzyCompare((double)c.rect.y, (double)(r.rect.y + r.rect.height), (double)1.0E-4) == 0 && compactionVector.y < 0.0 || DoubleMath.fuzzyCompare((double)(c.rect.y + c.rect.height), (double)r.rect.y, (double)1.0E-4) == 0 && compactionVector.y > 0.0) {
                    minUnderlap = 0.0;
                    break;
                }
            } else {
                minUnderlap = Math.min(minUnderlap, r.distance(c, compactionVector));
            }
            minUnderlap = Math.min(minUnderlap, DepthFirstCompaction.minUnderlapWithSubtree(r, tree2, minUnderlap, compactionVector));
        }
        return minUnderlap;
    }

    private static void translateSubtree(Tree<Node> tree, KVector compactionVector) {
        ((Node)tree.node).translate(compactionVector);
        tree.children.forEach(c -> DepthFirstCompaction.translateSubtree(c, compactionVector));
    }

    private static void drawTree(Tree<Node> t, SVGImage svgImage, Tree<Node> mark) {
        svgImage.g("rects").addRect(((Node)t.node).rect, "fill=\"none\" stroke=\"black\"");
        svgImage.g("centers").addCircle(((Node)t.node).vertex.x, ((Node)t.node).vertex.y, 6.0, "fill=\"black\"");
        t.children.forEach(c -> {
            if (c == mark) {
                svgImage.g("edges").addLine(((Node)tree2.node).vertex.x, ((Node)tree2.node).vertex.y, ((Node)c.node).vertex.x, ((Node)c.node).vertex.y, "stroke=\"red\" stroke-width=\"5\" stroke-dasharray=\"8,8\"");
            } else {
                svgImage.g("edges").addLine(((Node)tree2.node).vertex.x, ((Node)tree2.node).vertex.y, ((Node)c.node).vertex.x, ((Node)c.node).vertex.y, "stroke=\"blue\" stroke-width=\"2\"");
            }
            DepthFirstCompaction.drawTree(c, svgImage, mark);
        });
    }

    private static void debugOut(Tree<Node> tree, Tree<Node> mark) {
        svg.clear();
        svg.addGroups("rects", "root", "edges", "centers", "marks");
        svg.g("root").addRect(((Node)DepthFirstCompaction.root.node).rect, "fill=\"#C4E3F3\" stroke=\"black\"");
        DepthFirstCompaction.drawTree(root, svg, mark);
        svg.isave();
    }
}

