/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.position;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.SelfLoopOrderingStrategy;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.position.AbstractSelfLoopPortPositioner;
import org.eclipse.elk.core.options.PortSide;

public class NorthSelfLoopPortPositioner
extends AbstractSelfLoopPortPositioner {
    private SelfLoopOrderingStrategy ordering;

    public NorthSelfLoopPortPositioner(SelfLoopOrderingStrategy ordering) {
        this.ordering = ordering;
    }

    @Override
    public void position(LNode node) {
        SelfLoopNode slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        List<SelfLoopComponent> components = slNode.getSelfLoopComponents();
        components.sort((comp1, comp2) -> Integer.compare(comp1.getPorts().size(), comp2.getPorts().size()));
        List nonLoopComponents = components.stream().filter(comp -> comp.getPorts().size() == 1).collect(Collectors.toList());
        components.removeAll(nonLoopComponents);
        if (this.ordering == SelfLoopOrderingStrategy.STACKED) {
            this.stackComponents(slNode, components, PortSide.NORTH);
        } else {
            this.sequenceComponents(slNode, components, PortSide.NORTH);
        }
    }
}

