/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.ui.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ElkGraphProposalProvider
extends AbstractContentProposalProvider {
    private static final int MAX_ENTRIES = 1000;
    @Inject
    private IdeContentProposalProvider ideProvider;
    @Inject
    private Provider<ContentAssistContext.Builder> builderProvider;
    @Inject
    private ElkGraphGrammarAccess grammar;
    @Inject
    private IImageHelper imageHelper;

    public void createProposals(final org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        final ArrayList entries = new ArrayList();
        IIdeContentProposalAcceptor ideAcceptor = new IIdeContentProposalAcceptor(){

            public void accept(ContentAssistEntry entry, int priority) {
                if (entry != null) {
                    Pair _mappedTo = Pair.of((Object)entry, (Object)priority);
                    entries.add(_mappedTo);
                }
            }

            public boolean canAcceptMoreProposals() {
                int _size = entries.size();
                return _size < 1000;
            }
        };
        ContentAssistContext _ideContext = this.getIdeContext(context);
        this.ideProvider.createProposals(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ContentAssistContext[]{_ideContext})), ideAcceptor);
        final AbstractContentProposalProvider.NullSafeCompletionProposalAcceptor uiAcceptor = new AbstractContentProposalProvider.NullSafeCompletionProposalAcceptor(acceptor);
        Procedures.Procedure2<Pair<ContentAssistEntry, Integer>, Integer> _function = new Procedures.Procedure2<Pair<ContentAssistEntry, Integer>, Integer>(){

            public void apply(Pair<ContentAssistEntry, Integer> p, Integer index) {
                ContentAssistEntry entry = (ContentAssistEntry)p.getKey();
                ConfigurableCompletionProposal proposal = ElkGraphProposalProvider.this.doCreateProposal(entry.getProposal(), ElkGraphProposalProvider.this.getDisplayString(entry), ElkGraphProposalProvider.this.getImage(entry), (Integer)p.getValue(), context);
                uiAcceptor.accept((ICompletionProposal)proposal);
            }
        };
        IterableExtensions.forEach(entries, (Procedures.Procedure2)_function);
    }

    public void completeAssignment(Assignment object, org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void completeKeyword(Keyword object, org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void completeRuleCall(RuleCall object, org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    protected StyledString getDisplayString(ContentAssistEntry entry) {
        boolean _not;
        String _proposal;
        String _elvis = null;
        String _label = entry.getLabel();
        _elvis = _label != null ? _label : (_proposal = entry.getProposal());
        StyledString result = new StyledString(_elvis);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)entry.getDescription());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description = entry.getDescription();
            String _plus = " \u2013 " + _description;
            StyledString _styledString = new StyledString(_plus, StyledString.QUALIFIER_STYLER);
            result.append(_styledString);
        }
        return result;
    }

    private ContentAssistContext getIdeContext(org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext c) {
        ContentAssistContext.Builder builder = (ContentAssistContext.Builder)this.builderProvider.get();
        Region replaceRegion = c.getReplaceRegion();
        ContentAssistContext.Builder _setOffset = builder.setPrefix(c.getPrefix()).setSelectedText(c.getSelectedText()).setRootModel(c.getRootModel()).setRootNode(c.getRootNode()).setCurrentModel(c.getCurrentModel()).setPreviousModel(c.getPreviousModel()).setCurrentNode(c.getCurrentNode()).setLastCompleteNode(c.getLastCompleteNode()).setOffset(c.getOffset());
        int _offset = replaceRegion.getOffset();
        int _length = replaceRegion.getLength();
        TextRegion _textRegion = new TextRegion(_offset, _length);
        _setOffset.setReplaceRegion((ITextRegion)_textRegion).setResource(c.getResource());
        ImmutableList _firstSetGrammarElements = c.getFirstSetGrammarElements();
        for (AbstractElement grammarElement : _firstSetGrammarElements) {
            builder.accept(grammarElement);
        }
        return builder.toContext();
    }

    protected Image getImage(ContentAssistEntry entry) {
        Object _source;
        Image _switchResult = null;
        Object source = _source = entry.getSource();
        boolean _matched = false;
        if (source instanceof IEObjectDescription) {
            _matched = true;
            _switchResult = this.getImage((IEObjectDescription)source);
        }
        if (!_matched && source instanceof EObject) {
            _matched = true;
            _switchResult = this.getImage((EObject)source);
        }
        if (!_matched && source instanceof LayoutOptionData) {
            _matched = true;
            _switchResult = this.getImage((LayoutOptionData)source, entry.getProposal());
        }
        if (!_matched && source instanceof LayoutAlgorithmData) {
            _matched = true;
            _switchResult = this.imageHelper.getImage("prop_text.gif");
        }
        return _switchResult;
    }

    protected Image getImage(EObject eObject) {
        if (eObject instanceof Keyword) {
            String key;
            Keyword _labelKeyword_0;
            Keyword _portKeyword_0;
            Keyword _edgeKeyword_0;
            Keyword _nodeKeyword_0;
            String _switchResult = null;
            boolean _matched = false;
            Keyword _graphKeyword_1_0 = this.grammar.getRootNodeAccess().getGraphKeyword_1_0();
            if (Objects.equal((Object)eObject, (Object)_graphKeyword_1_0)) {
                _matched = true;
                _switchResult = "elkgraph";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_nodeKeyword_0 = this.grammar.getElkNodeAccess().getNodeKeyword_0()))) {
                _matched = true;
                _switchResult = "elknode";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_edgeKeyword_0 = this.grammar.getElkEdgeAccess().getEdgeKeyword_0()))) {
                _matched = true;
                _switchResult = "elkedge";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_portKeyword_0 = this.grammar.getElkPortAccess().getPortKeyword_0()))) {
                _matched = true;
                _switchResult = "elkport";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_labelKeyword_0 = this.grammar.getElkLabelAccess().getLabelKeyword_0()))) {
                _matched = true;
                _switchResult = "elklabel";
            }
            if ((key = _switchResult) != null) {
                return this.imageHelper.getImage(String.valueOf(key) + ".gif");
            }
        }
        return super.getImage(eObject);
    }

    private Image getImage(LayoutOptionData option, String value) {
        String _switchResult = null;
        LayoutOptionData.Type _type = option.getType();
        if (_type != null) {
            switch (_type) {
                case BOOLEAN: {
                    String _xifexpression = null;
                    boolean _equals = Objects.equal((Object)value, (Object)"false");
                    _xifexpression = _equals ? "prop_false" : "prop_true";
                    _switchResult = _xifexpression;
                    break;
                }
                case INT: {
                    _switchResult = "prop_int";
                    break;
                }
                case DOUBLE: {
                    _switchResult = "prop_double";
                    break;
                }
                case ENUM: 
                case ENUMSET: {
                    _switchResult = "prop_choice";
                    break;
                }
                default: {
                    _switchResult = "prop_text";
                    break;
                }
            }
        } else {
            _switchResult = "prop_text";
        }
        String key = _switchResult;
        return this.imageHelper.getImage(String.valueOf(key) + ".gif");
    }
}

