/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.compaction.oned;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.elk.alg.common.compaction.oned.CGraph;
import org.eclipse.elk.alg.common.compaction.oned.CNode;

public final class CGroup {
    public int id;
    public CNode master;
    public Set<CNode> cNodes;
    public double startPos = Double.NEGATIVE_INFINITY;
    public Set<CNode> incomingConstraints;
    public int outDegree = 0;
    public int outDegreeReal = 0;
    protected CNode reference;
    public double delta = 0.0;
    public double deltaNormalized = 0.0;

    private CGroup() {
        this.cNodes = Sets.newLinkedHashSet();
        this.incomingConstraints = Sets.newHashSet();
    }

    public static CGroupBuilder of() {
        return new CGroupBuilder();
    }

    public void addCNode(CNode cNode) {
        if (cNode.cGroup != null) {
            throw new RuntimeException("CNode belongs to another CGroup.");
        }
        this.cNodes.add(cNode);
        cNode.cGroup = this;
        if (this.reference == null) {
            this.reference = cNode;
        }
    }

    public boolean removeCNode(CNode cNode) {
        boolean removed = this.cNodes.remove(cNode);
        if (removed) {
            cNode.cGroup = null;
        }
        return removed;
    }

    /* synthetic */ CGroup(CGroup cGroup) {
        this();
    }

    public static final class CGroupBuilder {
        private CGroup group = new CGroup(null);

        private CGroupBuilder() {
        }

        public CGroupBuilder nodes(CNode ... nodes) {
            CNode[] cNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                CNode n3 = cNodeArray[n2];
                this.group.addCNode(n3);
                ++n2;
            }
            return this;
        }

        public CGroupBuilder reference(CNode referenceNode) {
            this.group.reference = referenceNode;
            return this;
        }

        public CGroupBuilder master(CNode master) {
            this.group.master = master;
            return this;
        }

        public CGroup create(CGraph graph) {
            graph.cGroups.add(this.group);
            return this.group;
        }
    }
}

