/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import com.google.common.collect.Iterables;
import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.nodespacing.Rectangle;

public final class CLNode
extends CNode {
    private double horizontalSpacing;
    private double verticalSpacing;
    private LNode lNode;

    public CLNode(LNode lNode, LGraph layeredGraph) {
        this.horizontalSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.verticalSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        this.lNode = lNode;
        this.hitbox = new Rectangle(lNode.getPosition().x - lNode.getMargin().left, lNode.getPosition().y - lNode.getMargin().top, lNode.getSize().x + lNode.getMargin().left + lNode.getMargin().right, lNode.getSize().y + lNode.getMargin().top + lNode.getMargin().bottom);
        this.cGroupOffset.reset();
        int difference = Iterables.size(lNode.getIncomingEdges()) - Iterables.size(lNode.getOutgoingEdges());
        if (difference < 0) {
            this.lock.set(true, Direction.LEFT);
        } else if (difference > 0) {
            this.lock.set(true, Direction.RIGHT);
        }
        if (lNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            this.lock.set(false, false, false, false);
        }
    }

    public LNode getlNode() {
        return this.lNode;
    }

    @Override
    public void applyElementPosition() {
        this.lNode.getPosition().x = this.hitbox.x + this.lNode.getMargin().left;
    }

    @Override
    public double getElementPosition() {
        return this.lNode.getPosition().x;
    }

    @Override
    public double getHorizontalSpacing() {
        if (this.lNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            return 0.0;
        }
        return this.horizontalSpacing;
    }

    @Override
    public double getVerticalSpacing() {
        if (this.lNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            return 0.0;
        }
        return this.verticalSpacing;
    }

    public String toString() {
        return this.lNode.getProperty(InternalProperties.ORIGIN).toString();
    }
}

