/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import java.util.EnumSet;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.AlgorithmFactory;
import org.eclipse.elk.core.util.BoxLayoutProvider;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class BoxLayouterOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.box";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 15.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)15.0);
    private static final int PRIORITY_DEFAULT = 0;
    public static final IProperty<Integer> PRIORITY = new Property(CoreOptions.PRIORITY, (Object)0);
    public static final IProperty<Boolean> EXPAND_NODES = CoreOptions.EXPAND_NODES;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    private static final double ASPECT_RATIO_DEFAULT = (double)1.3f;
    public static final IProperty<Double> ASPECT_RATIO = new Property(CoreOptions.ASPECT_RATIO, (Object)1.3f);
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = CoreOptions.NODE_SIZE_MINIMUM;
    @Deprecated
    public static final IProperty<Double> NODE_SIZE_MIN_WIDTH = CoreOptions.NODE_SIZE_MIN_WIDTH;
    @Deprecated
    public static final IProperty<Double> NODE_SIZE_MIN_HEIGHT = CoreOptions.NODE_SIZE_MIN_HEIGHT;
    public static final IProperty<BoxLayoutProvider.PackingMode> BOX_PACKING_MODE = CoreOptions.BOX_PACKING_MODE;

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData(ALGORITHM_ID, "Box Layout", "Algorithm for packing of unconnected boxes, i.e. graphs without edges.", new AlgorithmFactory(BoxLayoutProvider.class, ""), null, "ELK", "images/box_layout.png", null));
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", 15.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.priority", 0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.expandNodes", EXPAND_NODES.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", 1.3f);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.minimum", NODE_SIZE_MINIMUM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.minWidth", NODE_SIZE_MIN_WIDTH.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.minHeight", NODE_SIZE_MIN_HEIGHT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.box.packingMode", BOX_PACKING_MODE.getDefault());
    }
}

