/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import org.eclipse.elk.alg.mrtree.ILayoutProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.FanProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.LevelHeightProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.NeighborsProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.NodePositionProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.RootProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.Untreeifyer;

public enum IntermediateProcessorStrategy {
    ROOT_PROC,
    FAN_PROC,
    NEIGHBORS_PROC,
    LEVEL_HEIGHT,
    NODE_POSITION_PROC,
    DETREEIFYING_PROC;


    public ILayoutProcessor create() {
        switch (this) {
            case ROOT_PROC: {
                return new RootProcessor();
            }
            case FAN_PROC: {
                return new FanProcessor();
            }
            case NEIGHBORS_PROC: {
                return new NeighborsProcessor();
            }
            case LEVEL_HEIGHT: {
                return new LevelHeightProcessor();
            }
            case NODE_POSITION_PROC: {
                return new NodePositionProcessor();
            }
            case DETREEIFYING_PROC: {
                return new Untreeifyer();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layout processor " + this.toString());
    }
}

