/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.properties;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;

public class MapPropertyHolder
implements IPropertyHolder,
Serializable {
    private static final long serialVersionUID = 4507851447415709893L;
    private HashMap<IProperty<?>, Object> propertyMap;

    @Override
    public <T> MapPropertyHolder setProperty(IProperty<? super T> property, T value) {
        if (value == null) {
            this.getProperties().remove(property);
        } else {
            this.getProperties().put(property, value);
        }
        return this;
    }

    @Override
    public <T> T getProperty(IProperty<T> property) {
        T defaultValue;
        Object value = this.getProperties().get(property);
        if (value instanceof IPropertyValueProxy) {
            if ((value = ((IPropertyValueProxy)value).resolveValue(property)) != null) {
                this.getProperties().put(property, value);
                return (T)value;
            }
        } else if (value != null) {
            return (T)value;
        }
        if ((defaultValue = property.getDefault()) instanceof Cloneable) {
            this.setProperty(property, (Object)defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean hasProperty(IProperty<?> property) {
        return this.propertyMap != null && this.propertyMap.containsKey(property);
    }

    @Override
    public MapPropertyHolder copyProperties(IPropertyHolder other) {
        if (other == null) {
            return this;
        }
        Map<IProperty<?>, Object> otherMap = other.getAllProperties();
        if (!otherMap.isEmpty()) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap(otherMap);
            } else {
                this.propertyMap.putAll(otherMap);
            }
        }
        return this;
    }

    @Override
    public Map<IProperty<?>, Object> getAllProperties() {
        if (this.propertyMap == null) {
            return Collections.emptyMap();
        }
        return this.propertyMap;
    }

    private Map<IProperty<?>, Object> getProperties() {
        if (this.propertyMap == null) {
            this.propertyMap = Maps.newHashMap();
        }
        return this.propertyMap;
    }
}

