/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.eclipse.resources.mgt.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.eclipse.resources.mgt.util.EclipseModelsAccessor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class UpdateFeatureOperation
extends WorkspaceModifyOperation {
    private String _featureID;
    private String _pluginID;
    private String _featureToIncludeID;
    private final String DEFAULT_VERSION = "0.0.0";

    public UpdateFeatureOperation(String featureID, String pluginID, String featureToIncludeID) {
        this._featureID = featureID;
        this._pluginID = pluginID;
        this._featureToIncludeID = featureToIncludeID;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Assert.isNotNull((Object)this._featureID, (String)"Feature ID must be not null");
        Assert.isTrue((this._featureID == null || this._featureID.trim().length() != 0 ? 1 : 0) != 0, (String)"Feature ID must be not empty");
        IProject fProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this._featureID);
        fProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IFile file = PDEProject.getFeatureXml((IProject)fProject);
        WorkspaceFeatureModel model = new WorkspaceFeatureModel(file);
        model.load();
        IFeature feature = model.getFeature();
        if (feature == null) {
            return;
        }
        if (this._pluginID != null && this._pluginID.length() != 0) {
            this.addPlugin(feature, this._pluginID);
        }
        if (this._featureToIncludeID != null && this._featureToIncludeID.length() != 0) {
            this.addFeature(feature, this._featureToIncludeID);
        }
        model.save();
        model.dispose();
    }

    private void addPlugin(IFeature feature, String pName) {
        try {
            IPluginModelBase[] pluginList = new IPluginModelBase[]{EclipseModelsAccessor.getPluginModelBase(pName)};
            this.addPlugins(feature, pluginList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void addPlugins(IFeature feature, IPluginModelBase[] candidates) throws CoreException {
        IFeatureModel model = feature.getModel();
        IFeaturePlugin[] candidate_plugin = new IFeaturePlugin[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IPluginModelBase candidate = candidates[i];
            FeaturePlugin fplugin = (FeaturePlugin)model.getFactory().createPlugin();
            fplugin.loadFrom(candidate.getPluginBase());
            fplugin.setVersion("0.0.0");
            fplugin.setUnpack(CoreUtility.guessUnpack((BundleDescription)candidate.getBundleDescription()));
            candidate_plugin[i] = fplugin;
            ++i;
        }
        IFeaturePlugin[] plugin_to_add = new IFeaturePlugin[]{};
        IFeaturePlugin[] existing_plugin = feature.getPlugins();
        int i2 = 0;
        while (i2 < candidate_plugin.length) {
            boolean add = true;
            IFeaturePlugin[] iFeaturePluginArray = existing_plugin;
            int n = existing_plugin.length;
            int n2 = 0;
            while (n2 < n) {
                IFeaturePlugin iFeaturePlugin = iFeaturePluginArray[n2];
                if (iFeaturePlugin.getId().equals(candidate_plugin[i2].getId())) {
                    add = false;
                    break;
                }
                ++n2;
            }
            if (add) {
                IFeaturePlugin[] temp_plugin_to_add = new IFeaturePlugin[plugin_to_add.length + 1];
                System.arraycopy(plugin_to_add, 0, temp_plugin_to_add, 0, plugin_to_add.length);
                temp_plugin_to_add[plugin_to_add.length] = candidate_plugin[i2];
                plugin_to_add = new IFeaturePlugin[temp_plugin_to_add.length];
                System.arraycopy(temp_plugin_to_add, 0, plugin_to_add, 0, plugin_to_add.length);
            }
            ++i2;
        }
        feature.addPlugins(plugin_to_add);
    }

    private void addFeature(IFeature feature, String fname) {
        try {
            IFeature[] featureToAdd = new IFeature[]{EclipseModelsAccessor.getFeature(fname)};
            this.addFeatures(feature, featureToAdd);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void addFeatures(IFeature feature, IFeature[] candidates) throws CoreException {
        IFeatureModel model = feature.getModel();
        IFeatureChild[] added = new IFeatureChild[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeature candidate = candidates[i];
            FeatureChild featureChild = (FeatureChild)model.getFactory().createChild();
            featureChild.loadFrom(candidate);
            featureChild.setVersion("0.0.0");
            added[i] = featureChild;
            ++i;
        }
        feature.addIncludedFeatures(added);
    }
}

