/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.controls.JavaFXCompatUtil;
import org.eclipse.fx.ui.keybindings.KeySequence;
import org.eclipse.fx.ui.keybindings.KeyStroke;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.renderers.base.BaseMenuItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuItem;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;

public class DefMenuItemRenderer
extends BaseMenuItemRenderer<MenuItem> {
    protected Class<? extends WMenuItem<MenuItem>> getWidgetClass(MMenuItem item) {
        return MenuItemImpl.class;
    }

    public static class MenuItemImpl
    extends WWidgetImpl<MenuItem, MMenuItem>
    implements WMenuItem<MenuItem> {
        private ItemType type;
        Runnable runnable;
        private boolean handled = true;
        private boolean enabled = true;
        @Inject
        GraphicsLoader graphicsLoader;
        @Inject
        @Log
        private Logger logger;

        @Inject
        public MenuItemImpl(@Named(value="type") ItemType type) {
            this.type = type;
        }

        @Override
        protected void bindProperties(MenuItem widget) {
            super.bindProperties(widget);
            if (widget instanceof CheckMenuItem) {
                this.bindProperty("selected", (ObservableValue<Object>)((CheckMenuItem)widget).selectedProperty());
            } else if (widget instanceof RadioMenuItem) {
                this.bindProperty("selected", (ObservableValue<Object>)((RadioMenuItem)widget).selectedProperty());
            }
        }

        public void addStyleClasses(List<String> classnames) {
            ((MenuItem)this.getWidget()).getStyleClass().addAll(classnames);
        }

        public void addStyleClasses(String ... classnames) {
            ((MenuItem)this.getWidget()).getStyleClass().addAll((Object[])classnames);
        }

        public void removeStyleClasses(List<String> classnames) {
            ((MenuItem)this.getWidget()).getStyleClass().removeAll(classnames);
        }

        public void removeStyleClasses(String ... classnames) {
            ((MenuItem)this.getWidget()).getStyleClass().removeAll((Object[])classnames);
        }

        public void setStyleId(String id) {
            ((MenuItem)this.getWidget()).setId(id);
        }

        @Override
        protected MenuItem createWidget() {
            final MenuItem item = this.internalCreateWidget();
            item.setMnemonicParsing(true);
            final AtomicBoolean skip = new AtomicBoolean(false);
            item.setOnMenuValidation((EventHandler)new EventHandler<Event>(){

                public void handle(Event event) {
                    if (!item.isDisable()) {
                        skip.set(true);
                    }
                }
            });
            item.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (skip.get()) {
                        skip.set(false);
                        return;
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
            return item;
        }

        private @NonNull MenuItem internalCreateWidget() {
            switch (this.type) {
                case CHECK: {
                    return new CheckMenuItem();
                }
                case RADIO: {
                    return new RadioMenuItem(null);
                }
            }
            return new MenuItem();
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") String label) {
            ((MenuItem)this.getWidget()).setText(label);
        }

        @Inject
        public void setSelected(@Named(value="selected") boolean selected) {
            RadioMenuItem r;
            if (this.getWidget() instanceof CheckMenuItem) {
                CheckMenuItem c = (CheckMenuItem)this.getWidget();
                if (c.isSelected() != selected) {
                    c.setSelected(selected);
                }
            } else if (this.getWidget() instanceof RadioMenuItem && (r = (RadioMenuItem)this.getWidget()).isSelected() != selected) {
                r.setSelected(selected);
            }
        }

        @Inject
        public void setEnabled(@Named(value="enabled") boolean enabled) {
            this.enabled = enabled;
            this.updateEnabledState();
        }

        @Inject
        public void setIconURI(@Named(value="iconURI") String uri) {
            if (Strings.isNullOrEmpty((String)uri)) {
                ((MenuItem)this.getWidget()).setGraphic(null);
            } else {
                ((MenuItem)this.getWidget()).setGraphic(this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)new EMFUri(URI.createURI((String)uri))));
            }
        }

        @Override
        protected void setUserData(WWidgetImpl<MenuItem, MMenuItem> widget) {
            ((MenuItem)this.getWidget()).setUserData(widget);
        }

        public void setOnActionCallback(Runnable runnable) {
            this.runnable = runnable;
        }

        public void setHandled(boolean handled) {
            if (this.handled != handled) {
                this.handled = handled;
                this.updateEnabledState();
            }
        }

        public void setAccelerator(KeySequence sequence) {
            if (sequence != null && sequence.getKeyStrokes().length == 1) {
                KeyStroke k = sequence.getKeyStrokes()[0];
                KeyCode keyCode = null;
                List collect = Arrays.asList(KeyCode.values()).stream().filter(code -> JavaFXCompatUtil.getCode((KeyCode)code) == k.getKeyCode()).collect(Collectors.toList());
                if (collect.size() > 0) {
                    keyCode = (KeyCode)collect.get(0);
                }
                if (keyCode != null) {
                    ((MenuItem)this.getWidget()).setAccelerator((KeyCombination)new KeyCodeCombination(keyCode, k.hasShiftModifier() ? KeyCombination.ModifierValue.DOWN : KeyCombination.ModifierValue.ANY, k.hasCtrlModifier() ? KeyCombination.ModifierValue.DOWN : KeyCombination.ModifierValue.ANY, k.hasAltModifier() ? KeyCombination.ModifierValue.DOWN : KeyCombination.ModifierValue.ANY, k.hasCommandModifier() ? KeyCombination.ModifierValue.DOWN : KeyCombination.ModifierValue.ANY, KeyCombination.ModifierValue.ANY));
                } else {
                    String message = NLS.bind((String)"No JavaFX KeyBinding found [keyCode={0}, character={1}]", (Object)k.getKeyCode(), (Object)Character.valueOf((char)k.getKeyCode()));
                    this.logger.warning(message);
                }
            } else {
                ((MenuItem)this.getWidget()).setAccelerator(null);
            }
        }

        private void updateEnabledState() {
            ((MenuItem)this.getWidget()).setDisable(!this.handled || !this.enabled);
        }
    }
}

