/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPPersistException
extends LDAPException {
    private static final long serialVersionUID = 8625904586803506713L;
    private final Object partiallyDecodedObject;

    public LDAPPersistException(LDAPException e) {
        super(e);
        this.partiallyDecodedObject = null;
    }

    public LDAPPersistException(String message) {
        super(ResultCode.LOCAL_ERROR, message);
        this.partiallyDecodedObject = null;
    }

    public LDAPPersistException(String message, Throwable cause) {
        super(ResultCode.LOCAL_ERROR, message, cause);
        this.partiallyDecodedObject = null;
    }

    public LDAPPersistException(String message, Object partiallyDecodedObject, Throwable cause) {
        super(ResultCode.LOCAL_ERROR, message, cause);
        this.partiallyDecodedObject = partiallyDecodedObject;
    }

    public Object getPartiallyDecodedObject() {
        return this.partiallyDecodedObject;
    }

    @Override
    public void toString(StringBuilder buffer) {
        Throwable cause;
        buffer.append("LDAPPersistException(message='");
        buffer.append(this.getMessage());
        buffer.append('\'');
        if (this.partiallyDecodedObject != null) {
            buffer.append(", partiallyDecodedObject=");
            buffer.append(this.partiallyDecodedObject);
        }
        if ((cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause));
        }
        buffer.append(')');
    }
}

