/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc;

import org.glassfish.jersey.server.mvc.internal.l10n.LocalizationMessages;

public class Viewable {
    private final String templateName;
    private final Object model;

    public Viewable(String templateName) throws IllegalArgumentException {
        this(templateName, null);
    }

    public Viewable(String templateName, Object model) throws IllegalArgumentException {
        if (templateName == null) {
            throw new IllegalArgumentException(LocalizationMessages.TEMPLATE_NAME_MUST_NOT_BE_NULL());
        }
        this.templateName = templateName;
        this.model = model;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public Object getModel() {
        return this.model;
    }

    public boolean isTemplateNameAbsolute() {
        return this.templateName.length() > 0 && this.templateName.charAt(0) == '/';
    }
}

