/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ThreadMgmtData
implements Serializable {
    private static final long serialVersionUID = -4031876173005308591L;
    private static final System.Logger LOG = System.getLogger(ThreadMgmtData.class.getName());
    private final List<ThreadContextSnapshot> snapshots;
    private final List<ThreadContextRestorer> restorers;

    public static ThreadMgmtData createNextGeneration(ThreadMgmtData oldGen) {
        ArrayList<ThreadContextRestorer> newRestorers = new ArrayList<ThreadContextRestorer>();
        for (ThreadContextSnapshot snapshot : oldGen.snapshots) {
            newRestorers.add(snapshot.begin());
        }
        return new ThreadMgmtData(Collections.emptyList(), newRestorers);
    }

    public ThreadMgmtData(List<ThreadContextSnapshot> snapshots) {
        this(snapshots, Collections.emptyList());
    }

    private ThreadMgmtData(List<ThreadContextSnapshot> snapshots, List<ThreadContextRestorer> restorers) {
        LOG.log(System.Logger.Level.TRACE, "ThreadMgmtData(snapshots={0}, restorers={1})", snapshots, restorers);
        this.snapshots = snapshots;
        this.restorers = restorers;
    }

    public void endContext() {
        for (ThreadContextRestorer restorer : this.restorers) {
            restorer.endContext();
        }
    }
}

