/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InterceptorUtil {
    private static Map<Class, Set<Class>> compatiblePrimitiveWrapper = new HashMap<Class, Set<Class>>();

    public static boolean hasCompatiblePrimitiveWrapper(Class type, Class typeTo) {
        Set<Class> compatibles = compatiblePrimitiveWrapper.get(type);
        return compatibles.contains(typeTo);
    }

    public static void checkSetParameters(Object[] params, Method method) {
        if (method != null) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (params == null && paramTypes.length != 0) {
                throw new IllegalArgumentException("Wrong number of parameters for  method: " + String.valueOf(method));
            }
            if (params != null && paramTypes.length != params.length) {
                throw new IllegalArgumentException("Wrong number of parameters for  method: " + String.valueOf(method));
            }
            int index = 0;
            for (Class<?> type : paramTypes) {
                if (params[index] == null) {
                    if (type.isPrimitive()) {
                        throw new IllegalArgumentException("Parameter type mismatch for method " + method.getName() + ".  Attempt to set a null value for Arg[" + index + "]. Expected a value of type: " + type.getName());
                    }
                } else if (type.isPrimitive()) {
                    Set<Class> compatibles = compatiblePrimitiveWrapper.get(type);
                    if (!compatibles.contains(params[index].getClass())) {
                        throw new IllegalArgumentException("Parameter type mismatch for method " + method.getName() + ".  Arg[" + index + "] type: " + params[index].getClass().getName() + " is not compatible with the expected type: " + type.getName());
                    }
                } else if (!type.isAssignableFrom(params[index].getClass())) {
                    throw new IllegalArgumentException("Parameter type mismatch for method " + method.getName() + ".  Arg[" + index + "] type: " + params[index].getClass().getName() + " does not match the expected type: " + type.getName());
                }
                ++index;
            }
        } else {
            throw new IllegalStateException("Internal Error: Got null method");
        }
    }

    static {
        HashSet<Class<Short>> smallerPrimitiveWrappers = null;
        smallerPrimitiveWrappers = new HashSet<Class<Short>>();
        smallerPrimitiveWrappers.add(Byte.class);
        compatiblePrimitiveWrapper.put(Byte.TYPE, smallerPrimitiveWrappers);
        smallerPrimitiveWrappers = new HashSet();
        smallerPrimitiveWrappers.add(Boolean.class);
        compatiblePrimitiveWrapper.put(Boolean.TYPE, smallerPrimitiveWrappers);
        smallerPrimitiveWrappers = new HashSet();
        smallerPrimitiveWrappers.add(Character.class);
        compatiblePrimitiveWrapper.put(Character.TYPE, smallerPrimitiveWrappers);
        smallerPrimitiveWrappers = new HashSet();
        smallerPrimitiveWrappers.add(Byte.class);
        smallerPrimitiveWrappers.add(Short.class);
        smallerPrimitiveWrappers.add(Integer.class);
        smallerPrimitiveWrappers.add(Float.class);
        smallerPrimitiveWrappers.add(Double.class);
        compatiblePrimitiveWrapper.put(Double.TYPE, smallerPrimitiveWrappers);
        smallerPrimitiveWrappers = new HashSet();
        smallerPrimitiveWrappers.add(Byte.class);
        smallerPrimitiveWrappers.add(Short.class);
        smallerPrimitiveWrappers.add(Integer.class);
        smallerPrimitiveWrappers.add(Float.class);
        compatiblePrimitiveWrapper.put(Float.TYPE, smallerPrimitiveWrappers);
        smallerPrimitiveWrappers = new HashSet();
        smallerPrimitiveWrappers.add(Byte.class);
        smallerPrimitiveWrappers.add(Short.class);
        smallerPrimitiveWrappers.add(Integer.class);
        compatiblePrimitiveWrapper.put(Integer.TYPE, smallerPrimitiveWrappers);
        smallerPrimitiveWrappers = new HashSet();
        smallerPrimitiveWrappers.add(Byte.class);
        smallerPrimitiveWrappers.add(Short.class);
        smallerPrimitiveWrappers.add(Integer.class);
        smallerPrimitiveWrappers.add(Long.class);
        compatiblePrimitiveWrapper.put(Long.TYPE, smallerPrimitiveWrappers);
        smallerPrimitiveWrappers = new HashSet();
        smallerPrimitiveWrappers.add(Byte.class);
        smallerPrimitiveWrappers.add(Short.class);
        compatiblePrimitiveWrapper.put(Short.TYPE, smallerPrimitiveWrappers);
    }
}

