/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web.servlet;

import jakarta.servlet.ServletContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.bootstrap.api.Service;

public class ServletContextService
implements Service {
    private final Map<ClassLoader, ServletContext> servletContexts = new ConcurrentHashMap<ClassLoader, ServletContext>();

    void contextInitialized(ServletContext context) {
        ClassLoader cl = this.getContextClassLoader();
        if (cl != null) {
            this.servletContexts.put(cl, context);
        }
    }

    public ServletContext getCurrentServletContext() {
        ClassLoader cl = this.getContextClassLoader();
        if (cl == null) {
            return null;
        }
        return this.servletContexts.get(cl);
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void cleanup() {
        this.servletContexts.clear();
    }

    public String toString() {
        return "ServletContextService [" + this.servletContexts + "]";
    }
}

