/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.cache;

import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.admin.util.cache.AdminCache;
import com.sun.enterprise.admin.util.cache.AdminCacheUtils;
import com.sun.enterprise.admin.util.cache.DataProvider;
import com.sun.enterprise.security.store.AsadminSecurityUtil;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminCacheFileStore
implements AdminCache {
    private static final String DEFAULT_FILENAME = "#default#.cache";
    private static final AdminCacheFileStore instance = new AdminCacheFileStore();
    private static final Logger LOG = AdminLoggerInfo.getLogger();
    private final AdminCacheUtils adminCacheUtils = AdminCacheUtils.getInstance();

    private AdminCacheFileStore() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A> A get(String key, Class<A> clazz) {
        LOG.log(Level.FINEST, "get(key={0}, clazz={1})", new Object[]{key, clazz});
        if (key == null) throw new IllegalArgumentException("Attribute key must be unempty.");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Attribute clazz can not be null.");
        }
        DataProvider provider = this.adminCacheUtils.getProvider(clazz);
        if (provider == null) {
            return null;
        }
        try (InputStream is = this.getInputStream(key);){
            Object object = provider.toInstance(is, clazz);
            return (A)object;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Cannot read admin cache file for " + key, ex);
            return null;
        }
    }

    private InputStream getInputStream(String key) throws IOException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCacheUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        File f = this.getCacheFile(key);
        return new BufferedInputStream(new FileInputStream(f));
    }

    private File getCacheFile(String key) throws IOException {
        int idx = key.lastIndexOf(47);
        if (idx == 0) {
            return new File(AsadminSecurityUtil.GF_CLIENT_DIR, key);
        }
        File dir = new File(AsadminSecurityUtil.GF_CLIENT_DIR, key.substring(0, idx));
        if (!FileUtils.mkdirsMaybe((File)dir)) {
            throw new IOException("Can't create directory: " + String.valueOf(dir));
        }
        if ((key = key.substring(idx + 1)).isEmpty()) {
            key = DEFAULT_FILENAME;
        }
        return new File(dir, key);
    }

    @Override
    public synchronized void put(String key, Object data) {
        File tempFile;
        File cacheFile;
        LOG.log(Level.FINEST, "put(key={0}, data={1})", new Object[]{key, data});
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCacheUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        if (data == null) {
            throw new IllegalArgumentException("Attribute data can not be null.");
        }
        DataProvider provider = this.adminCacheUtils.getProvider(data.getClass());
        if (provider == null) {
            throw new IllegalStateException("There is no data provider for " + String.valueOf(data.getClass()));
        }
        try {
            cacheFile = this.getCacheFile(key);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Cannot write data to cache file for " + key, e);
            return;
        }
        try {
            tempFile = File.createTempFile("temp", "cache", cacheFile.getParentFile());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Cannot create a temp file for future cache file " + String.valueOf(cacheFile), e);
            return;
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tempFile));){
            provider.writeToStream(data, os);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Cannot write data to temp file " + String.valueOf(tempFile), e);
            return;
        }
        if (!FileUtils.deleteFileMaybe((File)cacheFile) || !tempFile.renameTo(cacheFile)) {
            LOG.log(Level.WARNING, "Cannot delete or rename to cache file " + String.valueOf(cacheFile));
            if (!FileUtils.deleteFileMaybe((File)tempFile)) {
                LOG.log(Level.FINE, "Can't delete file {0}", tempFile);
            }
        }
    }

    @Override
    public boolean contains(String key) {
        File cacheFile;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCacheUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        try {
            cacheFile = this.getCacheFile(key);
        }
        catch (IOException ex) {
            return false;
        }
        return cacheFile.exists() && cacheFile.isFile();
    }

    @Override
    public Date lastUpdated(String key) {
        File cacheFile;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (!this.adminCacheUtils.validateKey(key)) {
            throw new IllegalArgumentException("Attribute key must be in form (([-_.a-zA-Z0-9]+/?)+)");
        }
        try {
            cacheFile = this.getCacheFile(key);
        }
        catch (IOException ex) {
            return null;
        }
        if (!cacheFile.exists() || !cacheFile.isFile()) {
            return null;
        }
        return new Date(cacheFile.lastModified());
    }

    public static AdminCacheFileStore getInstance() {
        return instance;
    }
}

