/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.services.config.AuthenticationService;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.glassfish.security.services.config.SecurityConfigurations;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_create-security-service")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
public class CreateSecurityService
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final String AUTHENTICATION = "authentication";
    @Param(optional=false)
    private String serviceType;
    @Param(defaultValue="false", optional=true)
    private Boolean enableDefault;
    @Param(optional=true, separator=58)
    private Properties configuration;
    @Param(primary=true)
    private String serviceName;
    @Inject
    private Domain domain;
    private Class<? extends SecurityConfiguration> clazzServiceType;
    private ServiceConfigHandler<? extends SecurityConfiguration> serviceConfigHandler;
    @AccessRequired.To(value={"create"})
    private SecurityConfigurations secConfigs;

    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.secConfigs = this.getSecurityConfigurations(report);
        return this.secConfigs != null;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!AUTHENTICATION.equalsIgnoreCase(this.serviceType)) {
            report.setMessage("Invalid security service type specified: " + this.serviceType);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.clazzServiceType = AuthenticationService.class;
        this.serviceConfigHandler = new AuthenticationConfigHandler();
        SecurityConfiguration config = null;
        try {
            config = (SecurityConfiguration)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityConfigurations>(){

                public Object run(SecurityConfigurations param) throws PropertyVetoException, TransactionFailure {
                    SecurityConfiguration svcConfig = (SecurityConfiguration)param.createChild(CreateSecurityService.this.clazzServiceType);
                    svcConfig.setName(CreateSecurityService.this.serviceName);
                    svcConfig.setDefault(CreateSecurityService.this.enableDefault);
                    param.getSecurityServices().add(svcConfig);
                    return svcConfig;
                }
            }, (ConfigBeanProxy)this.secConfigs);
        }
        catch (TransactionFailure transactionFailure) {
            report.setMessage("Unable to create security service: " + transactionFailure.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)transactionFailure);
            return;
        }
        if (config != null && this.configuration != null && !this.configuration.isEmpty()) {
            this.serviceConfigHandler.setupConfiguration(report, config);
        }
    }

    private SecurityConfigurations getSecurityConfigurations(ActionReport report) {
        SecurityConfigurations result = (SecurityConfigurations)this.domain.getExtensionByType(SecurityConfigurations.class);
        if (result == null) {
            try {
                result = (SecurityConfigurations)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                    public Object run(Domain wDomain) throws PropertyVetoException, TransactionFailure {
                        SecurityConfigurations s = (SecurityConfigurations)wDomain.createChild(SecurityConfigurations.class);
                        wDomain.getExtensions().add(s);
                        return s;
                    }
                }, (ConfigBeanProxy)this.domain);
            }
            catch (TransactionFailure transactionFailure) {
                report.setMessage("Unable to create security configurations: " + transactionFailure.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)transactionFailure);
            }
        }
        return result;
    }

    private class AuthenticationConfigHandler
    extends ServiceConfigHandler<AuthenticationService> {
        private AuthenticationConfigHandler() {
        }

        @Override
        public AuthenticationService setupConfiguration(ActionReport report, SecurityConfiguration securityServiceConfig) {
            AuthenticationService config = (AuthenticationService)securityServiceConfig;
            try {
                config = (AuthenticationService)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AuthenticationService>(){

                    public Object run(AuthenticationService param) throws PropertyVetoException, TransactionFailure {
                        Boolean usePassCred = Boolean.valueOf(CreateSecurityService.this.configuration.getProperty("use-password-credential"));
                        param.setUsePasswordCredential(usePassCred);
                        return param;
                    }
                }, (ConfigBeanProxy)config);
            }
            catch (TransactionFailure transactionFailure) {
                report.setMessage("Unable to configure authentication service: " + transactionFailure.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)transactionFailure);
                return null;
            }
            return config;
        }
    }

    private abstract class ServiceConfigHandler<T extends SecurityConfiguration> {
        private ServiceConfigHandler() {
        }

        abstract T setupConfiguration(ActionReport var1, SecurityConfiguration var2);
    }
}

