/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.validate;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.krazo.binding.validate.ConstraintViolationMetadata;

public class ConstraintViolations {
    private static final Logger log = Logger.getLogger(ConstraintViolations.class.getName());

    private ConstraintViolations() {
    }

    public static ConstraintViolationMetadata getMetadata(ConstraintViolation<?> violation) {
        Annotation[] annotations = ConstraintViolations.getAnnotations(violation);
        return new ConstraintViolationMetadata(violation, annotations);
    }

    private static Annotation[] getAnnotations(ConstraintViolation<?> violation) {
        ArrayList<Path.Node> nodes = new ArrayList<Path.Node>();
        for (Path.Node node : violation.getPropertyPath()) {
            nodes.add(node);
        }
        Path.Node lastNode = (Path.Node)nodes.get(nodes.size() - 1);
        if (lastNode.getKind() == ElementKind.PROPERTY) {
            Path.PropertyNode propertyNode = (Path.PropertyNode)lastNode.as(Path.PropertyNode.class);
            return ConstraintViolations.getPropertyAnnotations(violation, propertyNode);
        }
        if (lastNode.getKind() == ElementKind.PARAMETER && nodes.size() == 2) {
            Path.MethodNode methodNode = (Path.MethodNode)((Path.Node)nodes.get(0)).as(Path.MethodNode.class);
            Path.ParameterNode parameterNode = (Path.ParameterNode)((Path.Node)nodes.get(1)).as(Path.ParameterNode.class);
            return ConstraintViolations.getParameterAnnotations(violation, methodNode, parameterNode);
        }
        log.warning("Could not read annotations for path: " + violation.getPropertyPath().toString());
        return new Annotation[0];
    }

    private static Annotation[] getPropertyAnnotations(ConstraintViolation<?> violation, Path.PropertyNode node) {
        Class<?> leafBeanClass = violation.getLeafBean().getClass();
        HashSet<Annotation> allAnnotations = new HashSet<Annotation>();
        try {
            Field field = leafBeanClass.getDeclaredField(node.getName());
            allAnnotations.addAll(Arrays.asList(field.getAnnotations()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        allAnnotations.addAll(ConstraintViolations.readAndWriteMethodAnnotationsForField(leafBeanClass, node.getName()));
        return allAnnotations.toArray(new Annotation[0]);
    }

    private static Annotation[] getParameterAnnotations(ConstraintViolation<?> violation, Path.MethodNode methodNode, Path.ParameterNode parameterNode) {
        try {
            String methodName = methodNode.getName();
            int paramCount = methodNode.getParameterTypes().size();
            Class[] paramTypes = methodNode.getParameterTypes().toArray(new Class[paramCount]);
            Class<?> rootBeanClass = violation.getRootBean().getClass();
            Method method = rootBeanClass.getMethod(methodName, paramTypes);
            int parameterIndex = parameterNode.getParameterIndex();
            return method.getParameterAnnotations()[parameterIndex];
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Set<Annotation> readAndWriteMethodAnnotationsForField(Class<?> beanClass, String fieldName) {
        HashSet<Annotation> annotationsSet = new HashSet<Annotation>();
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            Optional<PropertyDescriptor> descriptorOpt = Arrays.stream(info.getPropertyDescriptors()).filter(desc -> desc.getName().equals(fieldName)).findFirst();
            if (descriptorOpt.isPresent()) {
                Method setter;
                Method getter = descriptorOpt.get().getReadMethod();
                if (getter != null) {
                    annotationsSet.addAll(Arrays.asList(getter.getAnnotations()));
                }
                if ((setter = descriptorOpt.get().getWriteMethod()) != null) {
                    annotationsSet.addAll(Arrays.asList(setter.getAnnotations()));
                }
            }
        }
        catch (IntrospectionException e) {
            log.warning(String.format("Unable to introspect read and write methods for field '%s' on bean class '%s': %s", fieldName, beanClass.getName(), e.getMessage()));
        }
        return annotationsSet;
    }
}

