/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.deployment.web.ServletFilterMapping;
import jakarta.servlet.DispatcherType;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;

public final class ServletFilterMappingDescriptor
extends Descriptor
implements ServletFilterMapping {
    private EnumSet<DispatcherType> dispatchers;
    private List<String> servletNames;
    private List<String> urlPatterns;

    public ServletFilterMappingDescriptor() {
        super("", "");
    }

    public ServletFilterMappingDescriptor(ServletFilterMappingDescriptor other) {
        super((Descriptor)other);
        this.dispatchers = other.dispatchers != null ? EnumSet.copyOf(other.dispatchers) : null;
    }

    public void addServletName(String servletName) {
        this.getServletNames().add(servletName);
    }

    public List<String> getServletNames() {
        if (this.servletNames == null) {
            this.servletNames = new LinkedList<String>();
        }
        return this.servletNames;
    }

    public void addURLPattern(String urlPattern) {
        this.getUrlPatterns().add(urlPattern);
    }

    public List<String> getUrlPatterns() {
        if (this.urlPatterns == null) {
            this.urlPatterns = new LinkedList<String>();
        }
        return this.urlPatterns;
    }

    public void addDispatcher(String dispatcher) {
        if (this.dispatchers == null) {
            this.dispatchers = EnumSet.noneOf(DispatcherType.class);
        }
        this.dispatchers.add(Enum.valueOf(DispatcherType.class, dispatcher));
    }

    public void removeDispatcher(String dispatcher) {
        if (this.dispatchers == null) {
            return;
        }
        this.dispatchers.remove(Enum.valueOf(DispatcherType.class, dispatcher));
    }

    public Set<DispatcherType> getDispatchers() {
        if (this.dispatchers == null) {
            this.dispatchers = EnumSet.noneOf(DispatcherType.class);
        }
        return this.dispatchers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServletFilterMapping) {
            boolean sameDispatchers;
            ServletFilterMapping o = (ServletFilterMapping)obj;
            Set otherDispatchers = o.getDispatchers();
            boolean bl = sameDispatchers = this.dispatchers == null && (otherDispatchers == null || otherDispatchers.size() == 0) || this.dispatchers != null && this.dispatchers.equals(otherDispatchers);
            if (this.getName().equals(o.getName()) && this.getServletNames().equals(o.getServletNames()) && this.getUrlPatterns().equals(o.getUrlPatterns()) && sameDispatchers) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + this.getServletNames().hashCode();
        result = 37 * result + this.getUrlPatterns().hashCode();
        return result;
    }
}

