/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.FieldUpdater;
import org.glassfish.rmic.tools.tree.LocalMember;
import org.glassfish.rmic.tools.tree.Vset;

public class ThisExpression
extends Expression {
    LocalMember field;
    Expression implementation;
    Expression outerArg;

    public ThisExpression(long where) {
        super(82, where, Type.tObject);
    }

    protected ThisExpression(int op, long where) {
        super(op, where, Type.tObject);
    }

    public ThisExpression(long where, LocalMember field) {
        super(82, where, Type.tObject);
        this.field = field;
        ++field.readcount;
    }

    public ThisExpression(long where, Context ctx) {
        super(82, where, Type.tObject);
        this.field = ctx.getLocalField(idThis);
        ++this.field.readcount;
    }

    public ThisExpression(long where, Expression outerArg) {
        this(where);
        this.outerArg = outerArg;
    }

    @Override
    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    public Expression getOuterArg() {
        return this.outerArg;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        if (ctx.field.isStatic()) {
            env.error(this.where, "undef.var", opNames[this.op]);
            this.type = Type.tError;
            return vset;
        }
        if (this.field == null) {
            this.field = ctx.getLocalField(idThis);
            ++this.field.readcount;
        }
        if (this.field.scopeNumber < ctx.frameNumber) {
            this.implementation = ctx.makeReference(env, this.field);
        }
        if (!vset.testVar(this.field.number)) {
            env.error(this.where, "access.inst.before.super", opNames[this.op]);
        }
        this.type = this.field == null ? ctx.field.getClassDeclaration().getType() : this.field.getType();
        return vset;
    }

    @Override
    public boolean isNonNull() {
        return true;
    }

    @Override
    public FieldUpdater getAssigner(Environment env, Context ctx) {
        return null;
    }

    @Override
    public FieldUpdater getUpdater(Environment env, Context ctx) {
        return null;
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        Expression e;
        if (this.implementation != null) {
            return this.implementation.inlineValue(env, ctx);
        }
        if (this.field != null && this.field.isInlineable(env, false) && (e = (Expression)this.field.getValue(env)) != null) {
            e = e.copyInline(ctx);
            e.type = this.type;
            return e;
        }
        return this;
    }

    @Override
    public Expression copyInline(Context ctx) {
        if (this.implementation != null) {
            return this.implementation.copyInline(ctx);
        }
        ThisExpression e = (ThisExpression)this.clone();
        if (this.field == null) {
            e.field = ctx.getLocalField(idThis);
            ++e.field.readcount;
        } else {
            e.field = this.field.getCurrentInlineCopy(ctx);
        }
        if (this.outerArg != null) {
            e.outerArg = this.outerArg.copyInline(ctx);
        }
        return e;
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 25, this.field.number);
    }

    @Override
    public void print(PrintStream out) {
        if (this.outerArg != null) {
            out.print("(outer=");
            this.outerArg.print(out);
            out.print(" ");
        }
        String pfx = this.field == null ? "" : this.field.getClassDefinition().getName().getFlatName().getName() + ".";
        pfx = pfx + opNames[this.op];
        out.print(pfx + "#" + (this.field != null ? this.field.hashCode() : 0));
        if (this.outerArg != null) {
            out.print(")");
        }
    }
}

