/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.EditableList;
import com.sun.webui.jsf.renderkit.html.ListRendererBase;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Map;

public class EditableListRenderer
extends ListRendererBase {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component == null) {
            return;
        }
        if (!(component instanceof EditableList)) {
            String message = "Component " + component.toString() + " has been associated with an EditableListRenderer.  This renderer can only be used by components  that extend com.sun.webui.jsf.component.Selector.";
            throw new FacesException(message);
        }
        this.renderListComponent((EditableList)component, context, EditableListRenderer.getStyles(component, context));
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        String listID;
        if (component == null) {
            return;
        }
        EditableList list = (EditableList)component;
        if (list.isReadOnly()) {
            return;
        }
        String id = list.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        Object parameters = params.get(listID = list instanceof ComplexComponent ? list.getLabeledElementId(context) : list.getClientId(context));
        String[] selections = parameters == null ? new String[]{} : (parameters instanceof String[] ? (String[])parameters : new String[]{parameters.toString()});
        list.setValuesToRemove(selections);
        String valueID = id.concat("_list_value");
        EditableListRenderer.decode(context, component, valueID);
    }

    void renderListComponent(EditableList component, FacesContext context, String[] styles) throws IOException {
        EditableListRenderer.log("renderListComponent()");
        if (component.isReadOnly()) {
            UIComponent label = component.getListLabelComponent();
            EditableListRenderer.renderReadOnlyList(component, label, context, styles[8]);
            return;
        }
        UIComponent headerComponent = component.getFacet("header");
        UIComponent footerComponent = component.getFacet("footer");
        boolean gotHeaderOrFooter = headerComponent != null || footerComponent != null;
        ResponseWriter writer = context.getResponseWriter();
        EditableListRenderer.renderOpenEncloser(component, context, "div", styles[8]);
        if (gotHeaderOrFooter) {
            writer.startElement("table", (UIComponent)component);
            writer.writeText((Object)"\n", null);
            if (headerComponent != null) {
                this.addComponentSingleRow(component, headerComponent, context);
            }
            writer.startElement("tr", (UIComponent)component);
            writer.writeText((Object)"\n", null);
            writer.startElement("td", (UIComponent)component);
            writer.writeText((Object)"\n", null);
        }
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[9], null);
        writer.writeText((Object)"\n", null);
        boolean listOnTop = component.isListOnTop();
        if (listOnTop) {
            this.addListRow(component, context, styles);
            this.addFieldRow(component, context, styles);
        } else {
            this.addFieldRow(component, context, styles);
            this.addListRow(component, context, styles);
        }
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        if (gotHeaderOrFooter) {
            writer.endElement("td");
            writer.writeText((Object)"\n", null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            if (footerComponent != null) {
                this.addComponentSingleRow(component, footerComponent, context);
            }
            writer.endElement("table");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement("div");
        this.renderJavaScript((UIComponent)component, context, writer);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    private void addComponentSingleRow(EditableList list, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", (UIComponent)list);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)list);
        RenderingUtilities.renderComponent(component, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void addListRow(EditableList component, FacesContext context, String[] styles) throws IOException {
        UIComponent listLabelComponent = component.getListLabelComponent();
        UIComponent removeButtonComponent = component.getRemoveButtonComponent();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", (UIComponent)component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[13], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(listLabelComponent, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[14], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        EditableListRenderer.renderHiddenValue((UIComponent)component, context, writer, styles[8]);
        writer.writeText((Object)"\n", null);
        String id = component.getClientId(context).concat("_list");
        EditableListRenderer.renderList(component, id, context, styles);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[15], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(removeButtonComponent, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void addFieldRow(EditableList component, FacesContext context, String[] styles) throws IOException {
        UIComponent textfieldLabelComponent = component.getFieldLabelComponent();
        UIComponent textfieldComponent = component.getFieldComponent();
        UIComponent addButtonComponent = component.getAddButtonComponent();
        UIComponent searchButtonComponent = component.getFacet("search");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", (UIComponent)component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[10], null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(textfieldLabelComponent, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[11], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(textfieldComponent, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[12], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(addButtonComponent, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        if (searchButtonComponent != null) {
            writer.startElement("td", (UIComponent)component);
            writer.writeAttribute("class", (Object)styles[12], null);
            writer.writeAttribute("valign", (Object)"top", null);
            writer.writeText((Object)"\n", null);
            RenderingUtilities.renderComponent(searchButtonComponent, context);
            writer.writeText((Object)"\n", null);
            writer.endElement("td");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderJavaScript(UIComponent component, FacesContext context, ResponseWriter writer) throws IOException {
        JsonObject initProps = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", component.getClientId(context)).build();
        JavaScriptUtilities.renderInitScriptTag(writer, "editableList", initProps, JavaScriptUtilities.renderCall("update_buttons", "editableList", component.getClientId(context)));
    }

    private static String[] getStyles(UIComponent component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[]{JavaScriptUtilities.renderCalls(((EditableList)component).getOnChange(), JavaScriptUtilities.renderCall("changed", "listbox", component.getClientId(context))), theme.getStyleClass("LIST"), theme.getStyleClass("LIST_DISABLED"), theme.getStyleClass("LIST_OPTION"), theme.getStyleClass("LIST_OPTION_DISABLED"), theme.getStyleClass("LIST_OPTION_SELECTED"), theme.getStyleClass("LIST_OPTION_GROUP"), theme.getStyleClass("LIST_OPTION_SEPARATOR"), theme.getStyleClass("HIDDEN"), theme.getStyleClass("EDITABLELIST_TABLE"), theme.getStyleClass("EDITABLELIST_FIELD_LABEL"), theme.getStyleClass("EDITABLELIST_FIELD"), theme.getStyleClass("EDITABLELIST_ADD_BUTTON"), theme.getStyleClass("EDITABLELIST_LIST_LABEL"), theme.getStyleClass("EDITABLELIST_LIST"), theme.getStyleClass("EDITABLELIST_REMOVE_BUTTON"), null};
        return styles;
    }

    private static void log(String msg) {
        LogUtil.finest(EditableListRenderer.class.getName() + "::" + msg);
    }
}

