/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXException;

@Service
@PerLookup
@ArchivistFor(value="ear")
public class ApplicationArchivist
extends Archivist<Application> {
    @Inject
    Provider<ArchivistFactory> archivistFactory;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationArchivist.class);

    public ApplicationArchivist() {
        this.handleRuntimeInfo = true;
    }

    @Override
    public ArchiveType getModuleType() {
        return DOLUtils.earType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void writeContents(ReadableArchive in, WritableArchive out) throws IOException {
        HashSet<String> filesToSkip = new HashSet<String>();
        logger.log(Level.FINE, "writeContents(in={0}, out={1})", new Object[]{in, out});
        Enumeration alreadyWritten = out.entries();
        while (alreadyWritten.hasMoreElements()) {
            String elementName = (String)alreadyWritten.nextElement();
            filesToSkip.add(elementName);
        }
        Iterator<ModuleDescriptor<BundleDescriptor>> iterator = ((Application)this.descriptor).getModules().iterator();
        while (true) {
            String archiveUri;
            block21: {
                if (!iterator.hasNext()) {
                    super.writeContents(in, out, filesToSkip);
                    return;
                }
                ModuleDescriptor<BundleDescriptor> aModule = iterator.next();
                Object subArchivist = ((ArchivistFactory)this.archivistFactory.get()).getArchivist(aModule.getModuleType());
                ((Archivist)subArchivist).initializeContext(this);
                ((Archivist)subArchivist).setModuleDescriptor(aModule);
                archiveUri = aModule.getArchiveUri();
                logger.log(Level.FINE, "Writing {0} with {1}", new Object[]{archiveUri, subArchivist});
                File tmpFile = null;
                try {
                    boolean ok;
                    try (InputStream is = in.getEntry(archiveUri);
                         WritableArchive internalJar = out.createSubArchive(archiveUri);){
                        if (in instanceof WritableArchive) {
                            ((Archivist)subArchivist).setArchiveUri(internalJar.getURI().getSchemeSpecificPart());
                        } else {
                            tmpFile = ApplicationArchivist.getTempFile(this.path);
                            FileUtils.copy((InputStream)is, (File)tmpFile, (long)in.getEntrySize(archiveUri));
                            ((Archivist)subArchivist).setArchiveUri(tmpFile.getAbsolutePath());
                        }
                        ((Archivist)subArchivist).writeContents(internalJar);
                    }
                    if (tmpFile == null || (ok = tmpFile.delete())) break block21;
                }
                catch (Throwable throwable) {
                    boolean ok;
                    if (tmpFile != null && !(ok = tmpFile.delete())) {
                        logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.cantDelete", "Error deleting file {0}", new Object[]{tmpFile}));
                    }
                    throw throwable;
                }
                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.cantDelete", "Error deleting file {0}", new Object[]{tmpFile}));
            }
            filesToSkip.add(archiveUri);
        }
    }

    @Override
    public Application getDefaultBundleDescriptor() {
        return Application.createApplication();
    }

    @Override
    public Application open(ReadableArchive appArchive) throws IOException, SAXException {
        this.setManifest(appArchive.getManifest());
        Application appDesc = (Application)this.readStandardDeploymentDescriptor(appArchive);
        return this.openWith(appDesc, appArchive);
    }

    @Override
    public Application openWith(Application application, ReadableArchive archive) throws IOException, SAXException {
        this.setManifest(archive.getManifest());
        this.setDescriptor(application);
        HashMap<ExtensionsArchivist, RootDeploymentDescriptor> extensions = new HashMap<ExtensionsArchivist, RootDeploymentDescriptor>();
        if (this.extensionsArchivists != null) {
            for (ExtensionsArchivist extension : this.extensionsArchivists) {
                RootDeploymentDescriptor o;
                if (!extension.supportsModuleType(this.getModuleType()) || !((o = extension.open(this, archive, this.descriptor)) instanceof RootDeploymentDescriptor)) continue;
                if (o != this.descriptor) {
                    extension.addExtension(this.descriptor, o);
                }
                extensions.put(extension, o);
            }
        }
        boolean origHandleRuntimeInfo = this.handleRuntimeInfo;
        this.handleRuntimeInfo = false;
        if (!this.readModulesDescriptors(application, archive)) {
            return null;
        }
        this.handleRuntimeInfo = origHandleRuntimeInfo;
        if (this.handleRuntimeInfo) {
            this.readRuntimeDeploymentDescriptor(archive, application);
            for (Map.Entry extension : extensions.entrySet()) {
                if (extension.getValue() == null) continue;
                ((ExtensionsArchivist)extension.getKey()).readRuntimeDeploymentDescriptor(this, archive, (RootDeploymentDescriptor)extension.getValue());
            }
            if (this.classLoader != null) {
                this.validate(null);
            }
        }
        return application;
    }

    public Application createApplication(ReadableArchive archive, boolean directory) throws IOException, SAXException {
        if (this.hasStandardDeploymentDescriptor(archive)) {
            return (Application)this.readStandardDeploymentDescriptor(archive);
        }
        return this.getApplicationFromIntrospection(archive, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Application getApplicationFromIntrospection(ReadableArchive archive, boolean directory) {
        File[] files;
        String appRoot = archive.getURI().getSchemeSpecificPart();
        if (appRoot.endsWith(File.separator)) {
            appRoot = appRoot.substring(0, appRoot.length() - 1);
        }
        Application app = Application.createApplication();
        app.setLoadedFromApplicationXml(false);
        app.setVirtual(false);
        String appName = appRoot.substring(appRoot.lastIndexOf(File.separatorChar) + 1);
        app.setName(appName);
        ArrayList<ReadableArchive> unknowns = new ArrayList<ReadableArchive>();
        for (File subModule : files = ApplicationArchivist.getEligibleEntries(new File(appRoot), directory)) {
            ReadableArchive subArchive;
            block26: {
                block29: {
                    block28: {
                        String uri;
                        block27: {
                            ModuleDescriptor md;
                            subArchive = null;
                            try {
                                subArchive = this.archiveFactory.openArchive(subModule);
                            }
                            catch (IOException ex) {
                                logger.log(Level.WARNING, ex.getMessage());
                            }
                            String name = subModule.getName();
                            uri = ApplicationArchivist.deriveArchiveUri(appRoot, subModule, directory);
                            if (!directory && name.endsWith(".war") || directory && (name.endsWith("_war") || name.endsWith(".war"))) {
                                md = new ModuleDescriptor();
                                md.setArchiveUri(uri);
                                md.setModuleType(DOLUtils.warType());
                                app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                                break block26;
                            }
                            if (!directory && name.endsWith(".rar") || directory && (name.endsWith("_rar") || name.endsWith(".rar"))) {
                                md = new ModuleDescriptor();
                                md.setArchiveUri(uri);
                                md.setModuleType(DOLUtils.rarType());
                                app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                                break block26;
                            }
                            if ((directory || !name.endsWith(".jar")) && (!directory || !name.endsWith("_jar") && !name.endsWith(".jar"))) break block26;
                            AppClientArchivist acArchivist = new AppClientArchivist();
                            if (!acArchivist.hasStandardDeploymentDescriptor(subArchive) && !acArchivist.hasRuntimeDeploymentDescriptor(subArchive) && acArchivist.getMainClassName(subArchive.getManifest()) == null) break block27;
                            ModuleDescriptor md2 = new ModuleDescriptor();
                            md2.setArchiveUri(uri);
                            md2.setModuleType(DOLUtils.carType());
                            md2.setManifest(subArchive.getManifest());
                            app.addModule((ModuleDescriptor<BundleDescriptor>)md2);
                            if (subArchive == null) continue;
                            try {
                                subArchive.close();
                            }
                            catch (IOException ioe) {
                                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                            }
                            continue;
                        }
                        Object ejbArchivist = ((ArchivistFactory)this.archivistFactory.get()).getArchivist(DOLUtils.ejbType());
                        if (!((Archivist)ejbArchivist).hasStandardDeploymentDescriptor(subArchive) && !((Archivist)ejbArchivist).hasRuntimeDeploymentDescriptor(subArchive)) break block28;
                        ModuleDescriptor md = new ModuleDescriptor();
                        md.setArchiveUri(uri);
                        md.setModuleType(DOLUtils.ejbType());
                        app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                        if (subArchive == null) continue;
                        try {
                            subArchive.close();
                        }
                        catch (IOException ioe) {
                            logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                        }
                        continue;
                    }
                    break block29;
                    {
                        catch (IOException ex) {
                            logger.log(Level.WARNING, ex.getMessage());
                        }
                    }
                }
                unknowns.add(subArchive);
                subArchive = null;
            }
            if (subArchive == null) continue;
            try {
                subArchive.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
            }
            continue;
            catch (Throwable throwable) {
                if (subArchive != null) {
                    try {
                        subArchive.close();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                    }
                }
                throw throwable;
            }
        }
        if (unknowns.size() > 0) {
            AnnotationDetector detector = new AnnotationDetector(new EjbComponentAnnotationScanner());
            for (ReadableArchive unknown : unknowns) {
                File jarFile = new File(unknown.getURI().getSchemeSpecificPart());
                try {
                    if (detector.hasAnnotationInArchive(unknown)) {
                        String uri = ApplicationArchivist.deriveArchiveUri(appRoot, jarFile, directory);
                        ModuleDescriptor md = new ModuleDescriptor();
                        md.setArchiveUri(uri);
                        md.setModuleType(DOLUtils.ejbType());
                        app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                    }
                    unknown.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.getMessage());
                }
            }
        }
        return app;
    }

    private static String deriveArchiveUri(String appRoot, File subModule, boolean deploydir) {
        if (deploydir) {
            return FileUtils.revertFriendlyFilename((String)subModule.getName());
        }
        String aRoot = null;
        try {
            aRoot = new File(appRoot).getCanonicalPath();
        }
        catch (IOException ex) {
            aRoot = appRoot;
        }
        String uri = null;
        try {
            uri = subModule.getCanonicalPath().substring(aRoot.length() + 1);
        }
        catch (IOException ex) {
            uri = subModule.getAbsolutePath().substring(aRoot.length() + 1);
        }
        return uri.replace(File.separatorChar, '/');
    }

    private static File[] getEligibleEntries(File appRoot, boolean deploydir) {
        if (deploydir) {
            return appRoot.listFiles(new DirectoryIntrospectionFilter());
        }
        Vector<File> files = new Vector<File>();
        ApplicationArchivist.getListOfFiles(appRoot, files, new ArchiveIntrospectionFilter(appRoot.getAbsolutePath()));
        return files.toArray(new File[files.size()]);
    }

    private static void getListOfFiles(File directory, Vector<File> files, FilenameFilter filter) {
        File[] list = directory.listFiles(filter);
        if (list == null) {
            return;
        }
        for (File element : list) {
            if (!element.isDirectory()) {
                files.add(element);
                continue;
            }
            ApplicationArchivist.getListOfFiles(element, files, filter);
        }
    }

    public <T extends BundleDescriptor> boolean readModulesDescriptors(Application app, ReadableArchive appArchive) throws IOException, SAXException {
        ArrayList nonexistentModules = new ArrayList();
        List<ModuleDescriptor<BundleDescriptor>> sortedModules = this.sortModules(app);
        for (ModuleDescriptor<BundleDescriptor> aModule : sortedModules) {
            BundleDescriptor bundleDescriptor;
            Object newArchivist;
            block24: {
                if (aModule.getArchiveUri().contains(" ")) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.unsupporturi", "Unsupported module URI {0}, it contains space(s)", new Object[]{aModule.getArchiveUri()}));
                }
                DOLUtils.getDefaultLogger().log(Level.FINE, "Opening sub-module {0}", aModule);
                newArchivist = ((ArchivistFactory)this.archivistFactory.get()).getArchivist(aModule.getModuleType());
                ((Archivist)newArchivist).initializeContext(this);
                ((Archivist)newArchivist).setRuntimeXMLValidation(this.getRuntimeXMLValidation());
                ((Archivist)newArchivist).setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
                ((Archivist)newArchivist).setAnnotationProcessingRequested(this.annotationProcessingRequested);
                bundleDescriptor = null;
                try (ReadableArchive embeddedArchive = appArchive.getSubArchive(aModule.getArchiveUri());){
                    if (embeddedArchive == null) {
                        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.nosuchmodule", "Could not find sub module [{0}] as defined in application.xml", new Object[]{aModule.getArchiveUri()}));
                    }
                    embeddedArchive.setParentArchive(appArchive);
                    DOLUtils.setExtensionArchivistForSubArchivist(this.habitat, embeddedArchive, aModule, app, newArchivist);
                    if (aModule.getAlternateDescriptor() == null) {
                        bundleDescriptor = (BundleDescriptor)((Archivist)newArchivist).open(embeddedArchive, app);
                        break block24;
                    }
                    try (InputStream is = appArchive.getEntry(aModule.getAlternateDescriptor());){
                        DeploymentDescriptorFile ddFile = ((Archivist)newArchivist).getStandardDDFile();
                        ddFile.setXMLValidation(((Archivist)newArchivist).getXMLValidation());
                        ddFile.setXMLValidationLevel(((Archivist)newArchivist).getXMLValidationLevel());
                        if (appArchive.getURI() != null) {
                            ddFile.setErrorReportingString(appArchive.getURI().getSchemeSpecificPart());
                        }
                        bundleDescriptor = (BundleDescriptor)ddFile.read(is);
                        bundleDescriptor.setApplication(app);
                    }
                    HashMap extensions = new HashMap();
                    List<ExtensionsArchivist<?>> extensionsArchivists = ((Archivist)newArchivist).getExtensionArchivists();
                    if (extensionsArchivists != null) {
                        for (ExtensionsArchivist<?> extensionsArchivist : extensionsArchivists) {
                            RootDeploymentDescriptor rdd = extensionsArchivist.open((Archivist<?>)newArchivist, embeddedArchive, bundleDescriptor);
                            extensions.put(extensionsArchivist, rdd);
                        }
                    }
                    ((Archivist)newArchivist).postStandardDDsRead((BundleDescriptor)bundleDescriptor, embeddedArchive, extensions);
                    ((Archivist)newArchivist).readAnnotations(embeddedArchive, (BundleDescriptor)bundleDescriptor, extensions);
                    ((Archivist)newArchivist).postAnnotationProcess((BundleDescriptor)bundleDescriptor, embeddedArchive);
                    ((Archivist)newArchivist).postOpen((BundleDescriptor)bundleDescriptor, embeddedArchive);
                    if (this.isHandlingRuntimeInfo()) {
                        DOLUtils.readAlternativeRuntimeDescriptor(appArchive, embeddedArchive, newArchivist, bundleDescriptor, aModule.getAlternateDescriptor());
                        for (Map.Entry entry : extensions.entrySet()) {
                            if (entry.getValue() == null) continue;
                            ((ExtensionsArchivist)entry.getKey()).readRuntimeDeploymentDescriptor((Archivist)newArchivist, embeddedArchive, (RootDeploymentDescriptor)entry.getValue());
                        }
                    }
                }
            }
            if (bundleDescriptor == null) {
                return false;
            }
            bundleDescriptor.getModuleDescriptor().setArchiveUri(aModule.getArchiveUri());
            aModule.setModuleName(bundleDescriptor.getModuleDescriptor().getModuleName());
            aModule.setDescriptor(bundleDescriptor);
            bundleDescriptor.setApplication(app);
            aModule.setManifest(((Archivist)newArchivist).getManifest());
            if (appArchive.exists("META-INF/application.xml") || !aModule.getModuleType().equals((Object)DOLUtils.warType())) continue;
            WebBundleDescriptor wbd = (WebBundleDescriptor)bundleDescriptor;
            if (wbd.getContextRoot() != null && !wbd.getContextRoot().isEmpty()) {
                aModule.setContextRoot(wbd.getContextRoot());
                continue;
            }
            aModule.setContextRoot(aModule.getModuleName());
        }
        for (ModuleDescriptor nonexistentModule : nonexistentModules) {
            app.removeModule((ModuleDescriptor<BundleDescriptor>)nonexistentModule);
        }
        return true;
    }

    private List<ModuleDescriptor<BundleDescriptor>> sortModules(Application app) {
        ArrayList<ModuleDescriptor<BundleDescriptor>> sortedModules = new ArrayList<ModuleDescriptor<BundleDescriptor>>();
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.rarType()));
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.ejbType()));
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.warType()));
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.carType()));
        return sortedModules;
    }

    @Override
    public void readRuntimeDeploymentDescriptor(ReadableArchive archive, Application descriptor) throws IOException, SAXException {
        if (descriptor != null) {
            for (ModuleDescriptor<BundleDescriptor> md : descriptor.getModules()) {
                Object archivist = ((ArchivistFactory)this.archivistFactory.get()).getArchivist(md.getModuleType());
                ((Archivist)archivist).initializeContext(this);
                ((Archivist)archivist).setRuntimeXMLValidation(this.getRuntimeXMLValidation());
                ((Archivist)archivist).setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
                try (ReadableArchive subArchive = archive.getSubArchive(md.getArchiveUri());){
                    if (md.getAlternateDescriptor() == null) {
                        ((Archivist)archivist).readRuntimeDeploymentDescriptor(subArchive, (BundleDescriptor)((BundleDescriptor)md.getDescriptor()));
                        continue;
                    }
                    DOLUtils.readAlternativeRuntimeDescriptor(archive, subArchive, archivist, (BundleDescriptor)md.getDescriptor(), md.getAlternateDescriptor());
                }
            }
        }
        super.readRuntimeDeploymentDescriptor(archive, descriptor);
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((Application)this.descriptor).setClassLoader(cl);
        ((Application)this.descriptor).visit(new ApplicationValidator());
    }

    @Override
    public DeploymentDescriptorFile getStandardDDFile() {
        if (this.standardDD == null) {
            this.standardDD = new ApplicationDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    @Override
    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles() {
        if (this.confDDFiles == null) {
            this.confDDFiles = DOLUtils.getConfigurationDeploymentDescriptorFiles(this.habitat, "ear");
        }
        return this.confDDFiles;
    }

    @Override
    public boolean performOptionalPkgDependenciesCheck(ReadableArchive archive) throws IOException {
        if (!super.performOptionalPkgDependenciesCheck(archive)) {
            return false;
        }
        if (this.descriptor == null) {
            throw new IOException("Application object not set on archivist");
        }
        boolean returnValue = true;
        for (ModuleDescriptor<BundleDescriptor> md : ((Application)this.descriptor).getModules()) {
            ReadableArchive sub = archive.getSubArchive(md.getArchiveUri());
            try {
                Object subArchivist;
                if (sub == null || ((Archivist)(subArchivist = ((ArchivistFactory)this.archivistFactory.get()).getArchivist(md.getModuleType()))).performOptionalPkgDependenciesCheck(sub)) continue;
                returnValue = false;
            }
            finally {
                if (sub == null) continue;
                sub.close();
            }
        }
        return returnValue;
    }

    @Override
    public void copyInto(ReadableArchive source, WritableArchive target) throws IOException {
        try {
            Application a = (Application)this.readStandardDeploymentDescriptor(source);
            this.copyInto(a, source, target);
        }
        catch (SAXException spe) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.fileCopyFailure", spe);
        }
    }

    public void copyInto(Application a, ReadableArchive source, WritableArchive target) throws IOException {
        this.copyInto(a, source, target, true);
    }

    public void copyInto(Application a, ReadableArchive source, WritableArchive target, boolean overwriteManifest) throws IOException {
        HashSet<String> entriesToSkip = new HashSet<String>();
        for (ModuleDescriptor<BundleDescriptor> aModule : a.getModules()) {
            entriesToSkip.add(aModule.getArchiveUri());
            ReadableArchive subSource = source.getSubArchive(aModule.getArchiveUri());
            try {
                WritableArchive subTarget = target.createSubArchive(aModule.getArchiveUri());
                try {
                    Object newArchivist = ((ArchivistFactory)this.archivistFactory.get()).getArchivist(aModule.getModuleType());
                    ReadableArchive subArchive = this.archiveFactory.openArchive(subTarget.getURI());
                    try {
                        String parentPath;
                        subSource.setParentArchive(subArchive);
                        ((Archivist)newArchivist).copyInto(subSource, subTarget, overwriteManifest);
                        String subModulePath = subSource.getURI().getSchemeSpecificPart();
                        if (!subModulePath.startsWith(parentPath = source.getURI().getSchemeSpecificPart())) continue;
                        subModulePath = subModulePath.substring(parentPath.length() + File.separator.length());
                        Enumeration subEntries = subSource.entries();
                        while (subEntries.hasMoreElements()) {
                            String anEntry = (String)subEntries.nextElement();
                            entriesToSkip.add(subModulePath + "/" + anEntry);
                        }
                    }
                    finally {
                        if (subArchive == null) continue;
                        subArchive.close();
                    }
                }
                finally {
                    if (subTarget == null) continue;
                    subTarget.close();
                }
            }
            finally {
                if (subSource == null) continue;
                subSource.close();
            }
        }
        super.copyInto(source, target, entriesToSkip, overwriteManifest);
    }

    @Override
    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        if (!(abstractArchive instanceof FileArchive)) {
            return false;
        }
        File file = new File(abstractArchive.getURI());
        if (file.isDirectory()) {
            for (String dirName : abstractArchive.getDirectories()) {
                if (!ApplicationArchivist.resemblesTopLevelSubmodule(dirName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getArchiveExtension() {
        return ".ear";
    }

    private static boolean resemblesTopLevelSubmodule(String entryName) {
        return entryName.endsWith("_war") || entryName.endsWith("_jar") || entryName.endsWith("_rar") || entryName.endsWith(".war") || entryName.endsWith(".jar") || entryName.endsWith(".rar");
    }

    private static class DirectoryIntrospectionFilter
    implements FilenameFilter {
        DirectoryIntrospectionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (!currentFile.isDirectory()) {
                return false;
            }
            return ApplicationArchivist.resemblesTopLevelSubmodule(name);
        }
    }

    private static class ArchiveIntrospectionFilter
    implements FilenameFilter {
        private final String libDir;
        private final FileArchive.StaleFileManager sfm;

        ArchiveIntrospectionFilter(String root) {
            try {
                this.sfm = FileArchive.StaleFileManager.Util.getInstance((File)new File(root));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.libDir = root + File.separator + "lib" + File.separator;
        }

        @Override
        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (currentFile.isDirectory()) {
                return this.sfm.isEntryValid(currentFile, true);
            }
            if (name.endsWith(".war") || name.endsWith(".rar")) {
                return this.sfm.isEntryValid(currentFile, true);
            }
            String path = currentFile.getAbsolutePath();
            if (!path.startsWith(this.libDir) && path.endsWith(".jar")) {
                return this.sfm.isEntryValid(currentFile, true);
            }
            return false;
        }
    }
}

