/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.recovery;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.security.PasswordCredential;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.security.common.UserNameAndPassword;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
public class JdbcRecoveryResourceHandler
implements RecoveryResourceHandler {
    @Inject
    ServiceLocator habitat;
    private TransactionService txService;
    @Inject
    private Domain domain;
    @Inject
    private Applications applications;
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    private ResourcesUtil resourcesUtil = null;
    private static Logger _logger = LogDomains.getLogger(JdbcRecoveryResourceHandler.class, (String)"jakarta.enterprise.resource.resourceadapter");

    private void loadAllJdbcResources() {
        block7: {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "loadAllJdbcResources start");
            }
            try {
                Collection<JdbcResource> jdbcResources = this.getAllJdbcResources();
                InitialContext ic = new InitialContext();
                for (Resource resource : jdbcResources) {
                    JdbcResource jdbcResource = (JdbcResource)resource;
                    if (!this.getResourcesUtil().isEnabled((BindableResource)jdbcResource)) continue;
                    try {
                        ic.lookup(jdbcResource.getJndiName());
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "error.loading.jdbc.resources.during.recovery", jdbcResource.getJndiName());
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "error.loading.jdbc.resources.during.recovery", ne.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block7;
                _logger.log(Level.FINE, ne.toString(), ne);
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "loadAllJdbcResources end");
        }
    }

    private Collection<JdbcResource> getAllJdbcResources() {
        ArrayList<JdbcResource> allResources = new ArrayList<JdbcResource>();
        Collection jdbcResources = this.domain.getResources().getResources(JdbcResource.class);
        allResources.addAll(jdbcResources);
        for (Application app : this.applications.getApplications()) {
            List modules;
            if (!ResourcesUtil.createInstance().isEnabled(app)) continue;
            Resources appScopedResources = app.getResources();
            if (appScopedResources != null && appScopedResources.getResources() != null) {
                allResources.addAll(appScopedResources.getResources(JdbcResource.class));
            }
            if ((modules = app.getModule()) == null) continue;
            for (Module module : modules) {
                Resources msr = module.getResources();
                if (msr == null || msr.getResources() == null) continue;
                allResources.addAll(msr.getResources(JdbcResource.class));
            }
        }
        return allResources;
    }

    private ResourcesUtil getResourcesUtil() {
        if (this.resourcesUtil == null) {
            this.resourcesUtil = ResourcesUtil.createInstance();
        }
        return this.resourcesUtil;
    }

    public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
        ConnectorRuntime crt = (ConnectorRuntime)this.connectorRuntimeProvider.get();
        Collection<JdbcResource> jdbcResources = this.getAllJdbcResources();
        if (jdbcResources == null || jdbcResources.size() == 0) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("loadXAResourcesAndItsConnections : no resources");
            }
            return;
        }
        ArrayList<JdbcConnectionPool> jdbcPools = new ArrayList<JdbcConnectionPool>();
        for (Resource resource : jdbcResources) {
            JdbcResource jdbcResource = (JdbcResource)resource;
            if (!this.getResourcesUtil().isEnabled((BindableResource)jdbcResource)) continue;
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)jdbcResource);
            JdbcConnectionPool pool = JdbcResourcesUtil.createInstance().getJdbcConnectionPoolOfResource(resourceInfo);
            if (pool != null && "javax.sql.XADataSource".equals(pool.getResType())) {
                jdbcPools.add(pool);
            }
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JdbcRecoveryResourceHandler:: loadXAResourcesAndItsConnections :: adding : " + jdbcResource.getPoolName());
        }
        this.loadAllJdbcResources();
        Properties XAResourceWrappers = new Properties();
        XAResourceWrappers.put("oracle.jdbc.xa.client.OracleXADataSource", "com.sun.enterprise.transaction.jts.recovery.OracleXAResource");
        Config config = (Config)this.habitat.getService(Config.class, "default-instance-name", new Annotation[0]);
        this.txService = (TransactionService)config.getExtensionByType(TransactionService.class);
        List properties = this.txService.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                String name = property.getName();
                String value = property.getValue();
                if (name.equals("oracle-xa-recovery-workaround")) {
                    if (!"false".equals(value)) continue;
                    XAResourceWrappers.remove("oracle.jdbc.xa.client.OracleXADataSource");
                    continue;
                }
                if (!name.equals("sybase-xa-recovery-workaround") || !value.equals("true")) continue;
                XAResourceWrappers.put("com.sybase.jdbc2.jdbc.SybXADataSource", "com.sun.enterprise.transaction.jts.recovery.SybaseXAResource");
            }
        }
        for (JdbcConnectionPool jdbcConnectionPool : jdbcPools) {
            if (jdbcConnectionPool.getResType() == null || jdbcConnectionPool.getName() == null || !jdbcConnectionPool.getResType().equals("javax.sql.XADataSource")) {
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.finest("skipping pool : " + jdbcConnectionPool.getName());
                continue;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(" using pool : " + jdbcConnectionPool.getName());
            }
            PoolInfo poolInfo = ResourceUtil.getPoolInfo((ResourcePool)jdbcConnectionPool);
            try {
                String[] dbUserPassword = this.getdbUserPasswordOfJdbcConnectionPool(jdbcConnectionPool);
                String dbUser = dbUserPassword[0];
                String dbPassword = dbUserPassword[1];
                if (dbPassword == null) {
                    dbPassword = "";
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "datasource.xadatasource_nullpassword_error", poolInfo);
                    }
                }
                if (dbUser == null) {
                    dbUser = "";
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "datasource.xadatasource_nulluser_error", poolInfo);
                    }
                }
                ManagedConnectionFactory fac = crt.obtainManagedConnectionFactory(poolInfo);
                Subject subject = new Subject();
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(fac);
                UserNameAndPassword prin = new UserNameAndPassword(dbUser, dbPassword);
                subject.getPrincipals().add((Principal)prin);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = fac.createManagedConnection(subject, null);
                connList.add(mc);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    String datasourceClassname = jdbcConnectionPool.getDatasourceClassname();
                    String wrapperclass = (String)XAResourceWrappers.get(datasourceClassname);
                    if (wrapperclass != null) {
                        XAResourceWrapper xaresWrapper = null;
                        xaresWrapper = (XAResourceWrapper)crt.getConnectorClassLoader().loadClass(wrapperclass).newInstance();
                        xaresWrapper.init(mc, subject);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("adding resource " + poolInfo + " -- " + xaresWrapper);
                        }
                        xaresList.add(xaresWrapper);
                        continue;
                    }
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("adding resource " + poolInfo + " -- " + xares);
                    }
                    xaresList.add(xares);
                }
                catch (ResourceException ex) {
                    _logger.log(Level.WARNING, "datasource.xadatasource_error", poolInfo);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "datasource.xadatasource_error", poolInfo);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
            }
        }
    }

    public void closeConnections(List connList) {
        for (Object obj : connList) {
            try {
                ManagedConnection con = (ManagedConnection)obj;
                con.destroy();
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "recovery.jdbc-resource.destroy-error", ex);
            }
        }
    }

    public String[] getdbUserPasswordOfJdbcConnectionPool(JdbcConnectionPool jdbcConnectionPool) {
        String[] userPassword = new String[]{null, null};
        List properties = jdbcConnectionPool.getProperty();
        if (properties != null && properties.size() > 0) {
            for (Property property : properties) {
                String prop = property.getName().toUpperCase(Locale.getDefault());
                if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                    userPassword[0] = property.getValue();
                    continue;
                }
                if (!"PASSWORD".equals(prop)) continue;
                userPassword[1] = property.getValue();
            }
        } else {
            return userPassword;
        }
        return userPassword;
    }
}

