/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.embedded;

import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.hk2.api.ServiceLocator;

class AutoDisposableGlassFish
extends GlassFishImpl {
    private static final System.Logger LOG = System.getLogger(AutoDisposableGlassFish.class.getName());
    private final File instanceRoot;
    private final boolean autoDelete;
    private final Consumer<GlassFish> onDisposeAction;

    AutoDisposableGlassFish(ModuleStartup gfKernel, ServiceLocator serviceLocator, GlassFishProperties gfProps, Consumer<GlassFish> onDispose) throws GlassFishException {
        super(gfKernel, serviceLocator, gfProps.getProperties());
        this.instanceRoot = new File(gfProps.getInstanceRoot());
        this.autoDelete = Boolean.parseBoolean(gfProps.getProperties().getProperty("org.glassfish.embeddable.autoDelete"));
        this.onDisposeAction = onDispose;
    }

    @Override
    public void dispose() throws GlassFishException {
        try {
            super.dispose();
        }
        finally {
            if (this.autoDelete && this.instanceRoot != null && this.instanceRoot.exists()) {
                AutoDisposableGlassFish.deleteRecursive(this.instanceRoot);
            }
            this.onDisposeAction.accept(this);
        }
    }

    private static boolean deleteRecursive(File dir) {
        try (Stream<Path> paths = Files.walk(dir.toPath(), new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(AutoDisposableGlassFish::delete);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.ERROR, "Could not delete: " + dir, (Throwable)e);
        }
        return Files.exists(dir.toPath(), new LinkOption[0]);
    }

    private static void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.ERROR, "Could not delete: " + path, (Throwable)e);
        }
    }
}

