/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.glassfish.rmic.IndentingWriter;
import org.glassfish.rmic.Main;
import org.glassfish.rmic.iiop.ArrayType;
import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.ClassType;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.Generator;
import org.glassfish.rmic.iiop.ImplementationType;
import org.glassfish.rmic.iiop.InterfaceType;
import org.glassfish.rmic.iiop.RemoteType;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.iiop.Util;
import org.glassfish.rmic.iiop.ValueType;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Identifier;

public class IDLGenerator
extends Generator {
    private boolean valueMethods = true;
    private boolean factory = true;
    private Hashtable<String, String> ifHash = new Hashtable();
    private Hashtable<String, String> imHash = new Hashtable();
    private final boolean isThrown = true;
    private final boolean isException = true;
    private final boolean isForward = true;
    private final boolean forValuetype = true;

    @Override
    protected File getOutputDirectory(File destinationDir, Identifier id, BatchEnvironment environment) {
        return Util.getOutputDirectoryForIDL(id, destinationDir, environment);
    }

    @Override
    protected boolean requireNewInstance() {
        return false;
    }

    @Override
    protected boolean parseNonConforming(ContextStack stack) {
        return this.valueMethods;
    }

    @Override
    protected CompoundType getTopType(ClassDefinition cdef, ContextStack stack) {
        return CompoundType.forCompound(cdef, stack);
    }

    @Override
    protected Identifier getOutputId(Generator.OutputType ot) {
        Identifier id = super.getOutputId(ot);
        Type t = ot.getType();
        String fName = ot.getName();
        if (id == idJavaLangClass) {
            if (t.isArray()) {
                return Identifier.lookup("org.omg.boxedRMI.javax.rmi.CORBA." + fName);
            }
            return idClassDesc;
        }
        if (id == idJavaLangString && t.isArray()) {
            return Identifier.lookup("org.omg.boxedRMI.CORBA." + fName);
        }
        if ("org.omg.CORBA.Object".equals(t.getQualifiedName()) && t.isArray()) {
            return Identifier.lookup("org.omg.boxedRMI." + fName);
        }
        if (t.isArray()) {
            ArrayType at = (ArrayType)t;
            Type et = at.getElementType();
            if (et.isCompound()) {
                CompoundType ct = (CompoundType)et;
                String qName = ct.getQualifiedName();
                if (ct.isIDLEntity()) {
                    return Identifier.lookup(this.getQualifiedName(at));
                }
            }
            return Identifier.lookup(idBoxedRMI, id);
        }
        if (t.isCompound()) {
            CompoundType ct = (CompoundType)t;
            String qName = ct.getQualifiedName();
            if (ct.isBoxed()) {
                return Identifier.lookup(this.getQualifiedName(ct));
            }
        }
        return id;
    }

    @Override
    protected String getFileNameExtensionFor(Generator.OutputType outputType) {
        return ".idl";
    }

    @Override
    public boolean parseArgs(String[] argv, Main main) {
        boolean result = super.parseArgs(argv, main);
        if (result) {
            for (int i = 0; i < argv.length; ++i) {
                String idlTo;
                String idlFrom;
                if (argv[i] == null) continue;
                if (argv[i].equalsIgnoreCase("-idl")) {
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-valueMethods")) {
                    this.valueMethods = true;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-noValueMethods")) {
                    this.valueMethods = false;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-init")) {
                    this.factory = false;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-factory")) {
                    this.factory = true;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-idlfile")) {
                    argv[i] = null;
                    if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                        idlFrom = argv[i];
                        argv[i] = null;
                        if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                            idlTo = argv[i];
                            argv[i] = null;
                            this.ifHash.put(idlFrom, idlTo);
                            continue;
                        }
                    }
                    main.error("rmic.option.requires.argument", "-idlfile");
                    result = false;
                    continue;
                }
                if (!argv[i].equalsIgnoreCase("-idlmodule")) continue;
                argv[i] = null;
                if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                    idlFrom = argv[i];
                    argv[i] = null;
                    if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                        idlTo = argv[i];
                        argv[i] = null;
                        this.imHash.put(idlFrom, idlTo);
                        continue;
                    }
                }
                main.error("rmic.option.requires.argument", "-idlmodule");
                result = false;
            }
        }
        return result;
    }

    @Override
    protected Generator.OutputType[] getOutputTypesFor(CompoundType topType, HashSet<Type> alreadyChecked) {
        Vector<Type> refVec = this.getAllReferencesFor(topType);
        Vector<Generator.OutputType> outVec = new Vector<Generator.OutputType>();
        for (int i1 = 0; i1 < refVec.size(); ++i1) {
            ClassType ct;
            Type t = refVec.elementAt(i1);
            if (t.isArray()) {
                ArrayType at = (ArrayType)t;
                int dim = at.getArrayDimension();
                Type et = at.getElementType();
                String fName = this.unEsc(et.getIDLName()).replace(' ', '_');
                for (int i2 = 0; i2 < dim; ++i2) {
                    String fileName = "seq" + (i2 + 1) + "_" + fName;
                    outVec.addElement(new Generator.OutputType(fileName, at));
                }
                continue;
            }
            if (!t.isCompound()) continue;
            String fName = this.unEsc(t.getIDLName());
            outVec.addElement(new Generator.OutputType(fName.replace(' ', '_'), t));
            if (!t.isClass() || !(ct = (ClassType)t).isException()) continue;
            fName = this.unEsc(ct.getIDLExceptionName());
            outVec.addElement(new Generator.OutputType(fName.replace(' ', '_'), t));
        }
        Object[] outArr = new Generator.OutputType[outVec.size()];
        outVec.copyInto(outArr);
        return outArr;
    }

    protected Vector<Type> getAllReferencesFor(CompoundType ct) {
        CompoundType t;
        int refSize;
        Hashtable<String, CompoundType> refHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> spcHash = new Hashtable<String, CompoundType>();
        Hashtable<String, ArrayType> arrHash = new Hashtable<String, ArrayType>();
        refHash.put(ct.getQualifiedName(), ct);
        this.accumulateReferences(refHash, spcHash, arrHash);
        do {
            refSize = refHash.size();
            this.accumulateReferences(refHash, spcHash, arrHash);
        } while (refSize < refHash.size());
        Vector<Type> outVec = new Vector<Type>();
        Enumeration<CompoundType> compundElements = refHash.elements();
        while (compundElements.hasMoreElements()) {
            t = compundElements.nextElement();
            outVec.addElement(t);
        }
        compundElements = spcHash.elements();
        while (compundElements.hasMoreElements()) {
            t = compundElements.nextElement();
            outVec.addElement(t);
        }
        Enumeration<ArrayType> arrElements = arrHash.elements();
        block3: while (arrElements.hasMoreElements()) {
            ArrayType at = arrElements.nextElement();
            int dim = at.getArrayDimension();
            Type et = at.getElementType();
            Enumeration<ArrayType> e2 = arrHash.elements();
            while (e2.hasMoreElements()) {
                ArrayType at2 = e2.nextElement();
                if (et != at2.getElementType() || dim >= at2.getArrayDimension()) continue;
                continue block3;
            }
            outVec.addElement(at);
        }
        return outVec;
    }

    protected void accumulateReferences(Hashtable<String, CompoundType> refHash, Hashtable<String, CompoundType> spcHash, Hashtable<String, ArrayType> arrHash) {
        Enumeration<CompoundType> compoundTypes = refHash.elements();
        while (compoundTypes.hasMoreElements()) {
            CompoundType type = compoundTypes.nextElement();
            Vector<CompoundType.Member> datVec = this.getData(type);
            Vector<CompoundType.Method> mthVec = this.getMethods(type);
            this.getInterfaces(type, refHash);
            this.getInheritance(type, refHash);
            this.getMethodReferences(mthVec, refHash, spcHash, arrHash, refHash);
            this.getMemberReferences(datVec, refHash, spcHash, arrHash);
        }
        Enumeration<ArrayType> arrayElements = arrHash.elements();
        while (arrayElements.hasMoreElements()) {
            ArrayType at = arrayElements.nextElement();
            Type et = at.getElementType();
            this.addReference(et, refHash, spcHash, arrHash);
        }
        Enumeration<CompoundType> refElements = refHash.elements();
        while (refElements.hasMoreElements()) {
            CompoundType t = refElements.nextElement();
            if (this.isIDLGeneratedFor(t)) continue;
            refHash.remove(t.getQualifiedName());
        }
    }

    protected boolean isIDLGeneratedFor(CompoundType t) {
        if (t.isCORBAObject()) {
            return false;
        }
        if (t.isIDLEntity()) {
            if (t.isBoxed()) {
                return true;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(t.getQualifiedName())) {
                return true;
            }
            return t.isCORBAUserException();
        }
        Hashtable<String, CompoundType> inhHash = new Hashtable<String, CompoundType>();
        this.getInterfaces(t, inhHash);
        if (t.getTypeCode() == 65536) {
            return inhHash.size() >= 2;
        }
        return true;
    }

    @Override
    protected void writeOutputFor(Generator.OutputType ot, HashSet<Type> alreadyChecked, IndentingWriter p) throws IOException {
        CompoundType ct;
        Type t = ot.getType();
        if (t.isArray()) {
            this.writeSequence(ot, p);
            return;
        }
        if (this.isSpecialReference(t)) {
            this.writeSpecial(t, p);
            return;
        }
        if (t.isCompound() && (ct = (CompoundType)t).isIDLEntity() && ct.isBoxed()) {
            this.writeBoxedIDL(ct, p);
            return;
        }
        if (t.isClass() && (ct = (ClassType)t).isException()) {
            String eName = this.unEsc(ct.getIDLExceptionName());
            String fName = ot.getName();
            if (fName.equals(eName.replace(' ', '_'))) {
                this.writeException((ClassType)ct, p);
                return;
            }
        }
        switch (t.getTypeCode()) {
            case 65536: {
                this.writeImplementation((ImplementationType)t, p);
                break;
            }
            case 16384: 
            case 131072: {
                this.writeNCType((CompoundType)t, p);
                break;
            }
            case 4096: 
            case 8192: {
                this.writeRemote((RemoteType)t, p);
                break;
            }
            case 32768: {
                this.writeValue((ValueType)t, p);
                break;
            }
            default: {
                throw new CompilerError("IDLGenerator got unexpected type code: " + t.getTypeCode());
            }
        }
    }

    protected void writeImplementation(ImplementationType t, IndentingWriter p) throws IOException {
        Hashtable<String, CompoundType> inhHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> refHash = new Hashtable<String, CompoundType>();
        this.getInterfaces(t, inhHash);
        this.writeBanner(t, 0, false, p);
        this.writeInheritedIncludes(inhHash, p);
        this.writeIfndef(t, 0, false, false, p);
        this.writeIncOrb(p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.p("interface " + t.getIDLName());
        this.writeInherits(inhHash, false, p);
        p.pln(" {");
        p.pln("};");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEpilog(t, refHash, p);
    }

    protected void writeNCType(CompoundType type, IndentingWriter stream) throws IOException {
        Vector<CompoundType.Member> conVec = this.getConstants(type);
        Vector<CompoundType.Method> mthVec = this.getMethods(type);
        Hashtable<String, CompoundType> inhHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> refHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> spcHash = new Hashtable<String, CompoundType>();
        Hashtable<String, ArrayType> arrHash = new Hashtable<String, ArrayType>();
        Hashtable<String, CompoundType> excHash = new Hashtable<String, CompoundType>();
        this.getInterfaces(type, inhHash);
        this.getInheritance(type, inhHash);
        this.getMethodReferences(mthVec, refHash, spcHash, arrHash, excHash);
        this.writeProlog(type, refHash, spcHash, arrHash, excHash, inhHash, stream);
        this.writeModule1(type, stream);
        stream.pln();
        stream.pI();
        stream.p("abstract valuetype " + type.getIDLName());
        this.writeInherits(inhHash, false, stream);
        stream.pln(" {");
        if (conVec.size() + mthVec.size() > 0) {
            int i1;
            stream.pln();
            stream.pI();
            for (i1 = 0; i1 < conVec.size(); ++i1) {
                this.writeConstant(conVec.elementAt(i1), stream);
            }
            for (i1 = 0; i1 < mthVec.size(); ++i1) {
                this.writeMethod(mthVec.elementAt(i1), stream);
            }
            stream.pO();
            stream.pln();
        }
        stream.pln("};");
        stream.pO();
        stream.pln();
        this.writeModule2(type, stream);
        this.writeEpilog(type, refHash, stream);
    }

    protected void writeRemote(RemoteType t, IndentingWriter p) throws IOException {
        Vector<CompoundType.Member> conVec = this.getConstants(t);
        Vector<CompoundType.Method> mthVec = this.getMethods(t);
        Hashtable<String, CompoundType> inhHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> refHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> spcHash = new Hashtable<String, CompoundType>();
        Hashtable<String, ArrayType> arrHash = new Hashtable<String, ArrayType>();
        Hashtable<String, CompoundType> excHash = new Hashtable<String, CompoundType>();
        this.getInterfaces(t, inhHash);
        this.getMethodReferences(mthVec, refHash, spcHash, arrHash, excHash);
        this.writeProlog(t, refHash, spcHash, arrHash, excHash, inhHash, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        if (t.getTypeCode() == 8192) {
            p.p("abstract ");
        }
        p.p("interface " + t.getIDLName());
        this.writeInherits(inhHash, false, p);
        p.pln(" {");
        if (conVec.size() + mthVec.size() > 0) {
            int i1;
            p.pln();
            p.pI();
            for (i1 = 0; i1 < conVec.size(); ++i1) {
                this.writeConstant(conVec.elementAt(i1), p);
            }
            for (i1 = 0; i1 < mthVec.size(); ++i1) {
                this.writeMethod(mthVec.elementAt(i1), p);
            }
            p.pO();
            p.pln();
        }
        p.pln("};");
        p.pO();
        p.pln();
        this.writeRepositoryID(t, p);
        p.pln();
        this.writeModule2(t, p);
        this.writeEpilog(t, refHash, p);
    }

    protected void writeValue(ValueType type, IndentingWriter outputStream) throws IOException {
        Vector<CompoundType.Member> datVec = this.getData(type);
        Vector<CompoundType.Member> conVec = this.getConstants(type);
        Vector<CompoundType.Method> mthVec = this.getMethods(type);
        Hashtable<String, CompoundType> inhHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> refHash = new Hashtable<String, CompoundType>();
        Hashtable<String, CompoundType> spcHash = new Hashtable<String, CompoundType>();
        Hashtable<String, ArrayType> arrHash = new Hashtable<String, ArrayType>();
        Hashtable<String, CompoundType> excHash = new Hashtable<String, CompoundType>();
        this.getInterfaces(type, inhHash);
        this.getInheritance(type, inhHash);
        this.getMethodReferences(mthVec, refHash, spcHash, arrHash, excHash);
        this.getMemberReferences(datVec, refHash, spcHash, arrHash);
        this.writeProlog(type, refHash, spcHash, arrHash, excHash, inhHash, outputStream);
        this.writeModule1(type, outputStream);
        outputStream.pln();
        outputStream.pI();
        if (type.isCustom()) {
            outputStream.p("custom ");
        }
        outputStream.p("valuetype " + type.getIDLName());
        this.writeInherits(inhHash, true, outputStream);
        outputStream.pln(" {");
        if (conVec.size() + datVec.size() + mthVec.size() > 0) {
            CompoundType.Member mem;
            int i1;
            outputStream.pln();
            outputStream.pI();
            for (i1 = 0; i1 < conVec.size(); ++i1) {
                this.writeConstant(conVec.elementAt(i1), outputStream);
            }
            for (i1 = 0; i1 < datVec.size(); ++i1) {
                mem = datVec.elementAt(i1);
                if (!mem.getType().isPrimitive()) continue;
                this.writeData(mem, outputStream);
            }
            for (i1 = 0; i1 < datVec.size(); ++i1) {
                mem = datVec.elementAt(i1);
                if (mem.getType().isPrimitive()) continue;
                this.writeData(mem, outputStream);
            }
            for (i1 = 0; i1 < mthVec.size(); ++i1) {
                this.writeMethod(mthVec.elementAt(i1), outputStream);
            }
            outputStream.pO();
            outputStream.pln();
        }
        outputStream.pln("};");
        outputStream.pO();
        outputStream.pln();
        this.writeRepositoryID(type, outputStream);
        outputStream.pln();
        this.writeModule2(type, outputStream);
        this.writeEpilog(type, refHash, outputStream);
    }

    protected void writeProlog(CompoundType t, Hashtable<String, CompoundType> refHash, Hashtable<String, CompoundType> spcHash, Hashtable<String, ArrayType> arrHash, Hashtable<String, CompoundType> excHash, Hashtable<String, CompoundType> inhHash, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, false, p);
        this.writeForwardReferences(refHash, p);
        this.writeIncludes(excHash, true, p);
        this.writeInheritedIncludes(inhHash, p);
        this.writeIncludes(spcHash, false, p);
        this.writeBoxedRMIIncludes(arrHash, p);
        this.writeIDLEntityIncludes(refHash, p);
        this.writeIncOrb(p);
        this.writeIfndef(t, 0, false, false, p);
    }

    protected void writeEpilog(CompoundType t, Hashtable<String, CompoundType> refHash, IndentingWriter p) throws IOException {
        this.writeIncludes(refHash, false, p);
        this.writeEndif(p);
    }

    protected void writeSpecial(Type t, IndentingWriter p) throws IOException {
        String spcName = t.getQualifiedName();
        if (null != spcName) {
            switch (spcName) {
                case "java.io.Serializable": {
                    this.writeJavaIoSerializable(t, p);
                    break;
                }
                case "java.io.Externalizable": {
                    this.writeJavaIoExternalizable(t, p);
                    break;
                }
                case "java.lang.Object": {
                    this.writeJavaLangObject(t, p);
                    break;
                }
                case "java.rmi.Remote": {
                    this.writeJavaRmiRemote(t, p);
                    break;
                }
                case "org.omg.CORBA.portable.IDLEntity": {
                    this.writeIDLEntity(t, p);
                    break;
                }
            }
        }
    }

    protected void writeJavaIoSerializable(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, false, p);
        this.writeIfndef(t, 0, false, false, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any Serializable;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeJavaIoExternalizable(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, false, p);
        this.writeIfndef(t, 0, false, false, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any Externalizable;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeJavaLangObject(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, false, p);
        this.writeIfndef(t, 0, false, false, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any _Object;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeJavaRmiRemote(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, false, p);
        this.writeIfndef(t, 0, false, false, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef Object Remote;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeIDLEntity(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, false, p);
        this.writeIfndef(t, 0, false, false, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any IDLEntity;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void getInterfaces(CompoundType ct, Hashtable<String, CompoundType> inhHash) {
        InterfaceType[] infs;
        block3: for (InterfaceType inf : infs = ct.getInterfaces()) {
            String inhName = inf.getQualifiedName();
            switch (ct.getTypeCode()) {
                case 32768: 
                case 131072: {
                    if (!"java.io.Externalizable".equals(inhName) && !"java.io.Serializable".equals(inhName) && !"org.omg.CORBA.portable.IDLEntity".equals(inhName)) break;
                    continue block3;
                }
                default: {
                    if ("java.rmi.Remote".equals(inhName)) continue block3;
                }
            }
            inhHash.put(inhName, inf);
        }
    }

    protected void getInheritance(CompoundType ct, Hashtable<String, CompoundType> inhHash) {
        ClassType par = ct.getSuperclass();
        if (par == null) {
            return;
        }
        String parName = par.getQualifiedName();
        switch (ct.getTypeCode()) {
            case 32768: 
            case 131072: {
                if (!"java.lang.Object".equals(parName)) break;
                return;
            }
            default: {
                return;
            }
        }
        inhHash.put(parName, par);
    }

    protected void getMethodReferences(Vector<CompoundType.Method> mthVec, Hashtable<String, CompoundType> refHash, Hashtable<String, CompoundType> spcHash, Hashtable<String, ArrayType> arrHash, Hashtable<String, CompoundType> excHash) {
        for (int i1 = 0; i1 < mthVec.size(); ++i1) {
            CompoundType.Method mth = mthVec.elementAt(i1);
            Type[] args = mth.getArguments();
            Type ret = mth.getReturnType();
            this.getExceptions(mth, excHash);
            for (Type arg : args) {
                this.addReference(arg, refHash, spcHash, arrHash);
            }
            this.addReference(ret, refHash, spcHash, arrHash);
        }
    }

    protected void getMemberReferences(Vector<CompoundType.Member> datVec, Hashtable<String, CompoundType> refHash, Hashtable<String, CompoundType> spcHash, Hashtable<String, ArrayType> arrHash) {
        for (int i1 = 0; i1 < datVec.size(); ++i1) {
            CompoundType.Member mem = datVec.elementAt(i1);
            Type dat = mem.getType();
            this.addReference(dat, refHash, spcHash, arrHash);
        }
    }

    protected void addReference(Type ref, Hashtable<String, CompoundType> refHash, Hashtable<String, CompoundType> spcHash, Hashtable<String, ArrayType> arrHash) {
        String rName = ref.getQualifiedName();
        switch (ref.getTypeCode()) {
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 131072: {
                refHash.put(rName, (CompoundType)ref);
                return;
            }
            case 2048: {
                if ("org.omg.CORBA.Object".equals(rName)) {
                    return;
                }
                refHash.put(rName, (CompoundType)ref);
                return;
            }
            case 262144: {
                arrHash.put(rName + ref.getArrayDimension(), (ArrayType)ref);
                return;
            }
        }
        if (this.isSpecialReference(ref)) {
            spcHash.put(rName, (CompoundType)ref);
        }
    }

    protected boolean isSpecialReference(Type ref) {
        String rName = ref.getQualifiedName();
        if ("java.io.Serializable".equals(rName)) {
            return true;
        }
        if ("java.io.Externalizable".equals(rName)) {
            return true;
        }
        if ("java.lang.Object".equals(rName)) {
            return true;
        }
        if ("java.rmi.Remote".equals(rName)) {
            return true;
        }
        return "org.omg.CORBA.portable.IDLEntity".equals(rName);
    }

    protected void getExceptions(CompoundType.Method mth, Hashtable<String, CompoundType> excHash) {
        ValueType[] excs;
        for (ValueType exc : excs = mth.getExceptions()) {
            if (!exc.isCheckedException() || exc.isRemoteExceptionOrSubclass()) continue;
            excHash.put(exc.getQualifiedName(), exc);
        }
    }

    protected Vector<CompoundType.Method> getMethods(CompoundType ct) {
        CompoundType.Method[] mths;
        Vector<CompoundType.Method> vec = new Vector<CompoundType.Method>();
        int ctType = ct.getTypeCode();
        switch (ctType) {
            case 4096: 
            case 8192: {
                break;
            }
            case 16384: 
            case 32768: 
            case 131072: {
                if (this.valueMethods) break;
            }
            default: {
                return vec;
            }
        }
        Identifier ctId = ct.getIdentifier();
        for (CompoundType.Method mth : mths = ct.getMethods()) {
            String mthName;
            if (mth.isPrivate() || mth.isInherited() || ctType == 32768 && ("readObject".equals(mthName = mth.getName()) || "writeObject".equals(mthName) || "readExternal".equals(mthName) || "writeExternal".equals(mthName)) || (ctType == 131072 || ctType == 16384) && mth.isConstructor()) continue;
            vec.addElement(mth);
        }
        return vec;
    }

    protected Vector<CompoundType.Member> getConstants(CompoundType ct) {
        CompoundType.Member[] mems;
        Vector<CompoundType.Member> vec = new Vector<CompoundType.Member>();
        for (CompoundType.Member mem : mems = ct.getMembers()) {
            Type memType = mem.getType();
            String memValue = mem.getValue();
            if (!mem.isPublic() || !mem.isFinal() || !mem.isStatic() || !memType.isPrimitive() && !"String".equals(memType.getName()) || memValue == null) continue;
            vec.addElement(mem);
        }
        return vec;
    }

    protected Vector<CompoundType.Member> getData(CompoundType t) {
        Vector<CompoundType.Member> vec = new Vector<CompoundType.Member>();
        if (t.getTypeCode() != 32768) {
            return vec;
        }
        ValueType vt = (ValueType)t;
        CompoundType.Member[] mems = vt.getMembers();
        boolean notCust = !vt.isCustom();
        for (CompoundType.Member mem : mems) {
            CompoundType.Member aMem;
            int i2;
            if (mem.isStatic() || mem.isTransient() || !mem.isPublic() && !notCust) continue;
            String memName = mem.getName();
            for (i2 = 0; i2 < vec.size() && memName.compareTo((aMem = vec.elementAt(i2)).getName()) >= 0; ++i2) {
            }
            vec.insertElementAt(mem, i2);
        }
        return vec;
    }

    protected void writeForwardReferences(Hashtable<String, CompoundType> refHash, IndentingWriter p) throws IOException {
        Enumeration<CompoundType> refEnum = refHash.elements();
        while (refEnum.hasMoreElements()) {
            CompoundType ct;
            Type t = refEnum.nextElement();
            if (t.isCompound() && (ct = (CompoundType)t).isIDLEntity()) continue;
            this.writeForwardReference(t, p);
        }
    }

    protected void writeForwardReference(Type t, IndentingWriter p) throws IOException {
        String qName = t.getQualifiedName();
        if (!"java.lang.String".equals(qName) && "org.omg.CORBA.Object".equals(qName)) {
            return;
        }
        this.writeIfndef(t, 0, false, true, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        switch (t.getTypeCode()) {
            case 16384: 
            case 131072: {
                p.p("abstract valuetype ");
                break;
            }
            case 8192: {
                p.p("abstract interface ");
                break;
            }
            case 32768: {
                p.p("valuetype ");
                break;
            }
            case 2048: 
            case 4096: {
                p.p("interface ");
                break;
            }
        }
        p.pln(t.getIDLName() + ";");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeForwardReference(ArrayType at, int dim, IndentingWriter p) throws IOException {
        Type et = at.getElementType();
        if (dim < 1) {
            if (et.isCompound()) {
                CompoundType ct = (CompoundType)et;
                this.writeForwardReference(et, p);
            }
            return;
        }
        String fName = this.unEsc(et.getIDLName()).replace(' ', '_');
        this.writeIfndef(at, dim, false, true, p);
        this.writeModule1(at, p);
        p.pln();
        p.pI();
        switch (et.getTypeCode()) {
            case 16384: 
            case 131072: {
                p.p("abstract valuetype ");
                break;
            }
            case 8192: {
                p.p("abstract interface ");
                break;
            }
            case 32768: {
                p.p("valuetype ");
                break;
            }
            case 2048: 
            case 4096: {
                p.p("interface ");
                break;
            }
        }
        p.pln("seq" + dim + "_" + fName + ";");
        p.pO();
        p.pln();
        this.writeModule2(at, p);
        this.writeEndif(p);
    }

    protected void writeIDLEntityIncludes(Hashtable<String, CompoundType> refHash, IndentingWriter p) throws IOException {
        Enumeration<CompoundType> refEnum = refHash.elements();
        while (refEnum.hasMoreElements()) {
            CompoundType ct;
            Type t = refEnum.nextElement();
            if (!t.isCompound() || !(ct = (CompoundType)t).isIDLEntity()) continue;
            this.writeInclude((Type)ct, 0, false, p);
            refHash.remove(ct.getQualifiedName());
        }
    }

    protected void writeIncludes(Hashtable<String, CompoundType> incHash, boolean isThrown, IndentingWriter p) throws IOException {
        Enumeration<CompoundType> incEnum = incHash.elements();
        while (incEnum.hasMoreElements()) {
            CompoundType t = incEnum.nextElement();
            this.writeInclude((Type)t, 0, isThrown, p);
        }
    }

    protected void writeBoxedRMIIncludes(Hashtable<String, ArrayType> arrHash, IndentingWriter p) throws IOException {
        Enumeration<ArrayType> e1 = arrHash.elements();
        block0: while (e1.hasMoreElements()) {
            ArrayType at = e1.nextElement();
            int dim = at.getArrayDimension();
            Type et = at.getElementType();
            Enumeration<ArrayType> e2 = arrHash.elements();
            while (e2.hasMoreElements()) {
                ArrayType at2 = e2.nextElement();
                if (et != at2.getElementType() || dim >= at2.getArrayDimension()) continue;
                continue block0;
            }
            this.writeInclude((Type)at, dim, false, p);
        }
    }

    protected void writeInheritedIncludes(Hashtable<String, CompoundType> inhHash, IndentingWriter p) throws IOException {
        Enumeration<CompoundType> inhEnum = inhHash.elements();
        while (inhEnum.hasMoreElements()) {
            CompoundType t = inhEnum.nextElement();
            this.writeInclude((Type)t, 0, false, p);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeInclude(Type t, int dim, boolean isThrown, IndentingWriter p) throws IOException {
        String tName;
        String[] modNames;
        if (t.isCompound()) {
            CompoundType ct = (CompoundType)t;
            String qName = ct.getQualifiedName();
            if ("java.lang.String".equals(qName)) {
                this.writeIncOrb(p);
                return;
            }
            if ("org.omg.CORBA.Object".equals(qName)) {
                return;
            }
            modNames = this.getIDLModuleNames(ct);
            tName = this.unEsc(ct.getIDLName());
            if (ct.isException()) {
                if (ct.isIDLEntityException()) {
                    if (ct.isCORBAUserException()) {
                        if (isThrown) {
                            tName = this.unEsc(ct.getIDLExceptionName());
                        }
                    } else {
                        tName = ct.getName();
                    }
                } else if (isThrown) {
                    tName = this.unEsc(ct.getIDLExceptionName());
                }
            }
        } else {
            if (!t.isArray()) return;
            Type et = t.getElementType();
            if (dim > 0) {
                modNames = this.getIDLModuleNames(t);
                tName = "seq" + dim + "_" + this.unEsc(et.getIDLName().replace(' ', '_'));
            } else {
                if (!et.isCompound()) {
                    return;
                }
                CompoundType ct = (CompoundType)et;
                String[] modNames2 = this.getIDLModuleNames(ct);
                String tName2 = this.unEsc(ct.getIDLName());
                this.writeInclude((Type)ct, modNames2, tName2, p);
                return;
            }
        }
        this.writeInclude(t, modNames, tName, p);
    }

    protected void writeInclude(Type t, String[] modNames, String tName, IndentingWriter p) throws IOException {
        if (t.isCompound()) {
            CompoundType it = (CompoundType)t;
            if (this.ifHash.size() > 0 && it.isIDLEntity()) {
                String qName = t.getQualifiedName();
                Enumeration<String> k = this.ifHash.keys();
                while (k.hasMoreElements()) {
                    String from = k.nextElement();
                    if (!qName.startsWith(from)) continue;
                    String to = this.ifHash.get(from);
                    p.pln("#include \"" + to + "\"");
                    return;
                }
            }
        } else if (!t.isArray()) {
            return;
        }
        p.p("#include \"");
        for (String modName : modNames) {
            p.p(modName + "/");
        }
        p.p(tName + ".idl\"");
        p.pln();
    }

    protected String getQualifiedName(Type t) {
        String[] modNames = this.getIDLModuleNames(t);
        int len = modNames.length;
        StringBuilder buf = new StringBuilder();
        for (int i1 = 0; i1 < len; ++i1) {
            buf.append(modNames[i1]).append(".");
        }
        buf.append(t.getIDLName());
        return buf.toString();
    }

    protected String getQualifiedIDLName(Type t) {
        if (t.isPrimitive()) {
            return t.getIDLName();
        }
        if (!t.isArray() && "org.omg.CORBA.Object".equals(t.getQualifiedName())) {
            return t.getIDLName();
        }
        String[] modNames = this.getIDLModuleNames(t);
        int len = modNames.length;
        if (len > 0) {
            StringBuilder buf = new StringBuilder();
            for (int i1 = 0; i1 < len; ++i1) {
                buf.append("::").append(modNames[i1]);
            }
            buf.append("::").append(t.getIDLName());
            return buf.toString();
        }
        return t.getIDLName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String[] getIDLModuleNames(Type t) {
        Vector<String> mVec;
        CompoundType ct;
        String[] modNames = t.getIDLModuleNames();
        if (t.isCompound()) {
            ct = (CompoundType)t;
            if (!ct.isIDLEntity) {
                return modNames;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(t.getQualifiedName())) {
                return modNames;
            }
        } else {
            if (!t.isArray()) return modNames;
            Type et = t.getElementType();
            if (!et.isCompound()) return modNames;
            ct = (CompoundType)et;
            if (!ct.isIDLEntity) {
                return modNames;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(t.getQualifiedName())) {
                return modNames;
            }
        }
        if (!this.translateJavaPackage(ct, mVec = new Vector<String>())) {
            this.stripJavaPackage(ct, mVec);
        }
        if (ct.isBoxed()) {
            mVec.insertElementAt("org", 0);
            mVec.insertElementAt("omg", 1);
            mVec.insertElementAt("boxedIDL", 2);
        }
        if (t.isArray()) {
            mVec.insertElementAt("org", 0);
            mVec.insertElementAt("omg", 1);
            mVec.insertElementAt("boxedRMI", 2);
        }
        Object[] outArr = new String[mVec.size()];
        mVec.copyInto(outArr);
        return outArr;
    }

    protected boolean translateJavaPackage(CompoundType ct, Vector<String> vec) {
        vec.removeAllElements();
        boolean ret = false;
        String fc = null;
        if (!ct.isIDLEntity()) {
            return ret;
        }
        String pName = ct.getPackageName();
        if (pName == null) {
            return ret;
        }
        StringTokenizer pt = new StringTokenizer(pName, ".");
        while (pt.hasMoreTokens()) {
            vec.addElement(pt.nextToken());
        }
        if (this.imHash.size() > 0) {
            Enumeration<String> k = this.imHash.keys();
            block1: while (k.hasMoreElements()) {
                int ifr;
                String from = k.nextElement();
                StringTokenizer ft = new StringTokenizer(from, ".");
                int vecLen = vec.size();
                for (ifr = 0; ifr < vecLen && ft.hasMoreTokens(); ++ifr) {
                    if (!vec.elementAt(ifr).equals(ft.nextToken())) continue block1;
                }
                if (ft.hasMoreTokens()) {
                    fc = ft.nextToken();
                    if (!ct.getName().equals(fc) || ft.hasMoreTokens()) continue;
                }
                ret = true;
                for (int i4 = 0; i4 < ifr; ++i4) {
                    vec.removeElementAt(0);
                }
                String to = this.imHash.get(from);
                StringTokenizer tt = new StringTokenizer(to, "::");
                int itoco = tt.countTokens();
                int ito = 0;
                if (fc != null) {
                    --itoco;
                }
                for (ito = 0; ito < itoco; ++ito) {
                    vec.insertElementAt(tt.nextToken(), ito);
                }
                if (fc == null) continue;
                String tc = tt.nextToken();
                if (ct.getName().equals(tc)) continue;
                vec.insertElementAt(tc, ito);
            }
        }
        return ret;
    }

    protected void stripJavaPackage(CompoundType ct, Vector<String> vec) {
        vec.removeAllElements();
        if (!ct.isIDLEntity()) {
            return;
        }
        String repID = ct.getRepositoryID().substring(4);
        StringTokenizer rept = new StringTokenizer(repID, "/");
        if (rept.countTokens() < 2) {
            return;
        }
        while (rept.hasMoreTokens()) {
            vec.addElement(rept.nextToken());
        }
        vec.removeElementAt(vec.size() - 1);
        String pName = ct.getPackageName();
        if (pName == null) {
            return;
        }
        Vector<String> pVec = new Vector<String>();
        StringTokenizer pt = new StringTokenizer(pName, ".");
        while (pt.hasMoreTokens()) {
            pVec.addElement(pt.nextToken());
        }
        int i1 = vec.size() - 1;
        for (int i2 = pVec.size() - 1; i1 >= 0 && i2 >= 0; --i1, --i2) {
            String rep = vec.elementAt(i1);
            String pkg = (String)pVec.elementAt(i2);
            if (!pkg.equals(rep)) break;
        }
        for (int i3 = 0; i3 <= i1; ++i3) {
            vec.removeElementAt(0);
        }
    }

    protected void writeSequence(Generator.OutputType ot, IndentingWriter p) throws IOException {
        ArrayType at = (ArrayType)ot.getType();
        Type et = at.getElementType();
        String fName = ot.getName();
        int dim = Integer.parseInt(fName.substring(3, fName.indexOf("_")));
        String idlName = this.unEsc(et.getIDLName()).replace(' ', '_');
        String qIdlName = this.getQualifiedIDLName(et);
        String qName = et.getQualifiedName();
        String repID = at.getRepositoryID();
        int rix1 = repID.indexOf(91);
        int rix2 = repID.lastIndexOf(91) + 1;
        StringBuffer rid = new StringBuffer(repID.substring(0, rix1) + repID.substring(rix2));
        for (int i1 = 0; i1 < dim; ++i1) {
            rid.insert(rix1, '[');
        }
        String vtName = "seq" + dim + "_" + idlName;
        boolean isFromIDL = false;
        if (et.isCompound()) {
            CompoundType ct = (CompoundType)et;
            isFromIDL = ct.isIDLEntity() || ct.isCORBAObject();
        }
        boolean isForwardInclude = et.isCompound() && !this.isSpecialReference(et) && dim == 1 && !isFromIDL && !"org.omg.CORBA.Object".equals(qName) && !"java.lang.String".equals(qName);
        this.writeBanner(at, dim, false, p);
        if (dim == 1 && "java.lang.String".equals(qName)) {
            this.writeIncOrb(p);
        }
        if (!(dim == 1 && "org.omg.CORBA.Object".equals(qName) || !this.isSpecialReference(et) && dim <= 1 && !isFromIDL)) {
            this.writeInclude((Type)at, dim - 1, false, p);
        }
        this.writeIfndef(at, dim, false, false, p);
        if (isForwardInclude) {
            this.writeForwardReference(at, dim - 1, p);
        }
        this.writeModule1(at, p);
        p.pln();
        p.pI();
        p.p("valuetype " + vtName);
        p.p(" sequence<");
        if (dim == 1) {
            p.p(qIdlName);
        } else {
            p.p("seq" + (dim - 1) + "_");
            p.p(idlName);
        }
        p.pln(">;");
        p.pO();
        p.pln();
        p.pln("#pragma ID " + vtName + " \"" + rid + "\"");
        p.pln();
        this.writeModule2(at, p);
        if (isForwardInclude) {
            this.writeInclude((Type)at, dim - 1, false, p);
        }
        this.writeEndif(p);
    }

    protected void writeBoxedIDL(CompoundType t, IndentingWriter p) throws IOException {
        String[] boxNames = this.getIDLModuleNames(t);
        int len = boxNames.length;
        String[] modNames = new String[len - 3];
        for (int i1 = 0; i1 < len - 3; ++i1) {
            modNames[i1] = boxNames[i1 + 3];
        }
        String tName = this.unEsc(t.getIDLName());
        this.writeBanner(t, 0, false, p);
        this.writeInclude((Type)t, modNames, tName, p);
        this.writeIfndef(t, 0, false, false, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.p("valuetype " + tName + " ");
        for (String modName : modNames) {
            p.p("::" + modName);
        }
        p.pln("::" + tName + ";");
        p.pO();
        p.pln();
        this.writeRepositoryID(t, p);
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeException(ClassType t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, true, p);
        this.writeIfndef(t, 0, true, false, p);
        this.writeForwardReference(t, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("exception " + t.getIDLExceptionName() + " {");
        p.pln();
        p.pI();
        p.pln(t.getIDLName() + " value;");
        p.pO();
        p.pln();
        p.pln("};");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeInclude((Type)t, 0, false, p);
        this.writeEndif(p);
    }

    protected void writeRepositoryID(Type t, IndentingWriter p) throws IOException {
        CompoundType ct;
        String repid = t.getRepositoryID();
        if (t.isCompound() && (ct = (CompoundType)t).isBoxed()) {
            repid = ct.getBoxedRepositoryID();
        }
        p.pln("#pragma ID " + t.getIDLName() + " \"" + repid + "\"");
    }

    protected void writeInherits(Hashtable<String, CompoundType> inhHash, boolean forValuetype, IndentingWriter p) throws IOException {
        int i;
        CompoundType ct;
        int itot = inhHash.size();
        int iinh = 0;
        int isup = 0;
        if (itot < 1) {
            return;
        }
        Enumeration<CompoundType> inhEnum = inhHash.elements();
        if (forValuetype) {
            while (inhEnum.hasMoreElements()) {
                ct = inhEnum.nextElement();
                if (ct.getTypeCode() != 8192) continue;
                ++isup;
            }
        }
        if ((iinh = itot - isup) > 0) {
            p.p(": ");
            inhEnum = inhHash.elements();
            while (inhEnum.hasMoreElements()) {
                ct = inhEnum.nextElement();
                if (!ct.isClass()) continue;
                p.p(this.getQualifiedIDLName(ct));
                if (iinh > 1) {
                    p.p(", ");
                    break;
                }
                if (itot <= 1) break;
                p.p(" ");
                break;
            }
            i = 0;
            inhEnum = inhHash.elements();
            while (inhEnum.hasMoreElements()) {
                ct = inhEnum.nextElement();
                if (ct.isClass() || ct.getTypeCode() == 8192) continue;
                if (i++ > 0) {
                    p.p(", ");
                }
                p.p(this.getQualifiedIDLName(ct));
            }
        }
        if (isup > 0) {
            p.p(" supports ");
            i = 0;
            inhEnum = inhHash.elements();
            while (inhEnum.hasMoreElements()) {
                ct = inhEnum.nextElement();
                if (ct.getTypeCode() != 8192) continue;
                if (i++ > 0) {
                    p.p(", ");
                }
                p.p(this.getQualifiedIDLName(ct));
            }
        }
    }

    protected void writeConstant(CompoundType.Member constant, IndentingWriter p) throws IOException {
        Type t = constant.getType();
        p.p("const ");
        p.p(this.getQualifiedIDLName(t));
        p.p(" " + constant.getIDLName() + " = " + constant.getValue());
        p.pln(";");
    }

    protected void writeData(CompoundType.Member data, IndentingWriter p) throws IOException {
        if (data.isInnerClassDeclaration()) {
            return;
        }
        Type t = data.getType();
        if (data.isPublic()) {
            p.p("public ");
        } else {
            p.p("private ");
        }
        p.pln(this.getQualifiedIDLName(t) + " " + data.getIDLName() + ";");
    }

    protected void writeAttribute(CompoundType.Method attr, IndentingWriter p) throws IOException {
        if (attr.getAttributeKind() == 5) {
            return;
        }
        Type t = attr.getReturnType();
        if (!attr.isReadWriteAttribute()) {
            p.p("readonly ");
        }
        p.p("attribute " + this.getQualifiedIDLName(t) + " ");
        p.pln(attr.getAttributeName() + ";");
    }

    protected void writeMethod(CompoundType.Method method, IndentingWriter p) throws IOException {
        int i;
        if (method.isAttribute()) {
            this.writeAttribute(method, p);
            return;
        }
        Type[] pts = method.getArguments();
        String[] paramNames = method.getArgumentNames();
        Type rt = method.getReturnType();
        Hashtable<String, CompoundType> excHash = new Hashtable<String, CompoundType>();
        this.getExceptions(method, excHash);
        if (method.isConstructor()) {
            if (this.factory) {
                p.p("factory " + method.getIDLName() + "(");
            } else {
                p.p("init(");
            }
        } else {
            p.p(this.getQualifiedIDLName(rt));
            p.p(" " + method.getIDLName() + "(");
        }
        p.pI();
        for (i = 0; i < pts.length; ++i) {
            if (i > 0) {
                p.pln(",");
            } else {
                p.pln();
            }
            p.p("in ");
            p.p(this.getQualifiedIDLName(pts[i]));
            p.p(" " + paramNames[i]);
        }
        p.pO();
        p.p(" )");
        if (excHash.size() > 0) {
            p.pln(" raises (");
            p.pI();
            i = 0;
            Enumeration<CompoundType> excEnum = excHash.elements();
            while (excEnum.hasMoreElements()) {
                ValueType exc = (ValueType)excEnum.nextElement();
                if (i > 0) {
                    p.pln(",");
                }
                if (exc.isIDLEntityException()) {
                    if (exc.isCORBAUserException()) {
                        p.p("::org::omg::CORBA::UserEx");
                    } else {
                        String[] modNames;
                        for (String modName : modNames = this.getIDLModuleNames(exc)) {
                            p.p("::" + modName);
                        }
                        p.p("::" + exc.getName());
                    }
                } else {
                    p.p(exc.getQualifiedIDLExceptionName(true));
                }
                ++i;
            }
            p.pO();
            p.p(" )");
        }
        p.pln(";");
    }

    protected String unEsc(String name) {
        if (name.startsWith("_")) {
            return name.substring(1);
        }
        return name;
    }

    protected void writeBanner(Type t, int dim, boolean isException, IndentingWriter p) throws IOException {
        String[] modNames = this.getIDLModuleNames(t);
        String fName = this.unEsc(t.getIDLName());
        if (isException && t.isClass()) {
            ClassType ct = (ClassType)t;
            fName = this.unEsc(ct.getIDLExceptionName());
        }
        if (dim > 0 && t.isArray()) {
            String[] et = t.getElementType();
            fName = "seq" + dim + "_" + this.unEsc(et.getIDLName().replace(' ', '_'));
        }
        p.pln("/**");
        p.p(" * ");
        for (String modName : modNames) {
            p.p(modName + "/");
        }
        p.pln(fName + ".idl");
        p.pln(" * Generated by rmic -idl. Do not edit");
        String d = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault()).format(new Date());
        String ocStr = "o'clock";
        int ocx = d.indexOf(ocStr);
        p.p(" * ");
        if (ocx > -1) {
            p.pln(d.substring(0, ocx) + d.substring(ocx + ocStr.length()));
        } else {
            p.pln(d);
        }
        p.pln(" */");
        p.pln();
    }

    protected void writeIncOrb(IndentingWriter p) throws IOException {
        p.pln("#include \"orb.idl\"");
    }

    protected void writeIfndef(Type t, int dim, boolean isException, boolean isForward, IndentingWriter p) throws IOException {
        String[] modNames = this.getIDLModuleNames(t);
        String fName = this.unEsc(t.getIDLName());
        if (isException && t.isClass()) {
            ClassType ct = (ClassType)t;
            fName = this.unEsc(ct.getIDLExceptionName());
        }
        if (dim > 0 && t.isArray()) {
            Type et = t.getElementType();
            fName = "seq" + dim + "_" + this.unEsc(et.getIDLName().replace(' ', '_'));
        }
        p.pln();
        p.p("#ifndef __");
        for (String modName : modNames) {
            p.p(modName + "_");
        }
        p.pln(fName + "__");
        if (!isForward) {
            p.p("#define __");
            for (String modName : modNames) {
                p.p(modName + "_");
            }
            p.pln(fName + "__");
            p.pln();
        }
    }

    protected void writeEndif(IndentingWriter p) throws IOException {
        p.pln("#endif");
        p.pln();
    }

    protected void writeModule1(Type t, IndentingWriter p) throws IOException {
        String[] modNames = this.getIDLModuleNames(t);
        p.pln();
        for (String modName : modNames) {
            p.pln("module " + modName + " {");
        }
    }

    protected void writeModule2(Type t, IndentingWriter p) throws IOException {
        String[] modNames;
        for (String modName : modNames = this.getIDLModuleNames(t)) {
            p.pln("};");
        }
        p.pln();
    }
}

