/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.PushBuilder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.LogFacade;
import org.apache.catalina.connector.Request;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.http2.PushEvent;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.Http2Stream;

public class ApplicationPushBuilder
implements PushBuilder {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    private static final Header[] REMOVE_HEADERS = new Header[]{Header.ETag, Header.IfModifiedSince, Header.IfNoneMatch, Header.IfRange, Header.IfUnmodifiedSince, Header.IfMatch, Header.LastModified, Header.Referer, Header.AcceptRanges, Header.Range, Header.AcceptRanges, Header.ContentRange, Header.Authorization, Header.ProxyAuthenticate, Header.ProxyAuthorization};
    private static final Header[] CONDITIONAL_HEADERS = new Header[]{Header.IfModifiedSince, Header.IfNoneMatch, Header.IfRange, Header.IfUnmodifiedSince, Header.IfMatch};
    private final HttpServletRequest baseRequest;
    private final Request catalinaRequest;
    private final org.glassfish.grizzly.http.server.Request coyoteRequest;
    private final String sessionCookieName;
    private final boolean addSessionCookie;
    private final boolean addSessionPathParameter;
    private final MimeHeaders headers = new MimeHeaders();
    private final List<org.glassfish.grizzly.http.Cookie> cookies = new ArrayList<org.glassfish.grizzly.http.Cookie>();
    private String method = "GET";
    private String path;
    private String queryString;
    private String sessionId;

    public ApplicationPushBuilder(HttpServletRequest request) {
        this.baseRequest = request;
        ServletRequest current = request;
        while (current instanceof ServletRequestWrapper) {
            current = ((ServletRequestWrapper)current).getRequest();
        }
        if (!(current instanceof Request)) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00544"), current.getClass().getName());
            throw new UnsupportedOperationException(msg);
        }
        this.catalinaRequest = (Request)current;
        this.coyoteRequest = this.catalinaRequest.getCoyoteRequest();
        this.headers.copyFrom(this.coyoteRequest.getRequest().getHeaders());
        String authorization = this.headers.getHeader(Header.Authorization);
        for (Header removeHeader : REMOVE_HEADERS) {
            this.headers.removeHeader(removeHeader);
        }
        if (request.getRemoteUser() != null) {
            this.headers.addValue(Header.Authorization).setString(authorization);
        }
        StringBuffer referer = request.getRequestURL();
        if (request.getQueryString() != null) {
            referer.append('?');
            referer.append(request.getQueryString());
        }
        this.headers.addValue(Header.Referer).setString(referer.toString());
        Context context = this.catalinaRequest.getContext();
        this.sessionCookieName = context.getSessionCookieName();
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.sessionId = session.getId();
        }
        if (this.sessionId == null) {
            this.sessionId = request.getRequestedSessionId();
        }
        if (!request.isRequestedSessionIdFromCookie() && !request.isRequestedSessionIdFromURL() && this.sessionId != null) {
            Cookie[] sessionTrackingModes = request.getServletContext().getEffectiveSessionTrackingModes();
            this.addSessionCookie = sessionTrackingModes.contains((Object)SessionTrackingMode.COOKIE);
            this.addSessionPathParameter = sessionTrackingModes.contains((Object)SessionTrackingMode.URL);
        } else {
            this.addSessionCookie = request.isRequestedSessionIdFromCookie();
            this.addSessionPathParameter = request.isRequestedSessionIdFromURL();
        }
        if (request.getCookies() != null) {
            for (Cookie c : request.getCookies()) {
                this.cookies.add(new org.glassfish.grizzly.http.Cookie(c.getName(), c.getValue()));
            }
        }
        Response coyoteResponse = this.coyoteRequest.getResponse();
        for (org.glassfish.grizzly.http.Cookie responseCookie : coyoteResponse.getCookies()) {
            if (responseCookie.getMaxAge() > 0) {
                this.cookies.add(new org.glassfish.grizzly.http.Cookie(responseCookie.getName(), responseCookie.getValue()));
                continue;
            }
            Iterator<org.glassfish.grizzly.http.Cookie> cookieIterator = this.cookies.iterator();
            while (cookieIterator.hasNext()) {
                org.glassfish.grizzly.http.Cookie cookie = cookieIterator.next();
                if (!cookie.getName().equals(responseCookie.getName())) continue;
                cookieIterator.remove();
            }
        }
        if (this.cookies != null && !this.cookies.isEmpty()) {
            for (org.glassfish.grizzly.http.Cookie c : this.cookies) {
                this.headers.addValue(Header.Cookie).setString(c.asClientCookieString());
            }
        }
    }

    @Override
    public PushBuilder method(String method) {
        if (method == null) {
            throw new NullPointerException(rb.getString("AS-WEB-CORE-00546"));
        }
        if (method.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00547"));
        }
        String upperMethod = method.toUpperCase(Locale.ENGLISH);
        if (upperMethod.equals("POST") || upperMethod.equals("PUT") || upperMethod.equals("DELETE") || upperMethod.equals("CONNECT") || upperMethod.equals("OPTIONS") || upperMethod.equals("TRACE")) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00548"), method);
            throw new IllegalArgumentException(msg);
        }
        this.method = method;
        return this;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public PushBuilder addHeader(String name, String value) {
        if (ApplicationPushBuilder.isValidNameValue(name, value)) {
            this.headers.addValue(name).setString(value);
        }
        return this;
    }

    @Override
    public PushBuilder setHeader(String name, String value) {
        if (ApplicationPushBuilder.isValidNameValue(name, value)) {
            this.headers.setValue(name).setString(value);
        }
        return this;
    }

    @Override
    public PushBuilder removeHeader(String name) {
        if (ApplicationPushBuilder.isValidName(name)) {
            this.headers.removeHeader(name);
        }
        return this;
    }

    @Override
    public Set<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator nameIter = this.headers.names().iterator();
        while (nameIter.hasNext()) {
            names.add((String)nameIter.next());
        }
        return names;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public PushBuilder path(String path) {
        this.path = path != null && !path.startsWith("/") ? this.baseRequest.getContextPath() + "/" + path : path;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void push() {
        Object pathLocal;
        if (this.path == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00545"));
        }
        Http2Stream http2Stream = (Http2Stream)this.coyoteRequest.getAttribute(Http2Stream.HTTP2_STREAM_ATTRIBUTE);
        if (http2Stream == null || !http2Stream.isPushEnabled()) {
            return;
        }
        Object object = pathLocal = this.path.charAt(0) == '/' ? this.path : this.coyoteRequest.getContextPath() + "/" + this.path;
        if (this.queryString != null) {
            pathLocal = (String)pathLocal + (((String)pathLocal).indexOf(63) != -1 ? "&" + this.queryString : "?" + this.queryString);
        }
        if (this.sessionId != null) {
            if (this.addSessionPathParameter) {
                pathLocal = (String)pathLocal + ";" + this.sessionCookieName + "=" + this.sessionId;
            }
            if (this.addSessionCookie) {
                this.cookies.add(new org.glassfish.grizzly.http.Cookie(this.sessionCookieName, this.sessionId));
            }
        }
        PushEvent.PushEventBuilder pushEventBuilder = PushEvent.builder();
        pushEventBuilder.method(this.method);
        pushEventBuilder.headers(this.headers);
        pushEventBuilder.path((String)pathLocal);
        pushEventBuilder.httpRequest(this.coyoteRequest.getRequest());
        this.coyoteRequest.getContext().notifyDownstream((FilterChainEvent)pushEventBuilder.build());
        this.path = null;
        for (Header conditionalHeader : CONDITIONAL_HEADERS) {
            this.headers.removeHeader(conditionalHeader);
        }
    }

    private static boolean isValidNameValue(String name, String value) {
        return ApplicationPushBuilder.isValidName(name) && value != null && !value.isEmpty();
    }

    private static boolean isValidName(String name) {
        return name != null && !name.isEmpty();
    }
}

