/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loader.util;

import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.logging.annotation.LogMessageInfo;

public class ASClassLoaderUtil {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Cannot convert classpath to URL {0}", level="WARNING")
    private static final String CLASSPATH_ERROR = "NCLS-DEPLOYMENT-00045";
    @LogMessageInfo(message="Exception:  {0}", level="WARNING")
    private static final String EXCEPTION = "NCLS-DEPLOYMENT-00017";
    @LogMessageInfo(message="unexpected error in getting urls", level="WARNING")
    private static final String UNEXPECTED_EXCEPTION = "NCLS-DEPLOYMENT-00018";
    private static String modulesClassPath = null;
    private static final String MANIFEST_ENTRY = "META-INF" + File.separator + "MANIFEST.MF";

    public static String getModuleClassPath(ServiceLocator habitat, String moduleId, String deploymentLibs) {
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "ASClassLoaderUtil.getModuleClassPath for module Id : " + moduleId);
        }
        StringBuilder classpath = new StringBuilder(ASClassLoaderUtil.getModulesClasspath(habitat));
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)habitat.getService(ClassLoaderHierarchy.class, new Annotation[0]);
        String commonClassPath = clh.getCommonClassPath();
        if (commonClassPath != null && commonClassPath.length() > 0) {
            classpath.append(commonClassPath).append(File.pathSeparator);
        }
        ASClassLoaderUtil.addDeployParamLibrariesForModule(classpath, moduleId, deploymentLibs, habitat);
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "Final classpath: " + classpath.toString());
        }
        return classpath.toString();
    }

    public static String getModuleClassPath(ServiceLocator habitat, DeploymentContext context) {
        DeployCommandParameters params = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        return ASClassLoaderUtil.getModuleClassPath(habitat, params.name(), params.libraries());
    }

    private static void addDeployParamLibrariesForModule(StringBuilder sb, String moduleId, String deploymentLibs, ServiceLocator habitat) {
        URL[] libs;
        if (moduleId.indexOf("#") != -1) {
            moduleId = moduleId.substring(0, moduleId.indexOf("#"));
        }
        if (deploymentLibs == null) {
            ApplicationInfo appInfo = ((ApplicationRegistry)habitat.getService(ApplicationRegistry.class, new Annotation[0])).get(moduleId);
            if (appInfo == null) {
                return;
            }
            deploymentLibs = appInfo.getLibraries();
        }
        if ((libs = ASClassLoaderUtil.getDeployParamLibrariesAsURLs(deploymentLibs, habitat)) != null) {
            for (URL u : libs) {
                sb.append(u.getPath());
                sb.append(File.pathSeparator);
            }
        }
    }

    private static URL[] getDeployParamLibrariesAsURLs(String librariesStr, ServiceLocator habitat) {
        return ASClassLoaderUtil.getDeployParamLibrariesAsURLs(librariesStr, (ServerEnvironment)habitat.getService(ServerEnvironment.class, new Annotation[0]));
    }

    public static URL[] getLibrariesAsURLs(Set<String> librariesStr, ServerEnvironment env) {
        if (librariesStr == null) {
            return null;
        }
        URL[] urls = new URL[librariesStr.size()];
        String[] librariesStrArray = new String[librariesStr.size()];
        librariesStrArray = librariesStr.toArray(librariesStrArray);
        return ASClassLoaderUtil.getDeployParamLibrariesAsURLs(env, librariesStrArray, urls);
    }

    public static URL[] getDeployParamLibrariesAsURLs(String librariesStr, ServerEnvironment env) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        URL[] urls = new URL[librariesStrArray.length];
        return ASClassLoaderUtil.getDeployParamLibrariesAsURLs(env, librariesStrArray, urls);
    }

    private static URL[] getDeployParamLibrariesAsURLs(ServerEnvironment env, String[] librariesStrArray, URL[] urls) {
        String appLibsDir = env.getLibPath() + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            try {
                File f = new File(libraryStr);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libraryStr);
                }
                URL url = f.toURI().toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                deplLogger.log(Level.WARNING, CLASSPATH_ERROR, libraryStr);
                LogRecord lr = new LogRecord(Level.WARNING, EXCEPTION);
                lr.setParameters(new Object[]{malEx.getMessage()});
                lr.setThrown(malEx);
                deplLogger.log(lr);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getModulesClasspath(ServiceLocator habitat) {
        Class<ASClassLoaderUtil> clazz = ASClassLoaderUtil.class;
        synchronized (ASClassLoaderUtil.class) {
            if (modulesClassPath == null) {
                StringBuilder tmpString = new StringBuilder();
                ModulesRegistry mr = (ModulesRegistry)habitat.getService(ModulesRegistry.class, new Annotation[0]);
                if (mr != null) {
                    for (HK2Module module : mr.getModules()) {
                        for (URI uri : module.getModuleDefinition().getLocations()) {
                            tmpString.append(uri.getPath());
                            tmpString.append(File.pathSeparator);
                        }
                    }
                }
                modulesClassPath = tmpString.toString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return modulesClassPath;
        }
    }

    public static URL[] getURLs(File[] dirs, File[] jarDirs, boolean ignoreZip) throws IOException {
        return ASClassLoaderUtil.convertURLListToArray(ASClassLoaderUtil.getURLsAsList(dirs, jarDirs, ignoreZip));
    }

    public static List<URL> getURLsAsList(File[] dirs, File[] jarDirs, boolean ignoreZip) throws IOException {
        int i;
        ArrayList<URL> list = new ArrayList<URL>();
        if (dirs != null) {
            for (i = 0; i < dirs.length; ++i) {
                File dir = dirs[i];
                if (!dir.isDirectory() && !dir.canRead()) continue;
                URL url = dir.toURI().toURL();
                list.add(url);
                if (!deplLogger.isLoggable(Level.FINE)) continue;
                deplLogger.log(Level.FINE, "Adding directory to class path:" + url.toString());
            }
        }
        if (jarDirs != null) {
            for (i = 0; i < jarDirs.length; ++i) {
                File jarDir = jarDirs[i];
                if (!jarDir.isDirectory() && !jarDir.canRead()) continue;
                File[] files = jarDir.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    File jar = files[j];
                    if (!FileUtils.isJar((File)jar) && (ignoreZip || !FileUtils.isZip((File)jar))) continue;
                    list.add(jar.toURI().toURL());
                    if (!deplLogger.isLoggable(Level.FINE)) continue;
                    deplLogger.log(Level.FINE, "Adding jar to class path:" + jar.toURL());
                }
            }
        }
        return list;
    }

    public static URL[] convertURLListToArray(List<URL> list) {
        URL[] urls = new URL[]{};
        if (list != null && list.size() > 0) {
            urls = new URL[list.size()];
            urls = list.toArray(urls);
        }
        return urls;
    }

    public static List<URL> getURLsFromClasspath(String classpath, String delimiter, String rootPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpath == null || classpath.length() == 0) {
            return urls;
        }
        StringTokenizer st = new StringTokenizer(classpath, delimiter);
        while (st.hasMoreTokens()) {
            try {
                Object path = st.nextToken();
                try {
                    URL url = new URL((String)path);
                    URI uri = url.toURI();
                    if (uri.isAbsolute()) {
                        urls.add(uri.toURL());
                        continue;
                    }
                }
                catch (Exception url) {
                    // empty catch block
                }
                if (rootPath != null && rootPath.length() != 0) {
                    path = rootPath + File.separator + (String)path;
                }
                File f = new File((String)path);
                urls.add(f.toURI().toURL());
            }
            catch (Exception e) {
                deplLogger.log(Level.WARNING, UNEXPECTED_EXCEPTION, e);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(String rootPath) {
        InputStream in = null;
        Manifest mf = null;
        try {
            in = new FileInputStream(rootPath + File.separator + MANIFEST_ENTRY);
            if (in != null) {
                mf = new Manifest(in);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return mf;
    }

    public static List<URL> getManifestClassPathAsURLs(Manifest manifest, String rootPath) {
        List<URL> urlList = new ArrayList<URL>();
        if (manifest != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                Attributes.Name next = (Attributes.Name)entry.getKey();
                if (!next.equals(Attributes.Name.CLASS_PATH)) continue;
                String classpathString = (String)entry.getValue();
                urlList = ASClassLoaderUtil.getURLsFromClasspath(classpathString, " ", rootPath);
            }
        }
        return urlList;
    }

    public static URL[] getAppLibDirLibraries(File appRoot, String appLibDir, String compatibilityProp) throws IOException {
        return ASClassLoaderUtil.convertURLListToArray(ASClassLoaderUtil.getAppLibDirLibrariesAsList(appRoot, appLibDir, compatibilityProp));
    }

    public static List<URL> getAppLibDirLibrariesAsList(File appRoot, String appLibDir, String compatibilityProp) throws IOException {
        URL[] libDirLibraries = new URL[]{};
        if (appLibDir != null) {
            String libPath = appLibDir.replace('/', File.separatorChar);
            libDirLibraries = ASClassLoaderUtil.getURLs(null, new File[]{new File(appRoot, libPath)}, true);
        }
        ArrayList<URL> allLibDirLibraries = new ArrayList<URL>();
        for (URL url : libDirLibraries) {
            allLibDirLibraries.add(url);
        }
        if (compatibilityProp != null && compatibilityProp.equals("v2")) {
            List<URL> appRootLibraries = ASClassLoaderUtil.getURLsAsList(null, new File[]{appRoot}, true);
            allLibDirLibraries.addAll(appRootLibraries);
        }
        return allLibDirLibraries;
    }

    public static List<URI> getLibDirectoryJarURIs(File moduleLibDirectory) throws Exception {
        ArrayList<URI> libLibraryURIs = new ArrayList<URI>();
        File[] jarFiles = moduleLibDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".jar");
            }
        });
        if (jarFiles != null && jarFiles.length > 0) {
            for (File jarFile : jarFiles) {
                libLibraryURIs.add(Util.toURI(jarFile.toURL()));
            }
        }
        return libLibraryURIs;
    }
}

