/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.el;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class PermissionChecker {
    public static final BooleanFunction FALSE_BOOLEAN_FUNCTION = new BooleanFunction(false);
    public static final BooleanFunction TRUE_BOOLEAN_FUNCTION = new BooleanFunction(true);
    protected static final char POST_TRUE = 't';
    protected static final char POST_FALSE = 'f';
    protected static final char POST_TRUE_CAP = 'T';
    protected static final char POST_FALSE_CAP = 'F';
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final char FUNCTION_MARKER = 'F';
    public static final char LEFT_PAREN = '(';
    public static final char RIGHT_PAREN = ')';
    public static final char EQUALS_OPERATOR = '=';
    public static final char OR_OPERATOR = '|';
    public static final char AND_OPERATOR = '&';
    public static final char NOT_OPERATOR = '!';
    public static final char LESS_THAN_OPERATOR = '<';
    public static final char MORE_THAN_OPERATOR = '>';
    public static final char MODULUS_OPERATOR = '%';
    public static final char DIVIDE_OPERATOR = '/';
    public static final char ARGUMENT_SEPARATOR = ',';
    private static final String PERMISSION_FUNCTIONS = "__jsft_permFuncs";
    private String _infixStr;
    private char[] _postfixArr;
    private List<Function> _functionList;
    private LayoutElement _desc;
    private UIComponent _component;

    public PermissionChecker(LayoutElement desc, UIComponent component, String infixStr) {
        if (infixStr == null) {
            infixStr = FALSE;
        }
        this.setLayoutElement(desc);
        this.setUIComponent(component);
        this.setInfix(PermissionChecker.stripWhiteSpace(infixStr));
    }

    protected void setUIComponent(UIComponent component) {
        this._component = component;
    }

    public UIComponent getUIComponent() {
        return this._component;
    }

    protected void setLayoutElement(LayoutElement desc) {
        this._desc = desc;
    }

    public LayoutElement getLayoutElement() {
        return this._desc;
    }

    private static int getPrecedence(char op) {
        switch (op) {
            case '(': {
                return 1;
            }
            case ')': {
                return 999;
            }
            case '=': {
                return 2;
            }
            case '<': 
            case '>': {
                return 4;
            }
            case '|': {
                return 8;
            }
            case '&': {
                return 16;
            }
            case '%': 
            case '/': {
                return 32;
            }
            case '!': {
                return 64;
            }
        }
        return 1;
    }

    protected char[] preProcessString(String source) {
        char[] arr = source.toCharArray();
        int sourceLen = arr.length;
        int destLen = 0;
        block5: for (int idx = 0; idx < sourceLen; ++idx) {
            switch (arr[idx]) {
                case 'T': 
                case 't': {
                    if (idx + TRUE.length() <= sourceLen && TRUE.equalsIgnoreCase(new String(arr, idx, TRUE.length()))) {
                        arr[destLen++] = 116;
                        idx += TRUE.length() - 1;
                        continue block5;
                    }
                    idx = this.storeFunction(arr, idx);
                    arr[destLen++] = 70;
                    continue block5;
                }
                case 'F': 
                case 'f': {
                    if (idx + FALSE.length() <= sourceLen && FALSE.equalsIgnoreCase(new String(arr, idx, FALSE.length()))) {
                        arr[destLen++] = 102;
                        idx += FALSE.length() - 1;
                        continue block5;
                    }
                    idx = this.storeFunction(arr, idx);
                    arr[destLen++] = 70;
                    continue block5;
                }
                case '!': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    arr[destLen++] = arr[idx];
                    continue block5;
                }
                default: {
                    idx = this.storeFunction(arr, idx);
                    arr[destLen++] = 70;
                }
            }
        }
        char[] dest = new char[destLen];
        for (int idx = 0; idx < destLen; ++idx) {
            dest[idx] = arr[idx];
        }
        return dest;
    }

    protected int storeFunction(char[] arr, int idx) {
        int start = idx;
        int len = arr.length;
        while (idx < len && !PermissionChecker.isOperator(arr[idx])) {
            ++idx;
        }
        String str = new String(arr, start, idx - start);
        Function function = PermissionChecker.getFunction(str);
        if (function != null) {
            int left = idx;
            if (left >= len || arr[left] != '(') {
                throw new RuntimeException("Function '" + str + "' is expected to have a '" + '(' + "' immediately following it.  Equation: '" + new String(arr) + "'.");
            }
            ArrayList<String> arguments = new ArrayList<String>();
            while (++idx < len && arr[idx] != ')') {
                if (arr[idx] != ',') continue;
                arguments.add(new String(arr, ++left, idx - left));
                left = idx;
            }
            if (idx > ++left) {
                arguments.add(new String(arr, left, idx - left));
            }
            function.setArguments(arguments);
        } else {
            --idx;
            function = new StringFunction(str);
        }
        this._functionList.add(function);
        return idx;
    }

    private static Map<String, Class> getFunctions(FacesContext ctx) {
        Map<String, Class<Object>> funcs = null;
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        if (ctx != null) {
            Map appMap = ctx.getExternalContext().getApplicationMap();
            funcs = (Map)appMap.get(PERMISSION_FUNCTIONS);
            if (funcs == null) {
                funcs = new HashMap();
            }
        } else {
            funcs = new HashMap<String, Class>();
        }
        return funcs;
    }

    private static void setFunctions(FacesContext ctx, Map<String, Class> map) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        if (ctx != null) {
            ctx.getExternalContext().getApplicationMap().put(PERMISSION_FUNCTIONS, map);
        }
    }

    protected static Function getFunction(String functionName) {
        Class functionClass = PermissionChecker.getFunctions(null).get(functionName);
        if (functionClass == null) {
            return null;
        }
        Function function = null;
        try {
            function = (Function)functionClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to instantiate '" + functionClass.getName() + "' for '" + functionName + "'", ex);
        }
        return function;
    }

    public static void registerFunction(String functionName, Class function) {
        HashMap<String, Class> newFuncs = new HashMap<String, Class>(PermissionChecker.getFunctions(null));
        if (function == null) {
            newFuncs.remove(functionName);
        } else {
            if (!Function.class.isAssignableFrom(function)) {
                throw new RuntimeException("'" + function.getName() + "' must implement '" + Function.class.getName() + "'");
            }
            newFuncs.put(functionName, function);
        }
        PermissionChecker.setFunctions(null, newFuncs);
    }

    public static boolean isOperator(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    protected char[] generatePostfix(String infixStr) {
        this._functionList = new ArrayList<Function>();
        char[] result = this.preProcessString(infixStr);
        int resultLen = result.length;
        int postIdx = 0;
        int precedence = 0;
        Stack<Character> opStack = new Stack<Character>();
        block5: for (int idx = 0; idx < resultLen; ++idx) {
            switch (result[idx]) {
                case 'F': 
                case 'f': 
                case 't': {
                    result[postIdx++] = result[idx];
                    continue block5;
                }
                case '(': {
                    opStack.push(new Character('('));
                    continue block5;
                }
                case ')': {
                    while (!opStack.empty() && ((Character)opStack.peek()).charValue() != '(') {
                        result[postIdx++] = ((Character)opStack.pop()).charValue();
                    }
                    if (opStack.empty()) continue block5;
                    opStack.pop();
                    continue block5;
                }
                default: {
                    precedence = PermissionChecker.getPrecedence(result[idx]);
                    while (!opStack.empty() && PermissionChecker.getPrecedence(((Character)opStack.peek()).charValue()) >= precedence) {
                        result[postIdx++] = ((Character)opStack.pop()).charValue();
                    }
                    opStack.push(new Character(result[idx]));
                }
            }
        }
        while (!opStack.empty()) {
            result[postIdx++] = ((Character)opStack.pop()).charValue();
        }
        char[] postfixStr = new char[postIdx];
        for (int idx = 0; idx < postIdx; ++idx) {
            postfixStr[idx] = result[idx];
        }
        return postfixStr;
    }

    public boolean hasPermission() {
        boolean val1;
        char[] postfixArr = this.getPostfixArr();
        int len = postfixArr.length;
        Stack<Function> result = new Stack<Function>();
        result.push(FALSE_BOOLEAN_FUNCTION);
        Iterator<Function> it = this._functionList.iterator();
        block31: for (int idx = 0; idx < len; ++idx) {
            switch (postfixArr[idx]) {
                case 't': {
                    result.push(TRUE_BOOLEAN_FUNCTION);
                    continue block31;
                }
                case 'f': {
                    result.push(FALSE_BOOLEAN_FUNCTION);
                    continue block31;
                }
                case 'F': {
                    if (!it.hasNext()) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "' -- found function marker w/o cooresponding function!");
                    }
                    result.push(it.next());
                    continue block31;
                }
                case '=': {
                    try {
                        String matchStr = result.pop().toString();
                        val1 = result.pop().toString().matches(matchStr);
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(val1 ? TRUE_BOOLEAN_FUNCTION : FALSE_BOOLEAN_FUNCTION);
                    continue block31;
                }
                case '<': {
                    try {
                        val1 = Integer.parseInt(result.pop().toString()) > Integer.parseInt(result.pop().toString());
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(val1 ? TRUE_BOOLEAN_FUNCTION : FALSE_BOOLEAN_FUNCTION);
                    continue block31;
                }
                case '>': {
                    try {
                        val1 = Integer.parseInt(result.pop().toString()) < Integer.parseInt(result.pop().toString());
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(val1 ? TRUE_BOOLEAN_FUNCTION : FALSE_BOOLEAN_FUNCTION);
                    continue block31;
                }
                case '%': {
                    int num;
                    try {
                        int modNumber = Integer.parseInt(result.pop().toString());
                        num = Integer.parseInt(result.pop().toString());
                        result.push(new StringFunction("" + num % modNumber));
                        continue block31;
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                }
                case '/': {
                    int num;
                    try {
                        int divNumber = Integer.parseInt(result.pop().toString());
                        num = Integer.parseInt(result.pop().toString());
                        result.push(new StringFunction("" + num / divNumber));
                        continue block31;
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                }
                case '|': {
                    boolean val2;
                    try {
                        val1 = ((Function)result.pop()).evaluate();
                        val2 = ((Function)result.pop()).evaluate();
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(val1 || val2 ? TRUE_BOOLEAN_FUNCTION : FALSE_BOOLEAN_FUNCTION);
                    continue block31;
                }
                case '&': {
                    boolean val2;
                    try {
                        val1 = ((Function)result.pop()).evaluate();
                        val2 = ((Function)result.pop()).evaluate();
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(val1 && val2 ? TRUE_BOOLEAN_FUNCTION : FALSE_BOOLEAN_FUNCTION);
                    continue block31;
                }
                case '!': {
                    try {
                        val1 = ((Function)result.pop()).evaluate();
                    }
                    catch (EmptyStackException ex) {
                        throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(!val1 ? TRUE_BOOLEAN_FUNCTION : FALSE_BOOLEAN_FUNCTION);
                }
            }
        }
        try {
            val1 = ((Function)result.pop()).evaluate();
        }
        catch (EmptyStackException ex) {
            throw new RuntimeException("Unable to evaluate: '" + this.toString() + "'.", ex);
        }
        if (!result.empty()) {
            result.pop();
            if (!result.empty()) {
                throw new RuntimeException("Unable to evaluate: '" + this.toString() + "' -- values left on the stack.");
            }
        }
        return val1;
    }

    public String getInfix() {
        return this._infixStr;
    }

    public void setInfix(String equation) {
        this._infixStr = equation;
        this.setPostfixArr(this.generatePostfix(equation));
    }

    protected char[] getPostfixArr() {
        if (this._postfixArr == null) {
            this._postfixArr = new char[]{' '};
        }
        return this._postfixArr;
    }

    protected void setPostfixArr(char[] postfix) {
        this._postfixArr = postfix;
    }

    public String getPostfix() {
        if (this.getPostfixArr() == null) {
            return "";
        }
        return new String(this.getPostfixArr());
    }

    public String toString() {
        return this._infixStr + " = " + this.toString(this.getPostfixArr());
    }

    private String toString(char[] post) {
        int len = post.length;
        StringBuffer result = new StringBuffer("");
        Iterator<Function> it = this._functionList.iterator();
        block5: for (int idx = 0; idx < len; ++idx) {
            switch (post[idx]) {
                case 't': {
                    result.append(TRUE);
                    continue block5;
                }
                case 'f': {
                    result.append(FALSE);
                    continue block5;
                }
                case 'F': {
                    result.append(it.next().toString());
                    continue block5;
                }
                default: {
                    result.append(post[idx]);
                }
            }
        }
        return result.toString();
    }

    public static String stripWhiteSpace(String input) {
        char[] arr = input.toCharArray();
        int len = arr.length;
        int destLen = 0;
        for (int idx = 0; idx < len; ++idx) {
            if (Character.isWhitespace(arr[idx])) continue;
            arr[destLen++] = arr[idx];
        }
        return new String(arr, 0, destLen);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (int count = 0; count < args.length; ++count) {
                PermissionChecker checker = new PermissionChecker(null, null, args[count]);
                System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            }
        } else {
            boolean success = true;
            PermissionChecker checker = new PermissionChecker(null, null, "false|false");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false|false = falsefalse|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue|false = truefalse|");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "true |false");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true|false = truefalse|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue|false = truefalse|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "true&(false|true)");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true&(false|true) = truefalsetrue|&")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue&(false|true) = truefalsetrue|&");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "true&false|true");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true&false|true = truefalse&true|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue&false|true = truefalse&true|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "true&true|false&true");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true&true|false&true = truetrue&falsetrue&|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue&true|false&true = truetrue&falsetrue&|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "!true|false&!(false|true)");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("!true|false&!(false|true) = true!falsefalsetrue|!&|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n!true|false&!(false|true) = true!falsefalsetrue|!&|");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "!(!(true&!true)|!(false|false))|(true|false)&true");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("!(!(true&!true)|!(false|false))|(true|false)&true = truetrue!&!falsefalse|!|!truefalse|true&|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n!(!(true&!true)|!(false|false))|(true|false)&true = truetrue!&!falsefalse|!|!truefalse|true&|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "false =false");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false=false = falsefalse=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse=false = falsefalse=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, " test= me ");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("test=me = testme=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntest=me = testme=");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, " this should work=thisshouldwork");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("thisshouldwork=thisshouldwork = thisshouldworkthisshouldwork=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nthisshouldwork=thisshouldwork = thisshouldworkthisshouldwork=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "false|ab=true");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false|ab=true = falseab|true=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse|ab=true = falseab|true=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "false|(ab=true)");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false|(ab=true) = falseabtrue=|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse|ab=true = falseab|true=");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "false|(ab=ab)");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false|(ab=ab) = falseabab=|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse|ab=true = falseab|true=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "!");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("! = !")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n! = !");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals(" = ")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n = ");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "!$escape{}");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("!$escape{} = !")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n! = !");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(null, null, "$escape{}");
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("$escape{} = ")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n = ");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            if (success) {
                System.out.println("\n\tALL TESTS PASSED!");
            } else {
                System.out.println("\n\tNOT ALL TESTS PASSED!");
            }
        }
    }

    protected static class BooleanFunction
    implements Function {
        private boolean _value = false;

        public BooleanFunction() {
        }

        public BooleanFunction(boolean value) {
            this._value = value;
        }

        @Override
        public List<String> getArguments() {
            return null;
        }

        @Override
        public void setArguments(List<String> args) {
        }

        @Override
        public boolean evaluate() {
            return this._value;
        }

        public String toString() {
            return this._value ? PermissionChecker.TRUE : PermissionChecker.FALSE;
        }
    }

    protected class StringFunction
    implements Function {
        private String _value;

        public StringFunction(String value) {
            this._value = value;
        }

        @Override
        public List<String> getArguments() {
            return null;
        }

        @Override
        public void setArguments(List<String> args) {
        }

        @Override
        public boolean evaluate() {
            Object obj = this.getEvaluatedValue();
            if (obj == null) {
                return false;
            }
            if ((obj = obj.toString()).equals("")) {
                return false;
            }
            return !((String)obj).equalsIgnoreCase(PermissionChecker.FALSE);
        }

        public Object getEvaluatedValue() {
            FacesContext ctx = FacesContext.getCurrentInstance();
            return ComponentUtil.getInstance(ctx).resolveValue(ctx, PermissionChecker.this.getLayoutElement(), PermissionChecker.this.getUIComponent(), this._value);
        }

        public String toString() {
            Object obj = this.getEvaluatedValue();
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
    }

    public static interface Function {
        public List<String> getArguments();

        public void setArguments(List<String> var1);

        public boolean evaluate();
    }
}

