/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.faces.annotation.Resolver;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.faces.component.UIComponent;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Resolver
public final class UIComponentELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        UIComponentELResolver.log("getValue(ctx, " + base + "," + property + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null) {
            UIComponentELResolver.log("argument is null or not of applicable type. returning");
            return null;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        UIComponent kid = (UIComponent)component.getFacets().get(id);
        if (kid != null) {
            context.setPropertyResolved(true);
            UIComponentELResolver.log("returning facet " + kid);
            return kid;
        }
        if (component.getChildCount() < 1) {
            UIComponentELResolver.log("child count less than 1. returning");
            return null;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            context.setPropertyResolved(true);
            UIComponentELResolver.log("returning child " + kid);
            return kid;
        }
        UIComponentELResolver.log("can't resolve. returning");
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        UIComponentELResolver.log("setValue(ctx, " + base + "," + property + "," + value + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null || value == null || !(value instanceof UIComponent)) {
            UIComponentELResolver.log("argument is null or not of applicable type. returning");
            return;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            component.getFacets().put(id, (UIComponent)value);
            context.setPropertyResolved(true);
            UIComponentELResolver.log("set facet");
            return;
        }
        if (component.getChildCount() < 1) {
            UIComponentELResolver.log("child count less than 1. returning");
            return;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            kids.set(i, (UIComponent)value);
            context.setPropertyResolved(true);
            UIComponentELResolver.log("set child");
            return;
        }
        UIComponentELResolver.log("can't resolve. returning");
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        UIComponentELResolver.log("isReadOnly(ctx, " + base + "," + property + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null) {
            UIComponentELResolver.log("argument is null or not of applicable type. returning");
            return false;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            context.setPropertyResolved(true);
            UIComponentELResolver.log("not read-only. found facet");
            return false;
        }
        if (component.getChildCount() < 1) {
            UIComponentELResolver.log("child count less than 1. returning");
            return false;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            context.setPropertyResolved(true);
            UIComponentELResolver.log("not read-only. found child");
            return false;
        }
        UIComponentELResolver.log("can't resolve. returning");
        return false;
    }

    public Class getType(ELContext context, Object base, Object property) {
        UIComponentELResolver.log("getType(ctx, " + base + "," + property + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null) {
            UIComponentELResolver.log("argument is null or not of applicable type. returning");
            return null;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            context.setPropertyResolved(true);
            UIComponentELResolver.log("found facet. returning UIComponent.class");
            return UIComponent.class;
        }
        if (component.getChildCount() < 1) {
            UIComponentELResolver.log("child count less than 1. returning");
            return null;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            context.setPropertyResolved(true);
            UIComponentELResolver.log("found child. returning UIComponent.class");
            return UIComponent.class;
        }
        UIComponentELResolver.log("can't resolve. returning");
        return null;
    }

    private static void log(String message) {
        if (LogUtil.finestEnabled(UIComponentELResolver.class)) {
            LogUtil.finest(UIComponentELResolver.class, message);
        }
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        UIComponentELResolver.log("getFeatureDescriptors(ctx, " + base + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return Arrays.asList(new FeatureDescriptor[0]).iterator();
        }
        if (!(base instanceof UIComponent)) {
            return null;
        }
        ArrayList<FeatureDescriptor> result = new ArrayList<FeatureDescriptor>();
        UIComponent baseUic = (UIComponent)base;
        Iterator facetsAndChildren = baseUic.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent kid = (UIComponent)facetsAndChildren.next();
            FeatureDescriptor desc = new FeatureDescriptor();
            String kidId = kid.getId();
            desc.setName(kidId);
            desc.setDisplayName(kidId);
            desc.setValue("type", String.class);
            desc.setValue("resolvableAtDesignTime", true);
            result.add(desc);
        }
        return result.iterator();
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        UIComponentELResolver.log("getCommonPropertyType(ctx, " + base + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (!(base instanceof UIComponent)) {
            return null;
        }
        return String.class;
    }
}

