/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import jakarta.el.ELProcessor;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.CdiUtils;

public class AnnotationELPProcessor {
    public static String evalImmediate(String expression) {
        return AnnotationELPProcessor.evalImmediate((ELProcessor)null, expression);
    }

    public static String evalImmediate(ELProcessor getELProcessor, String expression) {
        if (!AnnotationELPProcessor.isELExpression(expression) || AnnotationELPProcessor.isDeferredExpression(expression)) {
            return expression;
        }
        return (String)CdiUtils.getELProcessor(getELProcessor).eval(AnnotationELPProcessor.toRawExpression(expression));
    }

    public static boolean evalImmediate(String expression, boolean defaultValue) {
        return AnnotationELPProcessor.evalImmediate(null, expression, defaultValue);
    }

    public static boolean evalImmediate(ELProcessor getELProcessor, String expression, boolean defaultValue) {
        if (!AnnotationELPProcessor.isELExpression(expression) || AnnotationELPProcessor.isDeferredExpression(expression)) {
            return defaultValue;
        }
        Object outcome = CdiUtils.getELProcessor(getELProcessor).eval(AnnotationELPProcessor.toRawExpression(expression));
        if (outcome instanceof Boolean) {
            return (Boolean)outcome;
        }
        throw new IllegalStateException(AnnotationELPProcessor.buildNonBooleanOutcomeMessage(outcome, expression));
    }

    static String buildNonBooleanOutcomeMessage(Object outcome, String expression) {
        return "Expression " + expression + " should evaluate to boolean but evaluated to " + (outcome == null ? " null" : outcome.getClass() + " " + outcome);
    }

    public static int evalImmediate(String expression, int defaultValue) {
        return AnnotationELPProcessor.evalImmediate(null, expression, defaultValue);
    }

    public static int evalImmediate(ELProcessor getELProcessor, String expression, int defaultValue) {
        if (!AnnotationELPProcessor.isELExpression(expression) || AnnotationELPProcessor.isDeferredExpression(expression)) {
            return defaultValue;
        }
        return (Integer)CdiUtils.getELProcessor(getELProcessor).getValue(AnnotationELPProcessor.toRawExpression(expression), Integer.class);
    }

    public static <T> T evalImmediate(String expression, T defaultValue) {
        if (!AnnotationELPProcessor.isELExpression(expression) || AnnotationELPProcessor.isDeferredExpression(expression)) {
            return defaultValue;
        }
        return (T)CdiUtils.getELProcessor(CdiUtils.getELProcessor(null)).eval(AnnotationELPProcessor.toRawExpression(expression));
    }

    public static String emptyIfImmediate(String expression) {
        return AnnotationELPProcessor.isImmediateExpression(expression) ? "" : expression;
    }

    public static String evalELExpression(String expression) {
        return AnnotationELPProcessor.evalELExpression((ELProcessor)null, expression);
    }

    public static String evalELExpression(ELProcessor getELProcessor, String expression) {
        if (!AnnotationELPProcessor.isELExpression(expression)) {
            return expression;
        }
        return (String)CdiUtils.getELProcessor(getELProcessor).eval(AnnotationELPProcessor.toRawExpression(expression));
    }

    public static boolean evalELExpression(String expression, boolean defaultValue) {
        return AnnotationELPProcessor.evalELExpression(null, expression, defaultValue);
    }

    public static boolean evalELExpression(ELProcessor getELProcessor, String expression, boolean defaultValue) {
        if (!AnnotationELPProcessor.isELExpression(expression)) {
            return defaultValue;
        }
        return (Boolean)CdiUtils.getELProcessor(getELProcessor).eval(AnnotationELPProcessor.toRawExpression(expression));
    }

    public static <T> T evalELExpression(String expression, T defaultValue) {
        return AnnotationELPProcessor.evalELExpression(null, expression, defaultValue);
    }

    public static <T> T evalELExpression(ELProcessor getELProcessor, String expression, T defaultValue) {
        if (!AnnotationELPProcessor.isELExpression(expression)) {
            return defaultValue;
        }
        Object outcome = CdiUtils.getELProcessor(getELProcessor).eval(AnnotationELPProcessor.toRawExpression(expression));
        if (defaultValue instanceof Enum && outcome instanceof String) {
            Enum defaultValueEnum = (Enum)defaultValue;
            Object enumConstant = Enum.valueOf(defaultValueEnum.getClass(), (String)outcome);
            return (T)enumConstant;
        }
        if (defaultValue instanceof Enum[] && outcome instanceof String) {
            Enum[] defaultValueEnum = (Enum[])defaultValue;
            Object enumConstant = Enum.valueOf(defaultValueEnum.getClass().getComponentType(), (String)outcome);
            Enum[] outcomeArray = (Enum[])Array.newInstance(defaultValueEnum.getClass().getComponentType(), 1);
            outcomeArray[0] = enumConstant;
            return (T)outcomeArray;
        }
        return (T)outcome;
    }

    public static int evalELExpression(String expression, int defaultValue) {
        return AnnotationELPProcessor.evalELExpression(null, expression, defaultValue);
    }

    public static int evalELExpression(ELProcessor getELProcessor, String expression, int defaultValue) {
        if (!AnnotationELPProcessor.isELExpression(expression)) {
            return defaultValue;
        }
        return (Integer)CdiUtils.getELProcessor(getELProcessor).getValue(AnnotationELPProcessor.toRawExpression(expression), Integer.class);
    }

    @SafeVarargs
    public static boolean hasAnyELExpression(String ... expressions) {
        return Arrays.stream(expressions).anyMatch(expr -> AnnotationELPProcessor.isELExpression(expr));
    }

    private static boolean isELExpression(String expression) {
        return !Utils.isEmpty(expression) && (AnnotationELPProcessor.isDeferredExpression(expression) || AnnotationELPProcessor.isImmediateExpression(expression));
    }

    private static boolean isDeferredExpression(String expression) {
        return expression.startsWith("#{") && expression.endsWith("}");
    }

    private static boolean isImmediateExpression(String expression) {
        return expression.startsWith("${") && expression.endsWith("}");
    }

    private static String toRawExpression(String expression) {
        return expression.substring(2, expression.length() - 1);
    }
}

