/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json.jaxrs;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
@Consumes(value={"application/json", "text/json", "*/*"})
public class JsonValueBodyReader
implements MessageBodyReader<JsonValue> {
    private final JsonReaderFactory rf = Json.createReaderFactory(null);
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonValue.class.isAssignableFrom(aClass) && JsonValueBodyReader.supportsMediaType(mediaType);
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    public JsonValue readFrom(Class<JsonValue> jsonValueClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> stringStringMultivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        try (JsonReader reader = this.rf.createReader(inputStream);){
            JsonValue jsonValue = reader.readValue();
            return jsonValue;
        }
    }
}

