/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.webapp.UIComponentClassicTagBase;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionListenerTag
extends TagSupport {
    private static final long serialVersionUID = -5222351612904952740L;
    private static final Logger logger = FacesLogger.TAGLIB.getLogger();
    private ValueExpression type = null;
    private ValueExpression binding = null;

    public void setType(ValueExpression type) {
        this.type = type;
    }

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }

    public int doStartTag() throws JspException {
        ActionListener listener;
        UIComponentClassicTagBase tag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase(this.pageContext);
        if (tag == null) {
            Object[] params = new Object[]{((Object)((Object)this)).getClass().getName()};
            throw new JspException(MessageUtils.getExceptionMessageString("com.sun.faces.NOT_NESTED_IN_FACES_TAG_ERROR", params));
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_COMPONENT_ERROR", new Object[0]));
        }
        if (!(component instanceof ActionSource)) {
            throw new JspException(MessageUtils.getExceptionMessageString("com.sun.faces.NOT_NESTED_IN_TYPE_TAG_ERROR", "actionListener", "jakarta.faces.component.ActionSource"));
        }
        if (this.binding == null && this.type != null && this.type.isLiteralText()) {
            try {
                listener = (ActionListener)Util.getListenerInstance(this.type, null);
            }
            catch (Exception e) {
                throw new JspException(e.getMessage(), e.getCause());
            }
        } else {
            listener = new BindingActionListener(this.type, this.binding);
        }
        ((ActionSource)((Object)component)).addActionListener(listener);
        return 0;
    }

    public void release() {
        this.type = null;
    }

    private static class BindingActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -718826166288464533L;
        private ValueExpression type;
        private ValueExpression binding;

        public BindingActionListener(ValueExpression type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        @Override
        public void processAction(ActionEvent event) throws AbortProcessingException {
            ActionListener instance = (ActionListener)Util.getListenerInstance(this.type, this.binding);
            if (instance != null) {
                instance.processAction(event);
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "jsf.core.taglib.action_or_valuechange_listener.null_type_binding", new Object[]{"ActionListener", event.getComponent().getClientId(FacesContext.getCurrentInstance())});
            }
        }
    }
}

