/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt.transport.grizzly;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.base.PeerID;
import org.glassfish.shoal.gms.mgmt.transport.Message;
import org.glassfish.shoal.gms.mgmt.transport.MessageEvent;
import org.glassfish.shoal.gms.mgmt.transport.MessageIOException;
import org.glassfish.shoal.gms.mgmt.transport.MessageImpl;
import org.glassfish.shoal.gms.mgmt.transport.MessageListener;
import org.glassfish.shoal.gms.mgmt.transport.NetworkManager;
import org.glassfish.shoal.gms.mgmt.transport.grizzly.GrizzlyNetworkManager;

public class PingMessageListener
implements MessageListener {
    private static final Logger LOG = GrizzlyNetworkManager.getLogger();

    @Override
    public void receiveMessageEvent(MessageEvent event) throws MessageIOException {
        block8: {
            if (event == null) {
                return;
            }
            Message msg = event.getMessage();
            if (msg == null) {
                return;
            }
            Object obj = event.getSource();
            if (!(obj instanceof NetworkManager)) {
                return;
            }
            NetworkManager networkManager = (NetworkManager)obj;
            PeerID sourcePeerId = event.getSourcePeerID();
            if (sourcePeerId == null) {
                return;
            }
            PeerID targetPeerId = event.getTargetPeerID();
            if (targetPeerId == null) {
                return;
            }
            if (networkManager.getLocalPeerID().equals(targetPeerId)) {
                try {
                    networkManager.send(sourcePeerId, new MessageImpl(6));
                }
                catch (IOException ie) {
                    if (!LOG.isLoggable(Level.WARNING)) break block8;
                    LOG.log(Level.WARNING, "failed to send a pong message", ie);
                }
            }
        }
    }

    @Override
    public int getType() {
        return 5;
    }
}

