/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.ThreadPool;
import com.sun.corba.ee.spi.threadpool.ThreadPoolManager;
import com.sun.enterprise.connectors.work.LogFacade;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.connectors.work.context.WorkContextHandlerImpl;
import com.sun.enterprise.connectors.work.monitor.WorkManagementProbeProvider;
import com.sun.enterprise.connectors.work.monitor.WorkManagementStatsProvider;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import jakarta.resource.spi.work.WorkRejectedException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.util.S1ASThreadPoolManager;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class CommonWorkManager
implements WorkManager {
    private ThreadPoolManager tpm;
    private ThreadPool tp;
    private static final Logger logger = LogFacade.getLogger();
    private WorkManagementProbeProvider probeProvider = null;
    private WorkManagementStatsProvider statsProvider = null;
    private String dottedNamesHierarchy;
    private ConnectorRuntime runtime;
    private String raName;
    private ClassLoader rarClassLoader;
    @LogMessageInfo(message="Failed to get the thread-pool [ {0} ] for resource adapter [ {1} ].", comment="Failed to find thread pool", level="SEVERE", cause="Could not find a thread pool according to the pool ID.", action="Check the thread-pool-id property in Resource Adapter Config.", publish=true)
    private static final String RAR_THREAD_POOL_NOT_FOUND = "AS-RAR-05001";
    @LogMessageInfo(message="Failed to get the default thread-pool for resource adapter [ {0} ].", comment="Failed to find the default thread pool.", level="SEVERE", cause="Could not find the default thread pool for resource adatper.", action="Check the thread-pool-id property in Resource Adapter Config.", publish=true)
    private static final String RAR_DEFAULT_THREAD_POOL_NOT_FOUND = "AS-RAR-05002";

    public CommonWorkManager(String threadPoolId, ConnectorRuntime runtime, String raName, ClassLoader cl) throws ConnectorRuntimeException {
        if (runtime.isServer() || runtime.isEmbedded()) {
            this.runtime = runtime;
            this.raName = raName;
            this.rarClassLoader = cl;
            this.tpm = S1ASThreadPoolManager.getThreadPoolManager();
            if (threadPoolId == null || threadPoolId.isEmpty()) {
                this.tp = this.tpm.getDefaultThreadPool();
            } else {
                try {
                    this.tp = this.tpm.getThreadPool(threadPoolId);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Got the thread pool [ " + threadPoolId + " ] for WorkManager of RAR [ " + raName + " ]");
                    }
                }
                catch (NoSuchThreadPoolException e) {
                    logger.log(Level.SEVERE, RAR_THREAD_POOL_NOT_FOUND, new Object[]{threadPoolId, raName});
                    ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                    cre.initCause((Throwable)e);
                    throw cre;
                }
            }
            if (this.tp == null) {
                Object format = null;
                format = logger.getResourceBundle().getString(RAR_DEFAULT_THREAD_POOL_NOT_FOUND);
                format = ((String)format).trim().equals("") ? "Failed to get the default thread-pool for resource adapter " + raName + "." : MessageFormat.format((String)format, raName);
                ConnectorRuntimeException cre = new ConnectorRuntimeException((String)format);
                logger.log(Level.SEVERE, RAR_DEFAULT_THREAD_POOL_NOT_FOUND, raName);
                throw cre;
            }
            this.registerWithMonitoringService();
        }
    }

    private void registerWithMonitoringService() {
        if (ConnectorsUtil.belongsToSystemRA((String)this.raName) && !ConnectorsUtil.isJMSRA((String)this.raName)) {
            return;
        }
        this.probeProvider = new WorkManagementProbeProvider();
        String monitoringModuleName = "connector-service";
        if (ConnectorsUtil.isJMSRA((String)this.raName)) {
            this.dottedNamesHierarchy = "jms-service/work-management";
            monitoringModuleName = "jms-service";
        } else {
            this.dottedNamesHierarchy = "connector-service/" + this.raName + "/work-management";
        }
        this.statsProvider = new WorkManagementStatsProvider(this.raName);
        StatsProviderManager.register((String)monitoringModuleName, (PluginPoint)PluginPoint.SERVER, (String)this.dottedNamesHierarchy, (Object)this.statsProvider);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Registered work-monitoring stats [ " + this.dottedNamesHierarchy + " ]  for [ " + this.raName + " ] with monitoring-stats-registry.");
        }
    }

    private void deregisterFromMonitoringService() {
        if (ConnectorsUtil.belongsToSystemRA((String)this.raName) && !ConnectorsUtil.isJMSRA((String)this.raName)) {
            return;
        }
        if (this.statsProvider != null) {
            StatsProviderManager.unregister((Object)this.statsProvider);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "De-registered work-monitoring stats [ " + this.dottedNamesHierarchy + " ]  for [ " + this.raName + " ] from monitoring-stats-registry.");
            }
        }
    }

    public void cleanUp() {
        if (this.runtime != null && this.runtime.isServer()) {
            this.deregisterFromMonitoringService();
        }
    }

    @Override
    public void doWork(Work work) throws WorkException {
        this.doWork(work, -1L, null, null);
    }

    @Override
    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkContextHandlerImpl contextHandler = this.createWorkContextHandler();
        this.validateWork(work, WorkCoordinator.getExecutionContext(execContext, work), contextHandler);
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "doWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, msg);
        }
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.probeProvider, this.runtime, this.raName, contextHandler);
        wc.submitWork(2);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "doWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, msg);
        }
    }

    @Override
    public long startWork(Work work) throws WorkException {
        return this.startWork(work, -1L, null, null);
    }

    @Override
    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkContextHandlerImpl contextHandler = this.createWorkContextHandler();
        this.validateWork(work, WorkCoordinator.getExecutionContext(execContext, work), contextHandler);
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "startWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, msg);
        }
        long acceptanceTime = System.currentTimeMillis();
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.probeProvider, this.runtime, this.raName, contextHandler);
        wc.submitWork(1);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "startWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, msg);
        }
        long startTime = System.currentTimeMillis();
        return startTime - acceptanceTime;
    }

    private WorkContextHandlerImpl createWorkContextHandler() {
        WorkContextHandlerImpl contextHandler = new WorkContextHandlerImpl(this.runtime, this.rarClassLoader);
        return contextHandler;
    }

    @Override
    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, -1L, null, null);
    }

    @Override
    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkContextHandlerImpl contextHandler = this.createWorkContextHandler();
        this.validateWork(work, WorkCoordinator.getExecutionContext(execContext, work), contextHandler);
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "scheduleWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, msg);
        }
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.probeProvider, this.runtime, this.raName, contextHandler);
        wc.submitWork(3);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "scheduleWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, msg);
        }
    }

    private void validateWork(Work workToBeValidated, ExecutionContext context, WorkContextHandlerImpl contextHandler) throws WorkCompletedException, WorkRejectedException {
        contextHandler.validateWork(workToBeValidated, context);
    }
}

