/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.JobManagerService;
import jakarta.inject.Inject;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.services.common.SubjectUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="attach")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="attach")
@ManagedJob
@AccessRequired(resource={"jobs/job/$jobID"}, action={"attach"})
public class AttachCommand
implements AdminCommand,
AdminCommandEventBroker.AdminCommandListener {
    public static final String COMMAND_NAME = "attach";
    protected static final LocalStringManagerImpl strings = new LocalStringManagerImpl(AttachCommand.class);
    protected AdminCommandEventBroker eventBroker;
    protected Job attached;
    @Inject
    JobManagerService registry;
    @Param(primary=true, optional=false, multiple=false)
    protected String jobID;

    public void execute(AdminCommandContext context) {
        this.eventBroker = context.getEventBroker();
        this.attached = this.registry.get(this.jobID);
        JobInfo jobInfo = null;
        String jobName = null;
        if (this.attached == null) {
            if (this.registry.getCompletedJobs(this.registry.getJobsFile()) != null) {
                jobInfo = this.registry.getCompletedJobForId(this.jobID);
            }
            if (jobInfo != null) {
                jobName = jobInfo.jobName;
            }
        }
        this.attach(this.attached, jobInfo, context, jobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdminCommandEvent(String name, Object event) {
        if (name == null || name.startsWith("client.")) {
            return;
        }
        if ("AdminCommandInstance/stateChanged".equals(name) && (((Job)event).getState().equals((Object)AdminCommandState.State.COMPLETED) || ((Job)event).getState().equals((Object)AdminCommandState.State.REVERTED))) {
            Job job = this.attached;
            synchronized (job) {
                this.attached.notifyAll();
            }
        } else {
            this.eventBroker.fireEvent(name, event);
        }
    }

    protected void purgeJob(String jobid) {
        try {
            this.registry.purgeJob(jobid);
            this.registry.purgeCompletedJobForId(jobid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Job attached, JobInfo jobInfo, AdminCommandContext context, String jobName) {
        String jobInitiator;
        ActionReport ar = context.getActionReport();
        String attachedUser = (String)SubjectUtil.getUsernamesFromSubject((Subject)context.getSubject()).get(0);
        if (attached == null && jobInfo == null || attached != null && attached.getName().startsWith("_") || attached != null && COMMAND_NAME.equals(attached.getName())) {
            ar.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ar.setMessage(strings.getLocalString("attach.wrong.commandinstance.id", "Job with id {0} does not exist.", new Object[]{this.jobID}));
            return;
        }
        if (attached != null && !attachedUser.equals(jobInitiator = (String)attached.getSubjectUsernames().get(0))) {
            ar.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ar.setMessage(strings.getLocalString("user.not.authorized", "User {0} not authorized to attach to job {1}", new Object[]{attachedUser, this.jobID}));
            return;
        }
        if (attached != null) {
            AdminCommandEventBroker adminCommandEventBroker;
            AdminCommandEventBroker attachedBroker = attached.getEventBroker();
            CommandProgress commandProgress = attached.getCommandProgress();
            if (commandProgress == null) {
                adminCommandEventBroker = attachedBroker;
                synchronized (adminCommandEventBroker) {
                    this.onAdminCommandEvent("AdminCommandInstance/stateChanged", attached);
                    attachedBroker.registerListener(".*", (AdminCommandEventBroker.AdminCommandListener)this);
                }
            }
            adminCommandEventBroker = commandProgress;
            synchronized (adminCommandEventBroker) {
                this.onAdminCommandEvent("AdminCommandInstance/stateChanged", attached);
                this.onAdminCommandEvent("ProgressStatus/state", attached.getCommandProgress());
                attachedBroker.registerListener(".*", (AdminCommandEventBroker.AdminCommandListener)this);
            }
            adminCommandEventBroker = attached;
            synchronized (adminCommandEventBroker) {
                while (attached.getState().equals((Object)AdminCommandState.State.PREPARED) || attached.getState().equals((Object)AdminCommandState.State.RUNNING) || attached.getState().equals((Object)AdminCommandState.State.RUNNING_RETRYABLE)) {
                    try {
                        attached.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (attached.getState().equals((Object)AdminCommandState.State.COMPLETED) || attached.getState().equals((Object)AdminCommandState.State.REVERTED)) {
                    String commandUser = (String)attached.getSubjectUsernames().get(0);
                    if (commandUser != null && commandUser.equals(attachedUser) && attached.isOutboundPayloadEmpty()) {
                        this.purgeJob(attached.getId());
                    }
                    ar.setActionExitCode(attached.getActionReport().getActionExitCode());
                    ar.appendMessage(strings.getLocalString("attach.finished", "Command {0} executed with status {1}", new Object[]{attached.getName(), attached.getActionReport().getActionExitCode()}));
                }
            }
        }
        if (jobInfo != null && (jobInfo.state.equals(AdminCommandState.State.COMPLETED.toString()) || jobInfo.state.equals(AdminCommandState.State.REVERTED.toString()))) {
            if (attachedUser != null && attachedUser.equals(jobInfo.user)) {
                this.purgeJob(jobInfo.jobId);
            }
            ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            ar.appendMessage(strings.getLocalString("attach.finished", "Command {0} executed{1}", new Object[]{jobName, jobInfo.exitCode}));
        }
    }
}

