/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.FullBtreeDict;
import com.sun.java.help.search.Schema;
import java.io.IOException;
import java.net.URL;

public class BtreeDictCompactor
extends FullBtreeDict {
    private CompactorDictBlock _currentLeaf;
    private byte[] _lastKey = new byte[255];
    private int _lastKeyLength = 0;
    private int _limit;
    private int _nEntries = 0;
    private int _entry = 0;
    private int _counter = 0;
    private InternalBlockState _parent = null;
    private boolean debug = false;

    public BtreeDictCompactor(BtreeDictParameters btreeDictParameters, boolean bl) throws Exception {
        this.init(btreeDictParameters, bl, new BlockFactory(){

            public Block makeBlock() {
                return new CompactorDictBlock();
            }
        });
        this._currentLeaf = new CompactorDictBlock();
        this._currentLeaf.setBlockNumber(this._counter++);
        this._limit = 2038;
        this._entry = this._currentLeaf.firstEntry();
        this.params = btreeDictParameters;
    }

    protected CompactorDictBlock accessBlock1(int n) throws Exception {
        return (CompactorDictBlock)this.blockManager.accessBlock(n);
    }

    public void store(byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < this._lastKeyLength && this._lastKey[n3] == byArray[n3]) {
                ++n3;
            }
            int n4 = 6 + n - n3;
            if (this._entry + n4 <= this._limit) {
                this._currentLeaf.makeEntry(this._entry, byArray, n2, n - n3, n3);
                this._entry += n4;
                ++this._nEntries;
                this._lastKeyLength = n;
                System.arraycopy(byArray, n3, this._lastKey, n3, n - n3);
            } else {
                this._currentLeaf.setFree(this._entry);
                this._currentLeaf.setNumberOfEntries(this._nEntries);
                if (this._parent == null) {
                    this._parent = new InternalBlockState(this._currentLeaf.number);
                }
                this._parent.store(byArray, n, n2, this.newBlock(this._currentLeaf));
                this._entry = this._currentLeaf.firstEntry();
                this._nEntries = 0;
                this._lastKeyLength = 0;
            }
        }
    }

    private int newBlock(BtreeDict.DictBlock dictBlock) {
        int n = this._counter++;
        try {
            this.blockManager.writeBlock(dictBlock);
            dictBlock.setBlockNumber(n);
            this.blockManager.writeBlock(dictBlock);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public void close() throws IOException {
        this._currentLeaf.setFree(this._entry);
        this._currentLeaf.setNumberOfEntries(this._nEntries);
        this.blockManager.writeBlock(this._currentLeaf);
        if (this._parent == null) {
            this.debug("root: " + this._currentLeaf.number);
        } else {
            this._parent.close();
        }
        this.blockManager.close();
    }

    public void compact(BtreeDictParameters btreeDictParameters) throws Exception {
        BtreeDictCompactor btreeDictCompactor = new BtreeDictCompactor(btreeDictParameters, true);
        ((CompactorDictBlock)this.blockManager.accessBlock(this.root)).doMap1(this, btreeDictCompactor);
        btreeDictCompactor.close();
        this.blockManager.close();
    }

    public static void main(String[] stringArray) {
        try {
            Schema schema = new Schema(null, stringArray[0], false);
            BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "TMAP");
            BtreeDictCompactor btreeDictCompactor = new BtreeDictCompactor(btreeDictParameters, false);
            URL uRL = new URL("file", "", stringArray[1]);
            BtreeDictParameters btreeDictParameters2 = new BtreeDictParameters(uRL, 2048, 0, 24);
            btreeDictCompactor.compact(btreeDictParameters2);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("BtreeDictCompactor: " + string);
        }
    }

    private final class InternalBlockState {
        private CompactorDictBlock _block;
        private byte[] _lastKey = new byte[255];
        private int _lastKeyLength;
        private int _entry;
        private int _nEntries;
        private int _limit;
        private InternalBlockState _parent;

        public InternalBlockState(int n) {
            BtreeDictCompactor.this.debug("NEW ROOT " + BtreeDictCompactor.this._counter);
            BtreeDictCompactor.this.debug(BtreeDictCompactor.this.params.toString());
            BtreeDictCompactor.this.params.setRoot(BtreeDictCompactor.this._counter);
            this._block = new CompactorDictBlock();
            this._block.isLeaf = false;
            this._block.setBlockNumber(BtreeDictCompactor.this._counter++);
            this.init(n);
        }

        private void init(int n) {
            this._entry = this._block.firstEntry();
            this._nEntries = 0;
            this._lastKeyLength = 0;
            this._limit = 2028;
            this._block.setChildIndex(0, n);
        }

        public void store(byte[] byArray, int n, int n2, int n3) {
            int n4 = 0;
            while (n4 < this._lastKeyLength && this._lastKey[n4] == byArray[n4]) {
                ++n4;
            }
            int n5 = 6 + n - n4;
            if (this._entry + n5 <= this._limit) {
                this._block.makeEntry(this._entry, byArray, n2, n - n4, n4);
                this._entry += n5;
                ++this._nEntries;
                this._block.setChildIndex(this._nEntries, n3);
                this._limit -= 4;
                this._lastKeyLength = n;
                System.arraycopy(byArray, n4, this._lastKey, n4, n - n4);
            } else {
                BtreeDictCompactor.this.debug("NEW: SPLIT INTERNAL");
                this._block.setFree(this._entry);
                this._block.setNumberOfEntries(this._nEntries);
                if (this._parent == null) {
                    this._parent = new InternalBlockState(this._block.number);
                }
                this._parent.store(byArray, n, n2, BtreeDictCompactor.this.newBlock(this._block));
                this.init(n3);
            }
        }

        public void close() throws IOException {
            this._block.setFree(this._entry);
            this._block.setNumberOfEntries(this._nEntries);
            BtreeDictCompactor.this.blockManager.writeBlock(this._block);
            if (this._parent == null) {
                BtreeDictCompactor.this.debug("root: " + this._block.number);
            } else {
                this._parent.close();
            }
        }
    }

    private final class CompactorDictBlock
    extends FullBtreeDict.FullDictBlock {
        private CompactorDictBlock() {
        }

        private int restoreKey1(int n, byte[] byArray) {
            int n2 = this.entryKeyLength(n);
            int n3 = this.entryCompression(n);
            int n4 = this.entryKey(n);
            while (n2-- > 0) {
                byArray[n3++] = this.data[n4++];
            }
            return n3;
        }

        protected void doMap1(BtreeDictCompactor btreeDictCompactor, BtreeDictCompactor btreeDictCompactor2) throws Exception {
            byte[] byArray = new byte[255];
            int n = this.free();
            int n2 = this.firstEntry();
            if (this.isLeaf) {
                while (n2 < n) {
                    btreeDictCompactor2.store(byArray, this.restoreKey1(n2, byArray), this.entryID(n2));
                    n2 = this.nextEntry(n2);
                }
            } else {
                btreeDictCompactor.lock(this);
                int n3 = 0;
                while (n2 < n) {
                    btreeDictCompactor.accessBlock1(this.getChildIdx(n3)).doMap1(btreeDictCompactor, btreeDictCompactor2);
                    btreeDictCompactor2.store(byArray, this.restoreKey1(n2, byArray), this.entryID(n2));
                    n2 = this.nextEntry(n2);
                    ++n3;
                }
                btreeDictCompactor.accessBlock1(this.getChildIdx(n3)).doMap1(btreeDictCompactor, btreeDictCompactor2);
                btreeDictCompactor.unlock(this);
            }
        }
    }
}

