/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.WorkContextHandler;
import com.sun.enterprise.connectors.ActiveResourceAdapterImpl;
import com.sun.enterprise.connectors.BootstrapContextImpl;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ConnectorJavaBeanValidator;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.beans.AdministeredObjectResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="ActiveOutboundResourceAdapter")
@PerLookup
public class ActiveOutboundResourceAdapter
extends ActiveResourceAdapterImpl {
    @Inject
    private ConnectorJavaBeanValidator beanValidator;
    protected ResourceAdapter resourceadapter_;
    protected static final Logger _logger = LogDomains.getLogger(ActiveOutboundResourceAdapter.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private final StringManager localStrings = StringManager.getManager(ActiveOutboundResourceAdapter.class);
    protected BootstrapContext bootStrapContextImpl;

    @Override
    public void init(ResourceAdapter ra, ConnectorDescriptor desc, String moduleName, ClassLoader jcl) throws ConnectorRuntimeException {
        super.init(ra, desc, moduleName, jcl);
        this.resourceadapter_ = ra;
        if (this.resourceadapter_ != null) {
            try {
                this.loadRAConfiguration();
                this.beanValidator.validateJavaBean(ra, moduleName);
                ConnectorRegistry registry = ConnectorRegistry.getInstance();
                String poolId = null;
                ResourceAdapterConfig raConfig = registry.getResourceAdapterConfig(this.moduleName_);
                if (raConfig != null) {
                    poolId = raConfig.getThreadPoolIds();
                }
                this.bootStrapContextImpl = new BootstrapContextImpl(poolId, this.moduleName_, jcl);
                this.validateWorkContextSupport(desc);
                this.startResourceAdapter(this.bootStrapContextImpl);
            }
            catch (ResourceAdapterInternalException ex) {
                _logger.log(Level.SEVERE, "rardeployment.start_failed", ex);
                String i18nMsg = this.localStrings.getString("rardeployment.start_failed", (Object)ex.getMessage());
                ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
                cre.initCause((Throwable)ex);
                throw cre;
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "rardeployment.start_failed", t);
                String i18nMsg = this.localStrings.getString("rardeployment.start_failed", (Object)t.getMessage());
                ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
                if (t.getCause() != null) {
                    cre.initCause(t.getCause());
                } else {
                    cre.initCause(t);
                }
                throw cre;
            }
        }
    }

    private void validateWorkContextSupport(ConnectorDescriptor desc) throws ConnectorRuntimeException {
        Set workContexts = desc.getRequiredWorkContexts();
        Iterator workContextsIterator = workContexts.iterator();
        WorkContextHandler workContextHandler = this.connectorRuntime_.getWorkContextHandler();
        workContextHandler.init(this.moduleName_, this.jcl_);
        while (workContextsIterator.hasNext()) {
            String ic = (String)workContextsIterator.next();
            boolean supported = workContextHandler.isContextSupported(true, ic);
            if (supported) continue;
            String errorMsg = "Unsupported work context [ " + ic + " ] ";
            Object[] params = new Object[]{ic, desc.getName()};
            _logger.log(Level.WARNING, "unsupported.work.context", params);
            throw new ConnectorRuntimeException(errorMsg);
        }
    }

    protected void startResourceAdapter(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.resourceadapter_.start(bootstrapContext);
    }

    @Override
    public boolean handles(ConnectorDescriptor cd, String moduleName) {
        boolean adminObjectsDefined = false;
        Set adminObjects = cd.getAdminObjects();
        if (adminObjects != null && !adminObjects.isEmpty()) {
            adminObjectsDefined = true;
        }
        boolean canHandle = false;
        if (!cd.getInBoundDefined()) {
            if (cd.getOutBoundDefined() && cd.getOutboundResourceAdapter().getConnectionDefs().size() > 1) {
                canHandle = true;
            } else if (adminObjectsDefined) {
                canHandle = true;
            } else if (!cd.getResourceAdapterClass().equals("")) {
                canHandle = true;
            }
        }
        return canHandle;
    }

    @Override
    public ResourceAdapter getResourceAdapter() {
        return this.resourceadapter_;
    }

    @Override
    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null || this.connectionDefs_.length == 0) {
            return;
        }
        if (this.isServer() && !this.isSystemRar(this.moduleName_)) {
            this.createAllConnectorResources();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Completed Active Resource adapter setup", this.moduleName_);
        }
    }

    @Override
    public void destroy() {
        if (this.connectionDefs_ != null && this.connectionDefs_.length != 0) {
            super.destroy();
        }
        this.stopResourceAdapter();
    }

    private void stopResourceAdapter() {
        if (this.resourceadapter_ != null) {
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Calling Resource Adapter stop" + this.getModuleName());
                }
                this.resourceadapter_.stop();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Resource Adapter stop call of " + this.getModuleName() + " returned successfully");
                    _logger.fine("rar_stop_call_successful");
                }
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "rardeployment.stop_warning", t);
            }
            finally {
                this.removeProxiesFromRegistry(this.moduleName_);
            }
        }
    }

    private void removeProxiesFromRegistry(String moduleName_) {
        ConnectorRuntime.getRuntime().removeWorkManagerProxy(moduleName_);
    }

    @Override
    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool pool, ClassLoader jcl) {
        ManagedConnectionFactory mcf = super.createManagedConnectionFactory(pool, jcl);
        if (mcf instanceof ResourceAdapterAssociation) {
            try {
                ((ResourceAdapterAssociation)mcf).setResourceAdapter(this.resourceadapter_);
            }
            catch (ResourceException ex) {
                _logger.log(Level.SEVERE, "rardeployment.assoc_failed", ex);
            }
        }
        return mcf;
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        try {
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            ResourceAdapterConfig raConfig = registry.getResourceAdapterConfig(this.moduleName_);
            ArrayList<Property> raConfigProps = new ArrayList<Property>();
            Set<ConnectorConfigProperty> mergedProps = this.mergeRAConfiguration(raConfig, raConfigProps);
            this.logMergedProperties(mergedProps);
            SetMethodAction<ConnectorConfigProperty> setMethodAction = new SetMethodAction<ConnectorConfigProperty>(this.resourceadapter_, mergedProps);
            setMethodAction.run();
        }
        catch (Exception e) {
            String i18nMsg = this.localStrings.getString("ccp_adm.wrong_params_for_create", (Object)e.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)e);
            throw cre;
        }
    }

    protected Set<ConnectorConfigProperty> mergeRAConfiguration(ResourceAdapterConfig raConfig, List<Property> raConfigProps) {
        if (raConfig != null) {
            raConfigProps = raConfig.getProperty();
        }
        Set<ConnectorConfigProperty> mergedProps = ConnectorDDTransformUtils.mergeProps(raConfigProps, this.getDescriptor().getConfigProperties());
        return mergedProps;
    }

    private void logMergedProperties(Set<ConnectorConfigProperty> mergedProps) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Passing in the following properties before calling RA.start of " + this.moduleName_);
            StringBuilder b = new StringBuilder();
            for (ConnectorConfigProperty element : mergedProps) {
                b.append("\nName: " + element.getName() + " Value: " + element.getValue());
            }
            _logger.fine(b.toString());
        }
    }

    public BootstrapContext getBootStrapContext() {
        return this.bootStrapContextImpl;
    }

    public void addAdminObject(String appName, String connectorName, ResourceInfo resourceInfo, String adminObjectType, String adminObjectClassName, Properties props) throws ConnectorRuntimeException {
        ConnectorConfigProperty[] envProps;
        AdminObject adminObject;
        if (props == null) {
            props = new Properties();
        }
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        ConnectorDescriptor desc = registry.getDescriptor(connectorName);
        if (adminObjectClassName == null || adminObjectClassName.isBlank()) {
            adminObjects = desc.getAdminObjectsByType(adminObjectType);
            if (adminObjects.size() > 1) {
                String msg = this.localStrings.getString("aor.could_not_determine_aor_type", (Object)adminObjectType);
                throw new ConnectorRuntimeException(msg);
            }
            adminObject = adminObjects.isEmpty() ? null : (AdminObject)adminObjects.get(0);
        } else if (adminObjectType == null || adminObjectType.isBlank()) {
            adminObjects = desc.getAdminObjectsByClass(adminObjectClassName);
            if (adminObjects.size() > 1) {
                String msg = this.localStrings.getString("aor.could_not_determine_aor_class", (Object)adminObjectClassName);
                throw new ConnectorRuntimeException(msg);
            }
            adminObject = adminObjects.isEmpty() ? null : (AdminObject)adminObjects.get(0);
        } else {
            adminObject = desc.getAdminObject(adminObjectType, adminObjectClassName);
        }
        if (adminObject == null) {
            String msg = this.localStrings.getString("aor.could_not_determine_aor", (Object)adminObjectType, (Object)adminObjectClassName);
            throw new ConnectorRuntimeException(msg);
        }
        AdministeredObjectResource aor = new AdministeredObjectResource(resourceInfo);
        aor.initialize(adminObject);
        aor.setResourceAdapter(connectorName);
        for (ConnectorConfigProperty envProp : envProps = (ConnectorConfigProperty[])adminObject.getConfigProperties().toArray(ConnectorConfigProperty[]::new)) {
            String name = envProp.getName();
            String userValue = (String)props.remove(name);
            if (userValue == null) {
                aor.addConfigProperty(envProp);
                continue;
            }
            aor.addConfigProperty(new ConnectorConfigProperty(name, userValue, userValue, envProp.getType()));
        }
        for (String string : props.keySet()) {
            String userValue = props.getProperty(string);
            if (userValue == null) continue;
            aor.addConfigProperty(new ConnectorConfigProperty(string, userValue, userValue));
        }
        try {
            Reference reference = aor.createAdminObjectReference();
            this.connectorRuntime_.getResourceNamingService().publishObject((GenericResourceInfo)resourceInfo, (Object)reference, true);
        }
        catch (NamingException namingException) {
            String i18nMsg = this.localStrings.getString("aira.cannot_bind_admin_obj");
            throw new ConnectorRuntimeException(i18nMsg, (Throwable)namingException);
        }
    }
}

