/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.logging.LogStringsMessages;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimestampFilter {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        if (!context.isInboundMessage()) {
            if (context.timestampExported()) {
                return;
            }
            TimestampPolicy policy = (TimestampPolicy)context.getSecurityPolicy();
            long timeout = policy.getTimeout();
            String created = policy.getCreationTime();
            String id = policy.getUUID();
            if (context.getTimestampTimeout() > 0L) {
                timeout = context.getTimestampTimeout();
            }
            if (context.makeDynamicPolicyCallback()) {
                TimestampPolicy policyClone = (TimestampPolicy)policy.clone();
                try {
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(false);
                    DynamicPolicyCallback callback = new DynamicPolicyCallback(policyClone, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(callback, context.getSecurityEnvironment().getCallbackHandler());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Message does not conform to time stamp policy", e);
                    throw new XWSSecurityException(e);
                }
                timeout = policyClone.getTimeout();
                created = policyClone.getCreationTime();
            }
            TimestampFilter.setTimestamp(context, timeout, created, id);
            context.timestampExported(true);
        } else {
            Timestamp timestamp = null;
            if (context.getMode() == 0) {
                SOAPElement ts;
                long timeStampFreshness;
                long maxClockSkew;
                block26: {
                    if (context.makeDynamicPolicyCallback()) {
                        TimestampPolicy policyClone = (TimestampPolicy)((TimestampPolicy)context.getSecurityPolicy()).clone();
                        try {
                            DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                            dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                            dynamicContext.inBoundMessage(true);
                            DynamicPolicyCallback callback = new DynamicPolicyCallback(policyClone, dynamicContext);
                            ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                            HarnessUtil.makeDynamicPolicyCallback(callback, context.getSecurityEnvironment().getCallbackHandler());
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.filter.LogStringsMessages.WSS_1436_MESSAGE_DOESNOT_CONFORM_TIMESTAMP_POLICY(), e);
                            throw new XWSSecurityException(e);
                        }
                        context.setSecurityPolicy(policyClone);
                    }
                    TimestampPolicy policy = (TimestampPolicy)context.getSecurityPolicy();
                    maxClockSkew = policy.getMaxClockSkew();
                    timeStampFreshness = policy.getTimestampFreshness();
                    com.sun.xml.wss.core.SecurityHeader secHeader = context.getSecurableSoapMessage().findSecurityHeader();
                    if (secHeader == null) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0276_INVALID_POLICY_NO_TIMESTAMP_SEC_HEADER());
                        throw new XWSSecurityException("Message does not conform to Timestamp policy: wsu:Timestamp element not found in header");
                    }
                    ts = null;
                    try {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        Name name = factory.createName("Timestamp", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                        Iterator<Node> i = secHeader.getChildElements(name);
                        if (i.hasNext()) {
                            ts = (SOAPElement)i.next();
                            if (i.hasNext()) {
                                log.log(Level.SEVERE, LogStringsMessages.BSP_3227_SINGLE_TIMESTAMP());
                                throw new XWSSecurityException("More than one wsu:Timestamp element in the header");
                            }
                            break block26;
                        }
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0276_INVALID_POLICY_NO_TIMESTAMP_SEC_HEADER());
                        throw new XWSSecurityException("Message does not conform to Timestamp policy: wsu:Timestamp element not found in header");
                    }
                    catch (SOAPException se) {
                        throw new XWSSecurityRuntimeException(se);
                    }
                }
                try {
                    timestamp = new Timestamp(ts);
                }
                catch (XWSSecurityException xwsse) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.filter.LogStringsMessages.WSS_1429_ERROR_TIMESTAMP_INTERNALIZATION(), xwsse);
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Failure in Timestamp internalization.\nMessage is: " + xwsse.getMessage(), xwsse);
                }
                try {
                    context.getSecurityEnvironment().validateTimestamp(context.getExtraneousProperties(), timestamp, maxClockSkew, timeStampFreshness);
                }
                catch (XWSSecurityException xwsse) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.filter.LogStringsMessages.WSS_1430_ERROR_TIMESTAMP_VALIDATION(), xwsse);
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Failure in Timestamp validation.\nMessage is: " + xwsse.getMessage(), xwsse);
                }
            }
            if (context.getMode() == 1) {
                throw new XWSSecurityException("Internal Error: Called TimestampFilter in POSTHOC Mode");
            }
            if (context.getMode() == 3) {
                TimestampPolicy ts = new TimestampPolicy();
                context.getInferredSecurityPolicy().append(ts);
            }
            com.sun.xml.wss.core.SecurityHeader secHeader = context.getSecurableSoapMessage().findSecurityHeader();
            try {
                timestamp = (Timestamp)SecurityHeaderBlockImpl.fromSoapElement(secHeader.getCurrentHeaderElement(), Timestamp.class);
            }
            catch (XWSSecurityException xwsse) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.filter.LogStringsMessages.WSS_1429_ERROR_TIMESTAMP_INTERNALIZATION(), xwsse);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Failure in Timestamp internalization.\nMessage is: " + xwsse.getMessage(), xwsse);
            }
            try {
                context.getSecurityEnvironment().validateTimestamp(context.getExtraneousProperties(), timestamp, 300000L, 300000L);
            }
            catch (XWSSecurityException xwsse) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.filter.LogStringsMessages.WSS_1430_ERROR_TIMESTAMP_VALIDATION(), xwsse);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Failure in Timestamp validation.\nMessage is: " + xwsse.getMessage(), xwsse);
            }
        }
    }

    private static void setTimestamp(FilterProcessingContext context, Long timeout, String created, String id) throws XWSSecurityException {
        if (context instanceof JAXBFilterProcessingContext) {
            JAXBFilterProcessingContext optContext = (JAXBFilterProcessingContext)context;
            SecurityHeader secHeader = optContext.getSecurityHeader();
            com.sun.xml.ws.security.opt.impl.tokens.Timestamp wsuTimestamp = new com.sun.xml.ws.security.opt.impl.tokens.Timestamp(optContext.getSOAPVersion());
            wsuTimestamp.setTimeout(timeout);
            if (id != null) {
                wsuTimestamp.setId(id);
            }
            wsuTimestamp.createDateTime();
            secHeader.add(wsuTimestamp);
        } else {
            com.sun.xml.wss.core.SecurityHeader secHeader = context.getSecurableSoapMessage().findOrCreateSecurityHeader();
            Timestamp wsuTimestamp = new Timestamp();
            if ("".equals(created)) {
                wsuTimestamp.setCreated(null);
            } else {
                wsuTimestamp.setCreated(created);
            }
            wsuTimestamp.setTimeout(timeout);
            if (id != null) {
                wsuTimestamp.setId(id);
            }
            secHeader.insertHeaderBlock(wsuTimestamp);
        }
    }
}

