/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.webservices.SOAPMessageContext;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.MessageTrace;
import org.glassfish.webservices.monitoring.TransportInfo;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class MessageTraceImpl
implements MessageTrace {
    private Endpoint source;
    private String soapMessage = null;
    private TransportInfo transportInfo = null;

    @Override
    public String getMessage(boolean includeHeaders) {
        if (this.soapMessage != null) {
            if (includeHeaders) {
                return this.soapMessage;
            }
            Pattern p = Pattern.compile("<env:Body>.*</env:Body>");
            Matcher m = p.matcher(this.soapMessage);
            if (m.find()) {
                return this.soapMessage.substring(m.start(), m.end());
            }
            return this.soapMessage;
        }
        return null;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.source;
    }

    public void setMessageContext(SOAPMessageContext soapMessageCtx) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            soapMessageCtx.getMessage().writeTo((OutputStream)baos);
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "AS-WSJSR109IMPL-00107", e.getMessage());
        }
        this.soapMessage = baos.toString();
    }

    public void setEndpoint(Endpoint source) {
        this.source = source;
    }

    @Override
    public TransportInfo getTransportInfo() {
        return this.transportInfo;
    }

    public void setTransportInfo(TransportInfo info) {
        this.transportInfo = info;
    }
}

