/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;

public class BuiltInTypes {
    private static final Set<Class<?>> BUILD_IN_SUPPORT;

    private BuiltInTypes() {
        throw new IllegalStateException("Util class cannot be instantiated");
    }

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }

    public static boolean isKnownType(Class<?> clazz) {
        boolean knownContainerValueType = Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || JsonValue.class.isAssignableFrom(clazz) || Optional.class.isAssignableFrom(clazz) || clazz.isArray();
        return knownContainerValueType || BuiltInTypes.findIfClassIsSupported(clazz);
    }

    private static boolean findIfClassIsSupported(Class<?> clazz) {
        Class<?> current = clazz;
        do {
            if (!BUILD_IN_SUPPORT.contains(current)) continue;
            return true;
        } while ((current = current.getSuperclass()) != null);
        return false;
    }

    static {
        HashSet<Class<Object>> buildInTypes = new HashSet<Class<Object>>();
        buildInTypes.add(Byte.class);
        buildInTypes.add(Byte.TYPE);
        buildInTypes.add(BigDecimal.class);
        buildInTypes.add(BigInteger.class);
        buildInTypes.add(Boolean.class);
        buildInTypes.add(Boolean.TYPE);
        buildInTypes.add(Calendar.class);
        buildInTypes.add(Character.class);
        buildInTypes.add(Character.TYPE);
        buildInTypes.add(java.util.Date.class);
        buildInTypes.add(Double.class);
        buildInTypes.add(Double.TYPE);
        buildInTypes.add(Duration.class);
        buildInTypes.add(Float.class);
        buildInTypes.add(Float.TYPE);
        buildInTypes.add(Integer.class);
        buildInTypes.add(Integer.TYPE);
        buildInTypes.add(Instant.class);
        buildInTypes.add(LocalDateTime.class);
        buildInTypes.add(LocalDate.class);
        buildInTypes.add(LocalTime.class);
        buildInTypes.add(Long.class);
        buildInTypes.add(Long.TYPE);
        buildInTypes.add(Number.class);
        buildInTypes.add(OffsetDateTime.class);
        buildInTypes.add(OffsetTime.class);
        buildInTypes.add(OptionalDouble.class);
        buildInTypes.add(OptionalInt.class);
        buildInTypes.add(OptionalLong.class);
        buildInTypes.add(Path.class);
        buildInTypes.add(Period.class);
        buildInTypes.add(Short.class);
        buildInTypes.add(Short.TYPE);
        buildInTypes.add(String.class);
        buildInTypes.add(TimeZone.class);
        buildInTypes.add(URI.class);
        buildInTypes.add(URL.class);
        buildInTypes.add(UUID.class);
        if (BuiltInTypes.isClassAvailable("javax.xml.datatype.XMLGregorianCalendar")) {
            buildInTypes.add(XMLGregorianCalendar.class);
        }
        buildInTypes.add(ZonedDateTime.class);
        buildInTypes.add(ZoneId.class);
        buildInTypes.add(ZoneOffset.class);
        if (BuiltInTypes.isClassAvailable("java.sql.Date")) {
            buildInTypes.add(Date.class);
            buildInTypes.add(Timestamp.class);
        }
        BUILD_IN_SUPPORT = Set.copyOf(buildInTypes);
    }
}

